/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.gisconnectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISGroupInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISStyleInformation;

public class GISInformation {
    private String geoNetworkUrl;
    private String geoNetworkUserName;
    private String geoNetworkPwd;
    private String gisUrl;
    private String gisUserName;
    private String gisPwd;
    private String gisDataStore;
    private String gisWorkspace;
    private GISGroupInformation group;
    private List<GISLayerInformation> layers = new ArrayList<GISLayerInformation>();
    private Map<String, List<GISStyleInformation>> styles = new HashMap<String, List<GISStyleInformation>>();

    public void clean() {
        this.layers = new ArrayList<GISLayerInformation>();
        this.styles = new HashMap<String, List<GISStyleInformation>>();
    }

    public String getGisUrl() {
        return this.gisUrl;
    }

    public void setGisUrl(String gisUrl) {
        this.gisUrl = gisUrl;
    }

    public String getGisUserName() {
        return this.gisUserName;
    }

    public void setGisUserName(String gisUserName) {
        this.gisUserName = gisUserName;
    }

    public String getGisPwd() {
        return this.gisPwd;
    }

    public void setGisPwd(String gisPwd) {
        this.gisPwd = gisPwd;
    }

    public void setGroup(GISGroupInformation group) {
        this.group = group;
    }

    public GISGroupInformation getGroup() {
        return this.group;
    }

    public void setLayers(List<GISLayerInformation> layers) {
        this.layers = layers;
    }

    public List<GISLayerInformation> getLayers() {
        return this.layers;
    }

    public void addLayer(GISLayerInformation layer) {
        this.layers.add(layer);
    }

    public void addStyle(String layer, GISStyleInformation style) {
        List<GISStyleInformation> listOfStyles = this.styles.get(layer);
        if (listOfStyles == null) {
            listOfStyles = new ArrayList<GISStyleInformation>();
        }
        listOfStyles.add(style);
        this.styles.put(layer, listOfStyles);
    }

    public void setStyles(Map<String, List<GISStyleInformation>> styles) {
        this.styles = styles;
    }

    public Map<String, List<GISStyleInformation>> getStyles() {
        return this.styles;
    }

    public ArrayList<String> getStylesNames(String layerName) {
        ArrayList<String> stylesNames = new ArrayList<String>();
        List<GISStyleInformation> stylel = this.styles.get(layerName);
        if (stylel != null) {
            for (GISStyleInformation style : stylel) {
                stylesNames.add(style.getStyleName());
            }
        }
        return stylesNames;
    }

    public ArrayList<String> getAllStylesNames() {
        ArrayList<String> stylesNames = new ArrayList<String>();
        for (List<GISStyleInformation> stylel : this.styles.values()) {
            if (stylel == null) continue;
            for (GISStyleInformation style : stylel) {
                stylesNames.add(style.getStyleName());
            }
        }
        return stylesNames;
    }

    public void setGisDataStore(String gisDataStore) {
        this.gisDataStore = gisDataStore;
    }

    public String getGisDataStore() {
        return this.gisDataStore;
    }

    public void setGisWorkspace(String gisWorkspace) {
        this.gisWorkspace = gisWorkspace;
    }

    public String getGisWorkspace() {
        return this.gisWorkspace;
    }

    public String getGeoNetworkUrl() {
        return this.geoNetworkUrl;
    }

    public void setGeoNetworkUrl(String geoNetworkUrl) {
        this.geoNetworkUrl = geoNetworkUrl;
    }

    public String getGeoNetworkUserName() {
        return this.geoNetworkUserName;
    }

    public void setGeoNetworkUserName(String geoNetworkUserName) {
        this.geoNetworkUserName = geoNetworkUserName;
    }

    public String getGeoNetworkPwd() {
        return this.geoNetworkPwd;
    }

    public void setGeoNetworkPwd(String geoNetworkPwd) {
        this.geoNetworkPwd = geoNetworkPwd;
    }
}

