/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;

public class VTICache
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap<String, Tuple<String>> cache = new HashMap();
    public String cacheFile;
    static VTICache singletonCache;
    static int maxElements;

    public VTICache(String cacheFile) {
        this.cacheFile = cacheFile;
    }

    public Tuple<String> getCachedElement(String timeSeriesName) {
        return this.cache.get(timeSeriesName);
    }

    public void removeCachedElement(String timeSeriesName) {
        this.cache.remove(timeSeriesName);
        try {
            VTICache.saveCache(this, this.cacheFile);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Error: Impossible to save cache file");
        }
    }

    public void addCacheElement(String timeSeriesName, String ... identifiers) {
        Iterator<String> i$;
        Tuple<String> groupAnFilter = new Tuple<String>(identifiers);
        if (this.cache.size() > maxElements && (i$ = this.cache.keySet().iterator()).hasNext()) {
            String key = i$.next();
            this.cache.remove(key);
        }
        this.cache.put(timeSeriesName, groupAnFilter);
        try {
            VTICache.saveCache(this, this.cacheFile);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Error: Impossible to save cache file");
        }
    }

    public static void initInstance(String filePath) throws Exception {
        VTICache.getInstance(filePath);
    }

    public static VTICache getInstance(String filePath) throws Exception {
        if (singletonCache == null) {
            try {
                singletonCache = VTICache.getCache(filePath);
            }
            catch (Exception e) {
                singletonCache = new VTICache(filePath);
            }
        }
        return singletonCache;
    }

    public static void addToCache(String timeSeriesName, String geoServerGroup) throws Exception {
        if (singletonCache != null) {
            singletonCache.addCacheElement(timeSeriesName, geoServerGroup);
        }
    }

    public static VTICache getCache(String filePath) throws Exception {
        ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(new File(filePath)));
        VTICache g = (VTICache)inputStream.readObject();
        inputStream.close();
        return g;
    }

    public static void saveCache(VTICache cache, String filePath) throws Exception {
        ObjectOutputStream outStream = new ObjectOutputStream(new FileOutputStream(new File(filePath)));
        outStream.writeObject(cache);
        outStream.close();
    }

    static {
        maxElements = 2000;
    }
}

