package org.gcube.contentmanagement.timeseriesservice.calls.importer;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.timeseriesservice.calls.RSWrapper;
import org.gcube.contentmanagement.timeseriesservice.stubs.DenormalizedImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetProgressResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.ImportManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;


public class ImporterServiceCall {
	
	private ImportManagerPortType importerManagerPT;
	
	public ImporterServiceCall(EndpointReferenceType epr, GCUBEScope scope,
			GCUBESecurityManager securityManager) throws Exception{
		this.importerManagerPT= GCUBERemotePortTypeContext.getProxy(new ImportManagerServiceAddressingLocator().getImportManagerPortTypePort(epr), scope, securityManager);
	}
	
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterServiceCallInterface#importData(org.gcube.contentmanagement.timeseriesservice.stubs.calls.RSWrapper, char, java.lang.String, boolean)
	 */
	public void importData(RSWrapper rsWrapper, char delimiter, String encoding, boolean hasHeader, boolean[] fieldsMask) throws Exception{
		
		importerManagerPT.importOperation(new ImportRequest(new String(new char[]{delimiter}), encoding, fieldsMask, hasHeader, rsWrapper.getLocator().toString() ));
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterServiceCallInterface#getImportState()
	 */
	public Status getImportState() throws Exception{
		return importerManagerPT.getImportState(new VOID());
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterServiceCallInterface#getDataAsJson(org.gcube.contentmanagement.timeseriesservice.stubs.Limit)
	 */
	public String getDataAsJson(Limit limit) throws Exception{
		return importerManagerPT.getDataAsJson(limit);
	}
	
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterServiceCallInterface#getProgress()
	 */
	public GetProgressResponse getProgress() throws Exception{
		return importerManagerPT.getProgress(new VOID());
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.ImporterServiceCallInterface#getColumnsDefinition()
	 */
	public ColumnDefinition[] getColumnsDefinition() throws Exception{
		return importerManagerPT.getColumnsDefinition(new VOID()).getColumnDefinition();
	}


	public String exportAsCsv(boolean hasHeader, String separator,
			String encoding, boolean[] fieldsMask) throws Exception {
		return importerManagerPT.exportAsCsv(new ExportRequest(separator, encoding, fieldsMask, hasHeader));
	}

	public void importData(RSWrapper rsWrapper, char delimiter,
			String encoding, boolean hasHeader, boolean[] fieldsMask,
			boolean[] attributeFieldsMask, String attributeLabel,
			String valueLabel) throws Exception {
		importerManagerPT.denormalizedImportOperation(new DenormalizedImportRequest(attributeLabel,new String(new char[]{delimiter}), encoding, attributeFieldsMask, fieldsMask, hasHeader, rsWrapper.getLocator().toString(), valueLabel));
		
	}
}
