package org.gcube.contentmanagement.timeseriesservice.calls.timeseries;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.timeseriesservice.stubs.AddFAOAreasRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregateRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregationFunction;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChangeColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChartDataRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CompatibleColumnsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.DenormalizeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.DistinctValuesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnrichRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetAllDataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetAreaTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetSpaceSpeciesTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetSpaceTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTimeCountriesTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetFishingMontlyEffortRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupElement;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.IsUnionAllowedRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationsListArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeSeriesManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.TsFilterRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.UnionRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.TimeSeriesManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.CompatibleColumnsMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FieldMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.PublishingLevel;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.TimeseriesHistory;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurrentState;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTransformationStatusResponse;

public class TimeSeriesServiceCall {
	
	private TimeSeriesManagerPortType tsManagerPT;
	private String user;
	
	
	public TimeSeriesServiceCall(String user,EndpointReferenceType epr, GCUBEScope scope,
			GCUBESecurityManager securityManager) throws Exception{
		this.user=user;
		tsManagerPT= new TimeSeriesManagerServiceAddressingLocator().getTimeSeriesManagerPortTypePort(epr);
		tsManagerPT= GCUBERemotePortTypeContext.getProxy(tsManagerPT, scope, securityManager);
	}
			
	public ColumnDefinition[] getDimensions() throws Exception{
		return tsManagerPT.getColumnsDefinition(user).getColumnDefinition();
	}
	
	public Status getInitializingState() throws Exception{
		return tsManagerPT.getInitializationState(new VOID());
	}
	
	public String getAllDataAsJSon(Limit limit, Order order) throws Exception{
		return tsManagerPT.getAllDataAsJson(new GetAllDataAsJsonRequest(limit, order,this.user));
	}

	
	public String exportAsCsv(boolean hasHeader, String delimiter, String encoding, boolean[] fieldsMask) throws Exception {
		return tsManagerPT.exportAsCsv(new ExportRequest(delimiter, encoding,fieldsMask, hasHeader));
	}

	public void filter(FilterCondition filter) throws Exception {
		tsManagerPT.tsFilter(new TsFilterRequest(filter, this.user));
	}

	public void union(String timeSeriesId, FieldMapping ... fieldsMappings) throws Exception {
		tsManagerPT.union(new UnionRequest(fieldsMappings,timeSeriesId,this.user));
	}
	
	public void changeColumn(String fieldId, String keyId) throws Exception {
		tsManagerPT.changeColumn(new ChangeColumnRequest(fieldId, keyId, this.user));
	}
	
	public long getElementCount() throws Exception {
		return tsManagerPT.getElementsCount(this.user);
	}

	public void discardCurrentOperation() throws Exception {
		tsManagerPT.discardCurrentOperation(this.user);
	}

	public OperationType getCurrentOperation() throws Exception {
		return tsManagerPT.getCurrentOperation(this.user);
	}
	
	public CurrentState getCurrentState() throws Exception {
		return tsManagerPT.getCurrentState(this.user);
	}

	public FilterCondition getFilter() throws Exception {
		return tsManagerPT.getFilter(this.user);
	}
	
	public boolean isUnionAllowed(String otherResource) throws Exception {
		return tsManagerPT.isUnionAllowed(new IsUnionAllowedRequest(otherResource, this.user)); 
	}

	public void publish(PublishingLevel ... level) throws Exception {
		if (level==null || level.length==0 || level[0]==PublishingLevel.VRE){
			//publishsing at VRE level by default
			tsManagerPT.publish(PublishingLevel.VRE);	
		}else
			tsManagerPT.publish(PublishingLevel.VO);
	}

	public void denormalization(String attributeFieldId, String valueFieldId)
			throws Exception {
		tsManagerPT.denormalize(new DenormalizeRequest(attributeFieldId, user, valueFieldId));
	}

	public void aggregate(AggregationFunction aggregationFuction,
			String... fieldsId) throws Exception {
		tsManagerPT.aggregate(new AggregateRequest(aggregationFuction, fieldsId, user));
	}

	public void group(AggregationFunction aggregationFuction,
			GroupElement... groupList) throws Exception {
		tsManagerPT.group(new GroupRequest(aggregationFuction, groupList, user));
	}

	public void enrich(String messageIdColumn, String rawDatesColumn, String speedColumn, String vesselIDColumn, String xDimensionColumn, String yDimensionColumn) throws Exception {
		tsManagerPT.enrich(new EnrichRequest(messageIdColumn, rawDatesColumn, speedColumn, user, vesselIDColumn, xDimensionColumn, yDimensionColumn));
	}
	
	public void addFAOAreas(String messageIdColumn, String xDimensionColumn, String yDimensionColumn) throws Exception {
		tsManagerPT.addFAOAreas(new AddFAOAreasRequest(messageIdColumn, user,xDimensionColumn, yDimensionColumn));
	}
	
	public void discardAllOperations() throws Exception {
		tsManagerPT.discardAllOperations(user);
		
	}

	public OperationType[] getOperationsList() throws Exception {
		OperationsListArray ola=tsManagerPT.getOperationsList(user);
		if (ola.getOperationsList()==null) return new OperationType[0];
		else return ola.getOperationsList();
	}

	
	public TimeseriesHistory getHistory() throws Exception {
		return tsManagerPT.getHistory(new VOID());
	}

	
	public CompatibleColumnsMapping[] getCompatibleColumns(String timeSeriesId)
			throws Exception {
		return tsManagerPT.getCompatibleColumns(new CompatibleColumnsRequest(timeSeriesId, this.user)).getCompatibleColumnsMappingList();
	}

	public String getChartData(int maxDimension, String xDimension,
			String yDimension, String groupDimension, String attributeColumn,
			String[] filters, String[] areas) throws Exception {
		ChartDataRequest request = new ChartDataRequest();
		if (areas!=null)request.setAreas(new StringArray(areas));
		if (filters!=null)request.setFilters(new StringArray(filters));
		request.setAttributeColumn(attributeColumn);
		request.setGroupDimension(groupDimension);
		request.setXDimension(xDimension);
		request.setYDimension(yDimension);
		request.setMaxDimension(maxDimension);
		return tsManagerPT.getChartData(request);
	}

	public String[] getDistinctValues(String fieldId, Limit ... limit) throws Exception {
		DistinctValuesRequest distinctvaluesRequest;
		
		if (limit!=null && limit.length>0 ) distinctvaluesRequest = new DistinctValuesRequest(fieldId, limit[0]);
		else distinctvaluesRequest = new DistinctValuesRequest(fieldId, null);
		
		String[] items = tsManagerPT.getDistinctValues(distinctvaluesRequest).getItems();
		if (items!=null) return items;
		else return new String[0];
	}

	public String getAreaTransformationResult(String aggregationColumn, String quantitiesColumn) throws Exception{
		return tsManagerPT.getAreaTransformationResult(new GetAreaTransformationResultRequest(aggregationColumn, quantitiesColumn, user));
	}
	
	public String getSpaceTransformationResult(String aggregationColumn, String quantitiesColumn) throws Exception{
		return tsManagerPT.getSpaceTransformationResult(new GetSpaceTransformationResultRequest(aggregationColumn, quantitiesColumn, user));
	}
	
	public String getTimeCountriesTransformationResult(String aggregationColumn, String informationColumn, String quantitiesColumn) throws Exception{
		return tsManagerPT.getTimeCountriesTransformationResult(new GetTimeCountriesTransformationResultRequest(aggregationColumn, informationColumn, quantitiesColumn, user));
	}
	
	public String getSpaceSpeciesTransformationResult(String aggregationColumn, String informationColumn, String quantitiesColumn) throws Exception{
		return tsManagerPT.getSpaceSpeciesTransformationResult(new GetSpaceSpeciesTransformationResultRequest(aggregationColumn, informationColumn, quantitiesColumn, user));
	}
	
	public String getFishingMontlyEffort(String messageIdColumn, String datesColumn, String speedColumn, String fishingHoursDimension, String xDimensionColumn, String yDimensionColumn, boolean appendMode, boolean produceVTI) throws Exception{
		return tsManagerPT.getFishingMontlyEffort(new GetFishingMontlyEffortRequest(appendMode, datesColumn, fishingHoursDimension, messageIdColumn, produceVTI, speedColumn, user,  xDimensionColumn, yDimensionColumn));
	}
	
	public GetTransformationStatusResponse getTransformationStatus(String groupName) throws Exception{
		return tsManagerPT.getTransformationStatus(groupName);
	}
	
}
