package org.gcube.contentmanagement.timeseriesservice.calls.curation;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.calls.Constant;
import org.gcube.contentmanagement.timeseriesservice.calls.TSCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurationFactoryPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurationItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurationItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetFieldValuesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetItemRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SaveRuleRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CurationFactoryServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.RuleItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.RulesArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.StringArray;



public class CurationFactoryCall extends TSCall{

	
		GCUBELog logger= new GCUBELog(CurationFactoryCall.class);
		
		public CurationFactoryCall(GCUBEScope scope,
				GCUBESecurityManager[] securityManager) throws Exception {
			super(scope, securityManager);
		}

		
		@Override
		public String getPortTypeName() {
			return Constant.CURATION_FACTORY_PT_NAME;
		}

		
		/* (non-Javadoc)
		 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.CurationFactoryCallInterface#startCuration(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
		 */
		public StartResponse startCuration(String title, String description, String creator, String sourceId) throws Exception{
			final ResultHolder<StartResponse> result = new ResultHolder<StartResponse>();
			final StartRequest createRequest= new StartRequest(creator,description,sourceId, title);
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= 
						new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					result.value=factoryPT.startCuration(createRequest);
				}
			}.run();
			return result.value;
		}
		
		
		/* (non-Javadoc)
		 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.CurationFactoryCallInterface#open(java.lang.String)
		 */
		public EndpointReferenceType open(final String curationId) throws Exception{
			final ResultHolder<EndpointReferenceType> result = new ResultHolder<EndpointReferenceType>();
			new RICallHandler() {
				
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= 
						new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					result.value=factoryPT.open(curationId);
				}
			}.run();
			return result.value;
		}
		
		/* (non-Javadoc)
		 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.CurationFactoryCallInterface#getFieldValues(long, java.lang.String)
		 */
		public String[] getFieldValues(final String dimensionId, final String fieldName) throws Exception{
			final ResultHolder<String[]> result = new ResultHolder<String[]>();
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					StringArray tsia= factoryPT.getFieldValues(new GetFieldValuesRequest(dimensionId, fieldName));
					String[] toReturn;
					if (tsia==null || tsia.getStrings()==null)
						toReturn= new String[0];
					else
						toReturn= tsia.getStrings();
					result.value=toReturn;
				}
			}.run();
			return result.value;
		}
		
		/* (non-Javadoc)
		 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.CurationFactoryCallInterface#getCurationEntries(java.lang.String)
		 */
		public CurationItem[] getCurationEntries(final String user) throws Exception{
			final ResultHolder<CurationItem[]> result = new ResultHolder<CurationItem[]>();
			
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					CurationItemsArray tsia= factoryPT.getCuratingItems(user);
					CurationItem[] toReturn;
					if (tsia==null || tsia.getItems()==null)
						toReturn= new CurationItem[0];
					else
						toReturn=tsia.getItems();
					result.value= toReturn;
				}
				
			}.run();
			return result.value;		
		}
		
		/* (non-Javadoc)
		 * @see org.gcube.contentmanagement.timeseriesservice.stubs.calls.CurationFactoryCallInterface#getCurationItem(java.lang.String, java.lang.String)
		 */
		public CurationItem getCurationItem(final String user, final String id) throws Exception{
			final ResultHolder<CurationItem> result = new ResultHolder<CurationItem>();
			
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					result.value= factoryPT.getItem(new GetItemRequest(id, user));
					
				}
				
			}.run();
			return result.value;		
		}
		
		public void removeCuration(final String id) throws Exception{
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					factoryPT.removeCuration(id);
				}
			}.run();
		}
		
		public RuleItem[] getRules() throws Exception{
			final ResultHolder<RuleItem[]> result = new ResultHolder<RuleItem[]>();
			
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					RulesArray tsia= factoryPT.getRules(new VOID());
					RuleItem[] toReturn;
					if (tsia==null || tsia.getItems()==null)
						toReturn= new RuleItem[0];
					else
						toReturn=tsia.getItems();
					result.value= toReturn;
				}
				
			}.run();
			return result.value;
		}
		
		public String saveRule(final String name, final String description, final FilterCondition filter, final DataType dataType) throws Exception{
			final ResultHolder<String> result = new ResultHolder<String>();
			
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					result.value= factoryPT.saveRule(new SaveRuleRequest(description, filter, name, dataType));
				}
				
			}.run();
			return result.value;
		}
		
		public Boolean removeRule(final String id) throws Exception{
			final ResultHolder<Boolean> result = new ResultHolder<Boolean>();
			
			new RICallHandler() {
				
				public void interact(EndpointReferenceType epr) throws Exception {
					CurationFactoryPortType factoryPT= new CurationFactoryServiceAddressingLocator().getCurationFactoryPortTypePort(epr);
					factoryPT=GCUBERemotePortTypeContext.getProxy(factoryPT, getScopeManager(), getSecurityManager());
					result.value= factoryPT.removeRule(id);
				}
				
			}.run();
			return result.value;
		}
		
}
