/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.calls.importer;

import java.rmi.Remote;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.calls.GCUBECall;
import org.gcube.common.core.utils.calls.RICall;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.calls.TSCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFactoryPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.ImportFactoryServiceAddressingLocator;

public class ImporterFactoryCall
extends TSCall {
    GCUBELog logger = new GCUBELog(ImporterFactoryCall.class);

    public ImporterFactoryCall(GCUBEScope scope, GCUBESecurityManager[] securityManager) throws Exception {
        super(scope, securityManager);
    }

    public String getPortTypeName() {
        return "gcube/contentmanagement/timeseriesservice/import/ImportFactory";
    }

    public CreateImportResponse create(String title, String description, String creator, String publisher, String rights, String source, String type) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        final CreateImportRequest createRequest = new CreateImportRequest(creator, description, publisher, rights, source, title, type);
        new RICall.RICallHandler(this){

            public void interact(EndpointReferenceType epr) throws Exception {
                ImportFactoryPortType factoryPT = new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
                factoryPT = (ImportFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.createImportManager(createRequest);
            }
        }.run();
        return (CreateImportResponse)result.value;
    }

    public void remove(final String id) throws Exception {
        new RICall.RICallHandler(this){

            public void interact(EndpointReferenceType epr) throws Exception {
                ImportFactoryPortType factoryPT = new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
                factoryPT = (ImportFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                factoryPT.removeImportManager(id);
            }
        }.run();
    }

    public ImportedItem[] getImportedItemsInfo(final String user) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(this){

            public void interact(EndpointReferenceType epr) throws Exception {
                ImportFactoryPortType factoryPT = new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
                ImportedItemsArray iaa = (factoryPT = (ImportFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()})).getImportedItems(user);
                ImportedItem[] toReturn = iaa == null || iaa.getItems() == null ? new ImportedItem[]{} : iaa.getItems();
                result.value = toReturn;
            }
        }.run();
        return (ImportedItem[])result.value;
    }

    public ImportedItem getItemInfo(final String importId) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(this){

            public void interact(EndpointReferenceType epr) throws Exception {
                ImportFactoryPortType factoryPT = new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
                factoryPT = (ImportFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.getItem(importId);
            }
        }.run();
        return (ImportedItem)result.value;
    }

    public EndpointReferenceType open(final String importId) throws Exception {
        final GCUBECall.ResultHolder result = new GCUBECall.ResultHolder();
        new RICall.RICallHandler(this){

            public void interact(EndpointReferenceType epr) throws Exception {
                ImportFactoryPortType factoryPT = new ImportFactoryServiceAddressingLocator().getImportFactoryPortTypePort(epr);
                factoryPT = (ImportFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factoryPT, (GCUBEScopeManager)this.getScopeManager(), (GCUBESecurityManager[])new GCUBESecurityManager[]{this.getSecurityManager()});
                result.value = factoryPT.openImport(importId);
            }
        }.run();
        return (EndpointReferenceType)result.value;
    }
}

