/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.calls.codelist;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.timeseriesservice.calls.NoServiceFoundException;
import org.gcube.contentmanagement.timeseriesservice.calls.codelist.CodeListCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateCodeListRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnsDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CodelistManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;

public class CodeListManagerCall
extends CodeListCall {
    private static HashMap<String, CodelistManagerPortType> clImportManagerPTMapping = new HashMap();
    private String user;
    private String id;
    private CodelistManagerPortType cachedPT;

    private static String getEndpoint() {
        return "gcube/contentmanagement/timeseriesservice/codelist/CodelistManager";
    }

    public static void setPT(GCUBEScope scope, EndpointReferenceType epr) throws NoServiceFoundException, Exception {
        CodelistManagerPortType pt = new CodelistManagerServiceAddressingLocator().getCodelistManagerPortTypePort(epr);
        pt = (CodelistManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        clImportManagerPTMapping.put(scope.toString(), pt);
    }

    private static CodelistManagerPortType getCodelistManagerPortType(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        if (clImportManagerPTMapping.get(scope.toString()) == null) {
            CodelistManagerPortType pt = new CodelistManagerServiceAddressingLocator().getCodelistManagerPortTypePort(CodeListManagerCall.getEpr(scope, CodeListManagerCall.getEndpoint()));
            pt = (CodelistManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (GCUBESecurityManager[])securityManager);
            clImportManagerPTMapping.put(scope.toString(), pt);
        }
        return clImportManagerPTMapping.get(scope.toString());
    }

    public static String createCodelist(String curationId, String user, List<String> superUsers, GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws NoServiceFoundException, Exception {
        return CodeListManagerCall.getCodelistManagerPortType(scope, securityManagers).createCodeList(new CreateCodeListRequest(curationId, superUsers.toArray(new String[superUsers.size()]), user));
    }

    public static List<CodelistItem> getCodelists(GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws Exception {
        CodelistItemsArray items = CodeListManagerCall.getCodelistManagerPortType(scope, securityManagers).getCodelists(new VOID());
        if (items.getItems() == null) {
            return new ArrayList<CodelistItem>();
        }
        return Arrays.asList(items.getItems());
    }

    public static CodelistItem getCodelistItem(String id, String user, GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws Exception {
        return CodeListManagerCall.getCodelistManagerPortType(scope, securityManagers).getCodelistItem(new CodelistIdentifier(id, user));
    }

    public CodeListManagerCall(String user, String id, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception {
        this.user = user;
        this.id = id;
        this.cachedPT = CodeListManagerCall.getCodelistManagerPortType(scope, securityManager);
    }

    public Status getCodeListStatus() throws Exception {
        return this.cachedPT.getCodeListStatus(new CodelistIdentifier(this.id, this.user));
    }

    public String getDataAsJson(Limit limit, Order order) throws Exception {
        int tries = 0;
        while (true) {
            try {
                return this.cachedPT.getDataAsJson(new DataAsJsonRequest(new CodelistIdentifier(this.id, this.user), limit, order));
            }
            catch (Exception e) {
                Exception exception = e;
                if (++tries < 3) continue;
                throw exception;
            }
            break;
        }
    }

    public List<CodelistColumnDefinition> getColumnsDefinition() throws Exception {
        CodelistColumnsDefinitionArray cdArray = this.cachedPT.getColumnsDefinition(new CodelistIdentifier(this.id, this.user));
        if (cdArray.getDefinition() == null) {
            return new ArrayList<CodelistColumnDefinition>();
        }
        return Arrays.asList(cdArray.getDefinition());
    }

    public CodelistItem getCodelistItem() throws Exception {
        return this.cachedPT.getCodelistItem(new CodelistIdentifier(this.id, this.user));
    }

    public void remove() throws Exception {
        this.cachedPT.remove(new CodelistIdentifier(this.id, this.user));
    }

    public int getSize() throws Exception {
        return this.cachedPT.getSize(this.id);
    }

    public String getCodes(Limit limit, Order order) throws Exception {
        return this.cachedPT.getCodes(new DataAsJsonRequest(new CodelistIdentifier(this.id, this.user), limit, order));
    }

    public String export(boolean withHeader) throws Exception {
        return this.cachedPT.export(new CLExportRequest(withHeader, new CodelistIdentifier(this.id, this.user)));
    }
}

