package org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers;

import java.util.Iterator;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListImport;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;

@TableRootDefinition
public class CLImportItemWrapper extends ObjectStateControl{

	@FieldDefinition(precision={60}, specifications={Specification.NOT_NULL})
	private String owner;
	
	@FieldDefinition(precision={60}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
	private String codelistId;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private GCUBEScope scope;

		
	/**
	 * @return the owner
	 */
	public String getOwner() {
		return owner;
	}

	/**
	 * @return the codelistId
	 */
	public String getCodelistId() {
		return codelistId;
	}

	public Status getStatus() throws Exception{
		switch(this.getCodelist().getStatus()){
			case Failed:
				return Status.Error;
			case Initialized: case InProgress:
				return Status.Open;
			case Complete:
				return Status.Close;
		}
		return null;
	}
	
	/**
	 * @return the codelistId
	 */
	public CodeListImport getCodelist() throws Exception {
		return CodeListImport.get(codelistId);
	}
	
	/**
	 * @return the scope
	 */
	public GCUBEScope getScope() {
		return scope;
	}

	@SuppressWarnings("unused")
	private CLImportItemWrapper(){super();}
	
	public CLImportItemWrapper(String owner, String codelistId, GCUBEScope scope) {
		super();
		this.owner = owner;
		this.codelistId = codelistId;
		this.scope = scope;
	}	

	public boolean remove(){
		try {
			ObjectPersistency.get(CLImportItemWrapper.class).deleteByKey(this.getCodelistId());
			getCodelist().remove();
		} catch (Exception e) {
			return false;
		}
		return true;
		
	}
	
	public boolean store(){
		try{
			ObjectPersistency<CLImportItemWrapper> op = ObjectPersistency.get(CLImportItemWrapper.class);
			if (!op.existsKey(this.getCodelistId()))
				op.insert(this);
			else op.update(this);
		}catch (Exception e) {
			//logger.error("error storing on DB",e);
			return false;
		}
		return true;
	}
	
	public static CLImportItemWrapper get(String id) throws Exception{
		return ObjectPersistency.get(CLImportItemWrapper.class).getByKey(id);
	}
	
	public static Iterator<CLImportItemWrapper> getAll() throws Exception{
		return ObjectPersistency.get(CLImportItemWrapper.class).getAll().iterator();
	}
	
	public static Iterator<CLImportItemWrapper> getByUser(String user) throws Exception{
		return ObjectPersistency.get(CLImportItemWrapper.class).getObjectByField("owner", user).iterator();
	}
}
