package org.gcube.contentmanagement.timeseriesservice.impl.thread;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CopyFromCsv;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;

/**
 * 
 * @author lucio
 *
 */
public class InsertNormalizedT extends InsertThread {
	
	
	private static final char tempSeparator=',';
	private static final char tempQuoting='"';
	
	
	/**
	 * 		
	 * @param logger
	 * @param session
	 * @param rslocator
	 * @param tableName
	 * @param fieldsMask
	 * @param totalEntries
	 * @param columnsNumber
	 * @param hasHeader
	 * @param delimiter
	 * @param encoding
	 * @param importer
	 */
	public InsertNormalizedT(String rslocator, String tableName, boolean hasHeader,	char delimiter, String encoding, 
			boolean[] fieldsMask,ImporterItem importer) {
		super(rslocator, tableName, fieldsMask,	hasHeader, delimiter, encoding, importer);
	}

	/**
	 * 
	 */
	public void execute(CSVReaderProcessor processor, File fileStream) throws Exception{

		final List<String> fieldSetTmp= new ArrayList<String>();
		final List<ColumnDefinition> tableDefinition=new ArrayList<ColumnDefinition>(); 
		
		File tempCSV = File.createTempFile("dataTest", ".csv");
		logger.trace(tempCSV.getAbsolutePath());
		BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempCSV));
		final OutputStreamWriter sw = new OutputStreamWriter(bos, Charset.forName("utf-8"));
		
		//initializing table and resources
		processor.processStream(new InputStreamReader(new FileInputStream(fileStream), this.encoding) , new LineProcessor(){
			public void processDataLine(int lineNum, List<String> fields) {
				if (fields.size()!=fieldsMask.length){
					logger.trace("the line "+lineNum+" is not correct");
					return;
				}
				StringBuffer buffer = new StringBuffer();
				for (int i = 0; i<fields.size(); i++)
					if (fieldsMask[i])
						buffer.append(tempQuoting+fields.get(i)+tempQuoting+tempSeparator);
				try {
					sw.write( buffer.substring(0, buffer.length()-1)+'\n');
				} catch (IOException e) {
					logger.warn("error writing line");
				}
				//logger.trace("processing dataLine "+lineNum);
				processInitializationDataLine(lineNum, fields, fieldSetTmp, tableDefinition);
				totalEntries=lineNum;
			}

			public void processHeaderLine(int line, List<String> fieldsLabel) {
				//logger.trace("processing headerLine "+line);
				processInitializationHeaderLine(line, fieldsLabel, fieldSetTmp, tableDefinition);
			}});

		logger.trace("the column number is "+columnsNumber+" and the field mask size is "+fieldsMask.length);
		sw.close();
		
		if (columnsNumber!=this.fieldsMask.length) throw new Exception("the fieldMask size is different respect the field number");
		importer.setFieldNames(fieldSetTmp);

		if (hasHeader) totalEntries--;
		importer.setExstimatedLines(totalEntries);
		logger.trace("lines read are "+totalEntries);
		logger.trace("creating table "+this.tableName+" with "+tableDefinition.size()+" fields");
		SimpleTable table= createTable(tableDefinition);
		final Insert insertValues= DBSession.getImplementation(Insert.class);
		insertValues.setTable(table);

		List<String> fieldsNameOnTable = new ArrayList<String>();
		Map<String, int[]> fieldLenght= new HashMap<String, int[]>();
		for (int i=1;i<tableDefinition.size(); i++){
			fieldLenght.put("field"+(i-1), tableDefinition.get(i).getType().getPrecisionArray());
			fieldsNameOnTable.add("field"+(i-1));
		}
		
		importer.setImportProgress(0);
		importer.store();
		
		CopyFromCsv copyFromCsv = DBSession.getImplementation(CopyFromCsv.class);
		copyFromCsv.setFile(tempCSV);
		copyFromCsv.setQuoting(tempQuoting);
		copyFromCsv.setSeparator(tempSeparator);
		copyFromCsv.setTable(table);
		copyFromCsv.setColumnList(fieldsNameOnTable);
		
		logger.trace("the copy query is "+copyFromCsv.getExpression());
		
		copyFromCsv.execute(session);
		
		importer.setImportProgress(totalEntries);
		importer.store();
		
		tempCSV.delete();
		//Altering the table with the max values
		//columnDefinition[0]="id INTEGER(8) NOT NULL";
		

		importer.setTotalLines(totalEntries);
		importer.setTable(table);

		getResource().setFieldLenght(fieldLenght);
		getResource().setTable(table);
	}

	/**
	 * 
	 * @param lineNumber
	 * @param fields
	 * @param fieldSetTmp
	 * @param tableDefinition
	 */
	final private void processInitializationDataLine(int lineNumber, List<String> fields, List<String> fieldSetTmp, List<ColumnDefinition> tableDefinition){
		try{
			if (tableDefinition.size()==0){
				tableDefinition.add(Utility.getColumnDefinition("id", new Type(Types.INTEGER,8), Specification.NOT_NULL, Specification.AUTO_INCREMENT));
				//creating the others fields
				int k=0;
				for (int i=0; i<fields.size(); i++)
					if(fieldsMask[i]){
						//logger.debug("the max for field"+(k)+" is "+fields.size());
						tableDefinition.add(Utility.getColumnDefinition("field"+k, new Type(Types.STRING,1,0)));
						fieldSetTmp.add("field"+k);
						k++;
					}
			}

			if (columnsNumber==-1) columnsNumber=fields.size();
			
			int k=1;
			for (int i=0; i<fields.size(); i++){
				if (fieldsMask[i]){
					if (fields.get(i).length()>tableDefinition.get(k).getType().getPrecisionArray()[0])
						tableDefinition.get(k).getType().getPrecisionArray()[0] = fields.get(i).length();
					int templength=0;
					if (( templength = ImportUtil.getAfterDotLength(fields.get(i)))>
								tableDefinition.get(k).getType().getPrecisionArray()[1])
							tableDefinition.get(k).getType().getPrecisionArray()[1]= templength;
					k++;
				}
			}
		}catch(Exception e){logger.error("error reading lines", e);}
	}
	
	/**
	 * 
	 * @param lineNumber
	 * @param fieldsLabel
	 * @param fieldSetTmp
	 * @param tableDefinition
	 */
	final private void processInitializationHeaderLine(int lineNumber, List<String> fieldsLabel, List<String> fieldSetTmp, List<ColumnDefinition> tableDefinition){
		try{
			columnsNumber=fieldsLabel.size();
			tableDefinition.add(Utility.getColumnDefinition("id", new Type(Types.INTEGER,8), Specification.NOT_NULL, Specification.AUTO_INCREMENT));
			//creating the others fields
			int k=0;
			for (int i=0; i<fieldsLabel.size(); i++)
				if(fieldsMask[i]){
					tableDefinition.add(Utility.getColumnDefinition("field"+k, new Type(Types.STRING,1,0)));
					if (fieldsLabel!=null && fieldsLabel.get(i)!="") fieldSetTmp.add(fieldsLabel.get(i)); 
					else fieldSetTmp.add("field"+k);
					k++;
				}
		}catch(Exception e){logger.error("error initialization",e);}
	}
	
}
