package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.Order.OrderType;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;


public class Denormalization extends Operation{
   
	/**
	 * 
	 */
	private static final long serialVersionUID = -6565554460286543527L;
	
	private static GCUBELog logger= new GCUBELog(Denormalization.class);
	
	private String fieldIdValue;
	private String fieldIdAttribute;
	protected static final String PIVOT_PREFIX="pivot_";
	
	public Denormalization(){
		this.type= OperationType.Denormalization;
		this.viewName="d"+uuidGen.nextUUID().replaceAll("-", "");
	}
	
	@Override
	public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
		logger.trace("denormalization with values: fieldIdValue "+fieldIdValue+" , "+fieldIdAttribute);
		
		ArrayList<ColumnDefinition> denormColumnDefinition= new ArrayList<ColumnDefinition>(); 

		ArrayList<SimpleAttribute> groupingAttributes= new ArrayList<SimpleAttribute>();
	
		for (ColumnDefinition def: previousTableDefinition)
			if (def.getId().compareTo(fieldIdAttribute)!=0 && def.getId().compareTo(fieldIdValue)!=0){
				groupingAttributes.add(new SimpleAttribute(def.getId()));
				if (def.getColumnType()==EntryType.Dimension)
					groupingAttributes.add(new SimpleAttribute(def.getId()+CurationResource.ID_COLUMN_SUFFIX));
				denormColumnDefinition.add(def);
			}

		SimpleTable previousTable= new SimpleTable(previuosTableName);
		
		//taking different attributes values					
		Select selectQuery=DBSession.getImplementation(Select.class);
		selectQuery.setTables(previousTable);
		selectQuery.setAttributes(new SimpleAttribute(fieldIdAttribute));
		selectQuery.setUseDistinct(true);
		selectQuery.setOrders(new Order(OrderType.ASC, new SimpleAttribute(fieldIdAttribute)));
		ResultSet distinctFieldAttributeRes=selectQuery.getResults(session);
			
		logger.trace("took attributes from ts");

		ArrayList<Attribute> pivotAttributes= new ArrayList<Attribute>();
		int pivot_idx=0;
		while(distinctFieldAttributeRes.next()){
			String pivotName=PIVOT_PREFIX+pivot_idx;
			//DataType dbType= getColumnDefinitionReference(fieldIdAttribute, previousTableDefinition).getValueType();
			CastObject cast=Utility.getCast(distinctFieldAttributeRes.getString(1), previousTable.getFieldsMapping().get(fieldIdAttribute));
			//CastObject castInteger=Utility.getCast("0", previousTable.getFieldsMapping().get(fieldIdValue));
			//TODO: change the sqlUtil library
			pivotAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(pivotName), new SimpleAttribute(" SUM(CASE WHEN "+fieldIdAttribute+"="+cast.getCast()+" THEN "+fieldIdValue+" ELSE 0 END ) ")));
			denormColumnDefinition.add(new ColumnDefinition(EntryType.Value,null, null,pivotName,null, distinctFieldAttributeRes.getString(1), getColumnDefinitionReference(fieldIdValue,previousTableDefinition).getValueType()));
			logger.trace("added pivot "+pivotName);
			pivot_idx++;
		}
				
		logger.trace("adding the attributes list");
		ArrayList<Attribute> attributes= new ArrayList<Attribute>();
		Collections.addAll(attributes, groupingAttributes.toArray(new Attribute[0]));
		Collections.addAll(attributes, pivotAttributes.toArray(new Attribute[0]));
		Select pivotingQuery= DBSession.getImplementation(Select.class);
		pivotingQuery.setAttributes(attributes.toArray(new Attribute[0]));
		pivotingQuery.setTables(previousTable);
		
		this.setColumnDefinition(denormColumnDefinition.toArray(new ColumnDefinition[0]));
		
		
		//SelectQuery pivotingQuery= new SelectQuery(attributes.toArray(new Attribute[0]),null, new Table[]{new Table(previuosTableName)});
		//this.setColumnDefinition(denormColumnDefinition.toArray(new ColumnDefinition[0]));
		
		
		pivotingQuery.setGroups(groupingAttributes.toArray(new SimpleAttribute[0]));
		
		this.createTable(pivotingQuery, session, false);
				
		logger.trace("denormalization query is:"+pivotingQuery.getExpression());
		
		InsertFromSelect insert= DBSession.getImplementation(InsertFromSelect.class);
		insert.setSubQuery(pivotingQuery);
		insert.setTable(this.viewTable);
		logger.trace("insert query is "+insert.getExpression());
		insert.execute(session);
		
		this.viewTable.initializeCount();
		
		//changeColumnId();
		setCount(this.viewTable.getCount());
		setHistoryItem(new TSHistoryItem(pivotingQuery.toString(),"denormalization applied at attribute field "+getColumnDefinitionReference(fieldIdAttribute, previousTableDefinition).getLabel()+" with value field "+getColumnDefinitionReference(fieldIdValue, previousTableDefinition).getLabel(),new Date(),OperationType.Denormalization));
	}

	@Override
	public void setParameters(Object... parameters) throws Exception {
		this.fieldIdAttribute= (String) parameters[0];
		this.fieldIdValue= (String) parameters[1];
	}
	

}
