package org.gcube.contentmanagement.timeseriesservice.impl.importer.state;

import java.util.Map;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.globus.wsrf.ResourceException;

public class ImportResource extends GCUBEWSResource {

	protected static final String RP_ID = "Id";
		
	protected static String[] RPNames = { RP_ID };
	
	private SimpleTable table;
	
	private Map<String, int[]> fieldLenght;
	
	private ImporterItem importer;
	
	private String[] tableDefinition;
	
	/**
     * {@inheritDoc}
     */
    public String[] getPropertyNames() {
    	return RPNames;
    }
	
   
    
	@Override
	protected void initialise(Object... initParameters) throws Exception {
		this.setId((String) initParameters[0]);
		this.importer= new ImporterItem(this.getID(), this.getScope());
		importer.setId((String) initParameters[0]);
		importer.setTitle((String) initParameters[1]);
		importer.setCreator((String) initParameters[3]);
		importer.setDescription((String) initParameters[2]);
		importer.setPublisher((String) initParameters[4]);
		importer.setRights((String) initParameters[5]);
		importer.setSource((String) initParameters[6]);
		importer.setType((String) initParameters[7]);
		importer.setStatus(Status.Open);
		this.table=null;
	}
	
	
	/**
     * Returns the id.
     * 
     * @return the id.
     */
    public String getId() throws ResourceException {
    	return (String) this.getResourcePropertySet().get(RP_ID).get(0);
    }
    
    /**
     * 
     * @param id
     * @throws ResourceException
     */
    public synchronized void setId(String id) throws ResourceException {
    	this.getResourcePropertySet().get(RP_ID).clear();
		this.getResourcePropertySet().get(RP_ID).add(id);
    }
    
    public ImporterItem getImporterReference() throws ResourceException{
    	if (importer == null)
    		try{
    			importer= ObjectPersistency.get(ImporterItem.class).getByKey(this.getId());
    		}catch (Exception e) {
				logger.warn("error retriving importer for ts "+this.getId());
			}
    	return this.importer;
    }
        
    protected void onRemove() throws ResourceException{
    	this.remove();
    	super.onRemove();
    }
    
    /**
     * 
     */
    public void remove() throws ResourceException{
    	try {
    		ObjectPersistency.get(ImporterItem.class).deleteByKey(this.getId());
    	}catch (ObjectNotFoundException oe){
    		logger.warn("the entry is not in the db (it is already removed?)");
    	} catch (Exception e) {
			logger.error("cannot remove entry from DB",e);
			throw new ResourceException(e);
		}
    }


	public String[] getTableDefinition() {
		return tableDefinition;
	}



	public void setTableDefinition(String[] columnDefinition) {
		this.tableDefinition = columnDefinition;
	}
    
	
	 /**
	 * 
	 * 
	 * @return
	 * @throws Exception
	 */
	public String getDataAsJson(Limit limit) throws Exception{
		Select selectQuery= DBSession.getImplementation(Select.class);
		selectQuery.setTables(this.getTable());
		selectQuery.setLimit(new org.gcube.common.dbinterface.Limit(limit.getLowerLimit(), limit.getUpperLimit()));
		logger.trace(selectQuery.getExpression());
		return getImporterReference().getDataAsJson(selectQuery);
	}

	public Map<String, int[]> getFieldLenght() {
		return fieldLenght;
	}

	public void setFieldLenght(Map<String, int[]> fieldLenght) {
		this.fieldLenght = fieldLenght;
	}

	public SimpleTable getTable() throws Exception{
	   	return this.table; 
	}    
		
	public void setTable(SimpleTable table) {
		this.table = table;
	}
	
	
	
}
