package org.gcube.contentmanagement.timeseriesservice.impl.thread;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTable;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.timeseriesservice.calls.RSWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResource;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResourceHome;
import org.globus.wsrf.ResourceException;

/**
 * 
 * @author lucio
 *
 */
public abstract class InsertThread extends Thread {
	
	
	protected GCUBELog logger= new GCUBELog(InsertThread.class);
	protected DBSession session;
	protected String rslocator;
	protected String tableName;
	protected boolean[] fieldsMask;
	protected int totalEntries;
	protected int columnsNumber;
	protected boolean hasHeader= true;
	protected char delimiter =',';
	protected String encoding;
	protected ImporterItem importer;
	
	
	public InsertThread(String rslocator,
			String tableName, boolean[] fieldsMask, 
			boolean hasHeader, char delimiter,
			String encoding, ImporterItem importer) {
		super();
		this.rslocator = rslocator;
		this.tableName = tableName;
		this.fieldsMask = fieldsMask;
		this.columnsNumber = -1;
		this.hasHeader = hasHeader;
		this.delimiter = delimiter;
		this.encoding = encoding;
		this.importer = importer;
	}
	
	protected ImportResource getResource() throws ResourceException{
		ImportResourceHome home=(ImportResourceHome) ImportContext.getPortTypeContext().getWSHome();
		return (ImportResource) home.find(importer.getResourceKey());
	}
	
	/**
	 * 
	 * @param tableDefintion
	 * @return
	 * @throws Exception
	 */
	protected SimpleTable createTable(final List<ColumnDefinition> tableDefintion) throws Exception{
		SimpleTable toReturn= null;
		try{
			logger.debug("definition size is "+tableDefintion.size());
			for (ColumnDefinition cd:tableDefintion)
				logger.debug(cd.getDefinition());
			CreateTable create= DBSession.getImplementation(CreateTable.class);
			create.setTableName(tableName);
			create.setColumnsDefinition(tableDefintion.toArray(new ColumnDefinition[tableDefintion.size()]));
			logger.debug(create.getExpression());
			toReturn= create.execute(session);
		}catch(Exception e){
			logger.error("error creating table",e);
			throw e;
		}
		return toReturn;
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	protected File readStream() throws Exception{
		logger.trace("the locator is "+this.rslocator);
		
		long starttrasm= System.currentTimeMillis();
		
		File importFile= RSWrapper.getStreamFromLocator(new URI(rslocator));
		
		
		logger.debug("trasmission time: "+(System.currentTimeMillis()-starttrasm));
		
		logger.trace("the file exists??"+importFile.exists());
		logger.trace("file name is "+importFile.getAbsolutePath());
		/*
		File tmp_istream= File.createTempFile("istream", ".zip");
		FileOutputStream fos = new FileOutputStream(tmp_istream);
		
		
		fos.close();
		
		File tmp= File.createTempFile("import", ".zip");
		Util.unzip(fis, new FileOutputStream(tmp));
		tmp_istream.delete();
		fis.close();*/
		return importFile;
	}
	
	/**
	 * 
	 */
	public void run(){
		long start= System.currentTimeMillis();
		try{
			this.session=DBSession.connect();	
								
			CSVReaderProcessor processor= new CSVReaderProcessor();
			processor.setDelimiter(this.delimiter);
			processor.setHasHeader(this.hasHeader);
			
			File temp_stream=readStream();
			
			execute(processor, temp_stream);
			
			getResource().store();
			long end= System.currentTimeMillis();
			logger.trace("the inserting took "+(end-start)+" millis ");
			importer.setEncoding(this.encoding);
			importer.store();
						
			temp_stream.delete();
			this.importer.setClosed();
		}catch(Exception e){
			logger.error("error inserting data",e);
			try {
				this.getResource().remove();
			} catch (ResourceException e1) {
				logger.error("error removing resource (after import error)",e1);
			}
			this.importer.setErrorState();
		}
	}
	
	/**
	 * 
	 * @param processor
	 * @param reader
	 * @throws Exception
	 */
	public abstract void execute(CSVReaderProcessor processor, File fileStream) throws Exception;
	
	public class LineProcessor implements CSVLineProcessor{

		public boolean continueProcessing() {
			return true;
		}

		public void processDataLine(int arg0, List<String> arg1) {}

		public void processHeaderLine(int arg0, List<String> arg1) {}
		
	}
	
}
