/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.importer;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResource;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItemsArray;
import org.globus.wsrf.ResourceKey;

public class ImportFactory {
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private GCUBELog logger = new GCUBELog(ImportFactory.class);

    public CreateImportResponse createImportManager(CreateImportRequest request) throws GCUBEFault {
        CreateImportResponse response;
        String id = uuidGen.nextUUID();
        try {
            ImportResource resource = (ImportResource)ImportContext.getPortTypeContext().getWSHome().create(ImportContext.getPortTypeContext().makeKey(id), new Object[]{id, request.getTitle(), request.getDescription(), request.getCreator(), request.getPublisher(), request.getRights(), request.getSource(), request.getType()});
            response = new CreateImportResponse(resource.getEPR(), resource.getId());
            this.logger.trace((Object)("new resource epr: " + resource.getEPR()));
            resource.store();
        }
        catch (Exception re) {
            this.logger.error((Object)"error creating importer resource", (Throwable)re);
            throw new GCUBEFault((Throwable)re, new String[]{"error creating importer resource"});
        }
        return response;
    }

    public EndpointReferenceType openImport(String importId) throws GCUBEFault {
        try {
            ImportResource resource = (ImportResource)ImportContext.getPortTypeContext().getWSHome().find((ResourceKey)ImportContext.getPortTypeContext().makeKey(importId));
            return resource.getEPR();
        }
        catch (Exception re) {
            this.logger.error((Object)"error opening importer resource", (Throwable)re);
            throw new GCUBEFault((Throwable)re, new String[]{"error opening importer resource"});
        }
    }

    public VOID removeImportManager(String importId) throws GCUBEFault {
        try {
            ObjectPersistency.get(ImporterItem.class).deleteByKey((Object)importId);
            ImportContext.getPortTypeContext().getWSHome().remove((ResourceKey)ImportContext.getPortTypeContext().makeKey(importId));
        }
        catch (Exception e) {
            this.logger.error((Object)"error removing importer resource", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error removing importer resource"});
        }
        return new VOID();
    }

    public ImportedItemsArray getImportedItems(String user) throws GCUBEFault {
        ImportedItemsArray iia = new ImportedItemsArray();
        this.logger.trace((Object)"getImportedItems method");
        try {
            Iterator it = ObjectPersistency.get(ImporterItem.class).getObjectByField("creator", (Object)user).iterator();
            ArrayList<ImportedItem> importedItems = new ArrayList<ImportedItem>();
            while (it.hasNext()) {
                ImporterItem importerItem = (ImporterItem)it.next();
                if (!ServiceContext.getContext().getScope().isEnclosedIn(GCUBEScope.getScope((String)importerItem.getScope()))) continue;
                importedItems.add(this.createImportItem(importerItem));
            }
            iia.setItems(importedItems.toArray(new ImportedItem[importedItems.size()]));
        }
        catch (Exception e) {
            this.logger.error((Object)"error retrieving ImportedItems", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error retrieving ImportedItems"});
        }
        return iia;
    }

    public ImportedItem getItem(String importerId) throws GCUBEFault {
        try {
            return this.createImportItem((ImporterItem)ObjectPersistency.get(ImporterItem.class).getByKey((Object)importerId));
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting import item", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"item not retrieved"});
        }
    }

    private ImportedItem createImportItem(ImporterItem importer) throws Exception {
        ImportedItem item = new ImportedItem();
        item.setCreator(importer.getCreator());
        item.setDescription(importer.getDescription());
        item.setDate(Util.dateFormatter.format(new Date(importer.getDate().getTime())));
        item.setId(importer.getId());
        item.setLenght(importer.getTotalLines());
        item.setPublisher(importer.getPublisher());
        item.setRights(importer.getRights());
        item.setSource(importer.getSource());
        item.setTitle(importer.getTitle());
        item.setType(importer.getType());
        item.setEncoding(importer.getEncoding());
        this.logger.trace((Object)("retrieved imported item: with id: -" + item.getId() + "- and title: " + item.getTitle()));
        return item;
    }
}

