/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.importer;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.DropTable;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.thread.InsertDenomalizedT;
import org.gcube.contentmanagement.timeseriesservice.impl.thread.InsertNormalizedT;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Constants;
import org.gcube.contentmanagement.timeseriesservice.stubs.DenormalizedImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;

@TableRootDefinition
public class ImporterItem
implements Serializable {
    private static GCUBELog logger = new GCUBELog(ImporterItem.class);
    private GCUBEWSResourceKey resourceKey;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={10})
    private Status state = Status.Open;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String title;
    @FieldDefinition(specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY}, precision={50})
    private String id;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String creator;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String description;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String publisher;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String type;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={255})
    private String source;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String rights;
    @FieldDefinition
    private List<String> fieldNames = null;
    @FieldDefinition
    private SimpleTable table;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Timestamp date;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={50})
    private String encoding = "";
    private int exstimatedLines = 0;
    private int importProgress = 0;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={10})
    private int totalLines;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String scope;
    private static final long serialVersionUID = 1L;

    public ImporterItem(GCUBEWSResourceKey key, GCUBEScope scope) {
        this.date = new Timestamp(System.currentTimeMillis());
        this.scope = scope.toString();
        this.resourceKey = key;
    }

    private ImporterItem() {
    }

    public GCUBEWSResourceKey getResourceKey() {
        if (this.resourceKey == null) {
            this.resourceKey = ImportContext.getPortTypeContext().makeKey(this.id);
        }
        return this.resourceKey;
    }

    public void setStatus(Status state) {
        this.state = state;
    }

    public Status getStatus() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public ColumnDefinition[] getColumnsDefinition() {
        ColumnDefinition[] columnsDefinition = new ColumnDefinition[this.fieldNames.size()];
        int i = 0;
        for (String field : this.fieldNames) {
            ColumnDefinition columnDefinition = new ColumnDefinition(EntryType.Undefined, null, null, "field" + i, null, field.compareTo("") == 0 ? "field" + i : field, DataType.Text);
            columnsDefinition[i++] = columnDefinition;
        }
        return columnsDefinition;
    }

    public void store() throws Exception {
        ObjectPersistency persistency = ObjectPersistency.get(ImporterItem.class);
        if (!persistency.existsKey((Object)this.id)) {
            persistency.insert((Object)this);
        } else {
            persistency.update((Object)this);
        }
    }

    public void storeData(ImportRequest request) throws Exception {
        if (this.getStatus() == Status.Close) {
            logger.warn((Object)"cannot store data, the possibility to import data is CLOSED");
            throw new Exception("cannot store data, the possibility to import data is CLOSED");
        }
        InsertNormalizedT idt = new InsertNormalizedT(request.getRsLocator(), Constants.getImportTableDataName(this.getId()), request.isHasHeader(), request.getDelimiter().charAt(0), request.getEncoding(), request.getFieldsMask(), this);
        ServiceContext.getContext().setScope(idt, ServiceContext.getContext().getScope());
        idt.start();
    }

    public void storeDenormalizedData(DenormalizedImportRequest request) throws Exception {
        if (this.getStatus() == Status.Close) {
            logger.warn((Object)"cannot store data, the possibility to import data is CLOSED");
            throw new Exception("cannot store data, the possibility to import data is CLOSED");
        }
        InsertDenomalizedT idt = new InsertDenomalizedT(request.getRsLocator(), Constants.getImportTableDataName(this.getId()), request.isHasHeader(), request.getDelimiter().charAt(0), request.getEncoding(), request.getFieldsMask(), request.getFieldsAttributeMask(), request.getAttributeLabel(), request.getValueLabel(), this);
        ServiceContext.getContext().setScope(idt, ServiceContext.getContext().getScope());
        idt.start();
    }

    public void setClosed() {
        this.setStatus(Status.Close);
    }

    public void setErrorState() {
        this.setStatus(Status.Error);
    }

    public String getDataAsJson(Select query) throws Exception {
        return query.getResultAsJSon(true, new boolean[0]);
    }

    public String getData() throws Exception {
        return null;
    }

    public void remove() throws Exception {
        DBSession session = DBSession.connect();
        try {
            ObjectPersistency.get(ImporterItem.class).deleteByKey((Object)this.getId());
        }
        catch (Exception e1) {
            logger.error((Object)("error dropping entry eith id " + this.id), (Throwable)e1);
        }
        try {
            DropTable drop = (DropTable)DBSession.getImplementation(DropTable.class);
            drop.setTableName(Constants.getImportTableDataName(this.id));
            drop.execute(session);
        }
        catch (Exception e) {
            logger.error((Object)("error dropping table " + Constants.getImportTableDataName(this.id)));
        }
        session.release();
    }

    public int count() throws Exception {
        SimpleTable tempResourceTable = new SimpleTable(Constants.getImportTableDataName(this.id));
        tempResourceTable.initializeCount();
        return tempResourceTable.getCount();
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public Map<String, String> getFieldMapping() {
        if (this.fieldNames != null) {
            HashMap<String, String> mapping = new HashMap<String, String>();
            int i = 0;
            while (i < this.fieldNames.size()) {
                mapping.put(this.fieldNames.get(i), "field" + i);
                ++i;
            }
            return mapping;
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public int getImportProgress() {
        return this.importProgress;
    }

    public void setImportProgress(int importProgress) {
        this.importProgress = importProgress;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public void setTotalLines(int totalLines) {
        this.totalLines = totalLines;
    }

    public int getExstimatedLines() {
        return this.exstimatedLines;
    }

    public void setExstimatedLines(int exstimatedLine) {
        this.exstimatedLines = exstimatedLine;
    }

    public SimpleTable getTable() {
        return this.table;
    }

    public void setTable(SimpleTable table) {
        this.table = table;
    }

    public Timestamp getDate() {
        return this.date;
    }

    public void setDate(Timestamp date) {
        this.date = date;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

