/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.ORCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util.StringOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ComplexCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ComplexFilter;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ConditionOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DateOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.NumberOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.SimpleFilter;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.TextOperator;

public class FilterExplorer {
    public static GCUBELog logger = new GCUBELog(FilterExplorer.class);

    public static Condition getCondition(FilterCondition condition, ColumnDefinition[] columsDefinition, String tableAlias, String ... fieldId) throws Exception {
        logger.debug((Object)"geting conditions");
        String fieldToSet = fieldId != null && fieldId.length > 0 ? fieldId[0] : null;
        logger.trace((Object)("condition is null?" + (condition == null)));
        if (condition.getCondition() != null) {
            ComplexCondition complCond = condition.getCondition();
            if (complCond.getOperator() == ConditionOperator.or) {
                return new ORCondition(new Condition[]{FilterExplorer.getCondition(complCond.getLeftCondition(), columsDefinition, fieldToSet, new String[0]), FilterExplorer.getCondition(complCond.getRightCondition(), columsDefinition, fieldToSet, new String[0])});
            }
            logger.debug((Object)("leftOperand is null?" + complCond.getLeftCondition() == null ? 1 : 0));
            logger.debug((Object)("rightOperand is null?" + complCond.getRightCondition() == null ? 1 : 0));
            return new ANDCondition(new Condition[]{FilterExplorer.getCondition(complCond.getLeftCondition(), columsDefinition, fieldToSet, new String[0]), FilterExplorer.getCondition(complCond.getRightCondition(), columsDefinition, fieldToSet, new String[0])});
        }
        if (condition.getFilter() != null) {
            if (condition.getFilter().getComplexFilter() != null) {
                ComplexFilter complexFilter = condition.getFilter().getComplexFilter();
                ColumnDefinition columnDef = Operation.getColumnDefinitionReference(fieldToSet == null ? complexFilter.getFieldId() : fieldToSet, columsDefinition);
                ArrayList<OperatorCondition> operators = new ArrayList<OperatorCondition>();
                logger.debug((Object)("dimensionIdAray is null?" + complexFilter.getDimensionIdsvalueArray() == null ? 1 : 0));
                String[] stringArray = complexFilter.getDimensionIdsvalueArray();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    CastObject cast = Utility.getCast((String)id, (Type)new Type(Type.Types.valueOf((String)columnDef.getValueType().getValue().toUpperCase()), new int[0]));
                    operators.add(new OperatorCondition((Object)new SimpleAttribute(String.valueOf(fieldToSet == null ? complexFilter.getFieldId() : fieldToSet) + "_id", tableAlias), (Object)cast, "="));
                    ++n2;
                }
                return new ORCondition(operators.toArray(new Condition[0]));
            }
            if (condition.getFilter().getSimpleFilter() != null) {
                SimpleFilter simpleFilter = condition.getFilter().getSimpleFilter();
                ColumnDefinition columnDef = Operation.getColumnDefinitionReference(fieldToSet == null ? simpleFilter.getFieldId() : fieldToSet, columsDefinition);
                if (simpleFilter.getOperator().getNumberOperator() != null) {
                    String operator = FilterExplorer.resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
                    logger.trace((Object)("the value type is:" + columnDef.getValueType()));
                    CastObject cast = Utility.getCast((String)simpleFilter.getValue(), (Type)new Type(Type.Types.valueOf((String)columnDef.getValueType().getValue().toUpperCase()), new int[0]));
                    return new OperatorCondition((Object)new SimpleAttribute(columnDef.getId(), tableAlias), (Object)cast, operator);
                }
                if (simpleFilter.getOperator().getTextOperator() != null) {
                    StringOperator stringOperator = FilterExplorer.resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
                    logger.trace((Object)("is columnDef null?" + (columnDef == null)));
                    logger.trace((Object)("type of column is " + columnDef.getValueType().getValue()));
                    logger.trace((Object)("operator is " + stringOperator.getValue()));
                    CastObject cast = Utility.getCast((String)stringOperator.getValue(), (Type)new Type(Type.Types.valueOf((String)columnDef.getValueType().getValue().toUpperCase()), new int[0]));
                    return new OperatorCondition((Object)new SimpleAttribute(columnDef.getId(), tableAlias), (Object)cast, stringOperator.getSqlOperator());
                }
                if (simpleFilter.getOperator().getDateOperator() != null) {
                    String operator = FilterExplorer.resolveDateOperator(simpleFilter.getOperator().getDateOperator());
                    CastObject cast = Utility.getCast((String)simpleFilter.getValue(), (Type)new Type(Type.Types.valueOf((String)columnDef.getValueType().getValue().toUpperCase()), new int[0]));
                    return new OperatorCondition((Object)new SimpleAttribute(columnDef.getId(), tableAlias), (Object)cast, operator);
                }
                throw new Exception("Filter Declaration Error");
            }
        }
        throw new Exception("Filter Declaration Error");
    }

    public static Condition getConditionUsingValue(FilterCondition condition, CastObject value) throws Exception {
        logger.debug((Object)"geting conditions");
        if (condition.getCondition() != null) {
            ComplexCondition complCond = condition.getCondition();
            if (complCond.getOperator() == ConditionOperator.or) {
                return new ORCondition(new Condition[]{FilterExplorer.getConditionUsingValue(complCond.getLeftCondition(), value), FilterExplorer.getConditionUsingValue(complCond.getRightCondition(), value)});
            }
            logger.debug((Object)("leftOperand is null?" + complCond.getLeftCondition() == null ? 1 : 0));
            logger.debug((Object)("rightOperand is null?" + complCond.getRightCondition() == null ? 1 : 0));
            return new ANDCondition(new Condition[]{FilterExplorer.getConditionUsingValue(complCond.getLeftCondition(), value), FilterExplorer.getConditionUsingValue(complCond.getRightCondition(), value)});
        }
        if (condition.getFilter() != null) {
            if (condition.getFilter().getComplexFilter() != null) {
                throw new Exception("complexFilter are not allowed");
            }
            if (condition.getFilter().getSimpleFilter() != null) {
                SimpleFilter simpleFilter = condition.getFilter().getSimpleFilter();
                if (simpleFilter.getOperator().getNumberOperator() != null) {
                    String operator = FilterExplorer.resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
                    CastObject cast = Utility.getCast((String)simpleFilter.getValue(), (Type)value.getType());
                    return new OperatorCondition((Object)value, (Object)cast, operator);
                }
                if (simpleFilter.getOperator().getTextOperator() != null) {
                    StringOperator stringOperator = FilterExplorer.resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
                    CastObject cast = Utility.getCast((String)stringOperator.getValue(), (Type)value.getType());
                    return new OperatorCondition((Object)value, (Object)cast, stringOperator.getSqlOperator());
                }
                if (simpleFilter.getOperator().getDateOperator() != null) {
                    String operator = FilterExplorer.resolveDateOperator(simpleFilter.getOperator().getDateOperator());
                    CastObject cast = Utility.getCast((String)simpleFilter.getValue(), (Type)value.getType());
                    return new OperatorCondition((Object)value, (Object)cast, operator);
                }
                throw new Exception("Filter Declaration Error");
            }
        }
        throw new Exception("Filter Declaration Error");
    }

    public static StringBuilder getFilterDescription(FilterCondition condition, ColumnDefinition[] columsDefinition) throws Exception {
        StringBuilder toReturn = new StringBuilder();
        logger.debug((Object)"geting Filter description");
        if (condition.getCondition() != null) {
            ComplexCondition complCond = condition.getCondition();
            toReturn.append((CharSequence)FilterExplorer.getFilterDescription(complCond.getLeftCondition(), columsDefinition)).append(" AND ").append((CharSequence)FilterExplorer.getFilterDescription(complCond.getRightCondition(), columsDefinition));
            return toReturn;
        }
        if (condition.getFilter() != null) {
            if (condition.getFilter().getComplexFilter() != null) {
                ComplexFilter complexFilter = condition.getFilter().getComplexFilter();
                ColumnDefinition columnDefinition = Operation.getColumnDefinitionReference(complexFilter.getFieldId(), columsDefinition);
                toReturn.append("(").append(columnDefinition.getLabel()).append(" has as id: ").append(Arrays.toString(complexFilter.getDimensionIdsvalueArray()));
                toReturn.append(")");
                return toReturn;
            }
            if (condition.getFilter().getSimpleFilter() != null) {
                SimpleFilter simpleFilter = condition.getFilter().getSimpleFilter();
                ColumnDefinition columnDefinition = Operation.getColumnDefinitionReference(simpleFilter.getFieldId(), columsDefinition);
                if (simpleFilter.getOperator().getNumberOperator() != null) {
                    String operator = FilterExplorer.resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
                    return toReturn.append(" (").append(columnDefinition.getLabel()).append(operator).append(simpleFilter.getValue()).append(")");
                }
                if (simpleFilter.getOperator().getTextOperator() != null) {
                    StringOperator stringOperator = FilterExplorer.resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
                    return toReturn.append(" (").append(columnDefinition.getLabel()).append(stringOperator.getSqlOperator()).append(stringOperator.getValue()).append(")");
                }
                if (simpleFilter.getOperator().getDateOperator() != null) {
                    String operator = FilterExplorer.resolveDateOperator(simpleFilter.getOperator().getDateOperator());
                    return toReturn.append(" (").append(columnDefinition.getLabel()).append(operator).append(simpleFilter.getValue()).append(")");
                }
            }
        }
        return toReturn;
    }

    public static StringBuilder generateRulesDescription(FilterCondition condition) throws Exception {
        StringBuilder toReturn = new StringBuilder();
        logger.debug((Object)"geting Filter description");
        String label = "value";
        if (condition.getCondition() != null) {
            ComplexCondition complCond = condition.getCondition();
            toReturn.append((CharSequence)FilterExplorer.generateRulesDescription(complCond.getLeftCondition())).append(" AND ").append((CharSequence)FilterExplorer.generateRulesDescription(complCond.getRightCondition()));
            return toReturn;
        }
        if (condition.getFilter() != null) {
            if (condition.getFilter().getComplexFilter() != null) {
                ComplexFilter complexFilter = condition.getFilter().getComplexFilter();
                toReturn.append("(").append("value").append(" has as id: ").append(Arrays.toString(complexFilter.getDimensionIdsvalueArray()));
                toReturn.append(")");
                return toReturn;
            }
            if (condition.getFilter().getSimpleFilter() != null) {
                SimpleFilter simpleFilter = condition.getFilter().getSimpleFilter();
                if (simpleFilter.getOperator().getNumberOperator() != null) {
                    String operator = FilterExplorer.resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
                    return toReturn.append(" (").append("value").append(operator).append(simpleFilter.getValue()).append(")");
                }
                if (simpleFilter.getOperator().getTextOperator() != null) {
                    StringOperator stringOperator = FilterExplorer.resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
                    return toReturn.append(" (").append("value").append(stringOperator.getSqlOperator()).append(stringOperator.getValue()).append(")");
                }
                if (simpleFilter.getOperator().getDateOperator() != null) {
                    String operator = FilterExplorer.resolveDateOperator(simpleFilter.getOperator().getDateOperator());
                    return toReturn.append(" (").append("value").append(operator).append(simpleFilter.getValue()).append(")");
                }
            }
        }
        return toReturn;
    }

    private static StringOperator resolveStringOperator(TextOperator textOp, String originalValue) {
        logger.trace((Object)("original value is " + originalValue + " textOp is " + textOp.getValue()));
        String operator = "";
        String value = originalValue;
        if (textOp == TextOperator.EQ) {
            operator = " LIKE ";
        } else if (textOp == TextOperator.CN) {
            operator = " LIKE ";
            value = "%" + value + "%";
        } else if (textOp == TextOperator.NCN) {
            operator = " NOT LIKE ";
            value = "%" + value + "%";
        } else if (textOp == TextOperator.SW) {
            operator = " LIKE ";
            value = String.valueOf(value) + "%";
        } else if (textOp == TextOperator.EW) {
            operator = " LIKE ";
            value = "%" + value;
        } else if (textOp == TextOperator.NEQ) {
            operator = " NOT LIKE ";
        } else if (textOp == TextOperator.NSW) {
            operator = " NOT LIKE ";
            value = String.valueOf(value) + "%";
        } else if (textOp == TextOperator.NEW) {
            operator = " NOT LIKE ";
            value = "%" + value;
        }
        return new StringOperator(operator, value);
    }

    private static String resolveNumberOperator(NumberOperator numberOp) {
        if (numberOp == NumberOperator.EQ) {
            return "=";
        }
        if (numberOp == NumberOperator.GT) {
            return ">";
        }
        if (numberOp == NumberOperator.LT) {
            return "<";
        }
        if (numberOp == NumberOperator.GTEQ) {
            return ">=";
        }
        if (numberOp == NumberOperator.LTEQ) {
            return "<=";
        }
        if (numberOp == NumberOperator.NEQ) {
            return "!=";
        }
        return "";
    }

    private static String resolveDateOperator(DateOperator dateOp) {
        if (dateOp == DateOperator.AF) {
            return "<";
        }
        if (dateOp == DateOperator.BF) {
            return ">";
        }
        if (dateOp == DateOperator.EQ) {
            return "=";
        }
        if (dateOp == DateOperator.NEQ) {
            return "!=";
        }
        return "";
    }
}

