/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;

public class Util {
    public static SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yy HH.mm.ss");
    private static final Map<DataType, Type.Types> javaToDb = new HashMap<DataType, Type.Types>();
    private static final Map<Type.Types, DataType> dbToJava = new HashMap<Type.Types, DataType>();
    private static GCUBELog logger;

    static {
        dbToJava.put(Type.Types.STRING, DataType.Text);
        dbToJava.put(Type.Types.TEXT, DataType.Text);
        dbToJava.put(Type.Types.INTEGER, DataType.Integer);
        dbToJava.put(Type.Types.FLOAT, DataType.Float);
        dbToJava.put(Type.Types.LONG, DataType.Integer);
        dbToJava.put(Type.Types.DATE, DataType.Date);
        dbToJava.put(Type.Types.TIME, DataType.Time);
        dbToJava.put(Type.Types.TIMESTAMP, DataType.Timestamp);
        dbToJava.put(Type.Types.BOOLEAN, DataType.Boolean);
        javaToDb.put(DataType.Text, Type.Types.STRING);
        javaToDb.put(DataType.Integer, Type.Types.INTEGER);
        javaToDb.put(DataType.Date, Type.Types.DATE);
        javaToDb.put(DataType.Float, Type.Types.FLOAT);
        javaToDb.put(DataType.Boolean, Type.Types.BOOLEAN);
        javaToDb.put(DataType.Time, Type.Types.TIME);
        javaToDb.put(DataType.Timestamp, Type.Types.TIMESTAMP);
        logger = new GCUBELog(Util.class);
    }

    public static String toJSon(ResultSet resultSet) throws SQLException {
        StringBuilder json = new StringBuilder();
        json.append("{\"response\":{\"value\":{\"items\":[");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        logger.debug((Object)("number of columns " + numberOfColumns));
        int count = 0;
        while (resultSet.next()) {
            if (count > 0) {
                json.append(",{");
            } else {
                json.append('{');
            }
            int column = 1;
            while (column <= numberOfColumns) {
                if (column > 1) {
                    json.append(',');
                }
                json.append(Util.quote(metaData.getColumnName(column)));
                json.append(':');
                json.append(Util.quote(resultSet.getString(column)));
                ++column;
            }
            json.append('}');
            ++count;
        }
        json.append("],\"total_count\":");
        return json.toString();
    }

    protected static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void streamToFile(InputStream instream, OutputStream out) throws Exception {
        try {
            int len;
            byte[] buf = new byte[8096];
            int sum = 0;
            while ((len = instream.read(buf)) >= 0) {
                sum += len;
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            if (instream != null) {
                instream.close();
            }
            if (out != null) {
                out.close();
            }
            throw e;
        }
    }

    public static void unzip(InputStream is, OutputStream os) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            IOUtils.copy((InputStream)zis, (OutputStream)os);
            zis.closeEntry();
            zis.close();
            os.close();
            return;
        }
        throw new Exception("No file entry found");
    }

    public static void getZip(OutputStream os, String name, InputStream is) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(os);
        ZipEntry entry = new ZipEntry(name);
        zos.putNextEntry(entry);
        IOUtils.copy((InputStream)is, (OutputStream)zos);
        zos.closeEntry();
        zos.close();
    }

    public static String removeSizeFromDBType(String typeName) {
        return typeName.replaceAll("\\([^\\)]*\\)", "").toLowerCase();
    }

    public static DataType mapSqlToJava(Type.Types type) throws Exception {
        return dbToJava.get(type);
    }

    public static Type.Types mapJavaToSql(DataType sqlType) {
        return javaToDb.get(sqlType);
    }

    public static String replaceKeyType(String type) throws Exception {
        String cleanType = Util.removeSizeFromDBType(type);
        if (cleanType.compareTo("date") == 0 || cleanType.compareTo("datetime") == 0 || cleanType.compareTo("timestamp") == 0 || cleanType.compareTo("time") == 0) {
            return cleanType;
        }
        return type;
    }
}

