/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.module.jaxb.AdapterConverter;
import com.fasterxml.jackson.module.jaxb.PackageVersion;
import com.fasterxml.jackson.module.jaxb.deser.DataHandlerJsonDeserializer;
import com.fasterxml.jackson.module.jaxb.ser.DataHandlerJsonSerializer;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;

public class JaxbAnnotationIntrospector
extends AnnotationIntrospector
implements Versioned {
    private static final long serialVersionUID = 2406885758759038380L;
    protected static final boolean DEFAULT_IGNORE_XMLIDREF = false;
    protected static final String MARKER_FOR_DEFAULT = "##default";
    protected final String _jaxbPackageName;
    protected final JsonSerializer<?> _dataHandlerSerializer;
    protected final JsonDeserializer<?> _dataHandlerDeserializer;
    protected final TypeFactory _typeFactory;
    protected final boolean _ignoreXmlIDREF;

    @Deprecated
    public JaxbAnnotationIntrospector() {
        this(TypeFactory.defaultInstance());
    }

    public JaxbAnnotationIntrospector(MapperConfig<?> mapperConfig) {
        this(mapperConfig.getTypeFactory());
    }

    public JaxbAnnotationIntrospector(TypeFactory typeFactory) {
        this(typeFactory, false);
    }

    public JaxbAnnotationIntrospector(TypeFactory typeFactory, boolean bl) {
        this._typeFactory = typeFactory == null ? TypeFactory.defaultInstance() : typeFactory;
        this._ignoreXmlIDREF = bl;
        this._jaxbPackageName = XmlElement.class.getPackage().getName();
        JsonSerializer jsonSerializer = null;
        JsonDeserializer jsonDeserializer = null;
        try {
            jsonSerializer = (JsonSerializer)DataHandlerJsonSerializer.class.newInstance();
            jsonDeserializer = (JsonDeserializer)DataHandlerJsonDeserializer.class.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._dataHandlerSerializer = jsonSerializer;
        this._dataHandlerDeserializer = jsonDeserializer;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        XmlID xmlID;
        if (!(annotated instanceof AnnotatedClass)) {
            return null;
        }
        AnnotatedClass annotatedClass = (AnnotatedClass)annotated;
        PropertyName propertyName = null;
        block4: for (AnnotatedMethod annotatedMember : annotatedClass.memberMethods()) {
            xmlID = annotatedMember.getAnnotation(XmlID.class);
            if (xmlID == null) continue;
            switch (annotatedMember.getParameterCount()) {
                case 0: {
                    propertyName = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMember, annotatedMember.getRawType(), BeanUtil.okNameForGetter(annotatedMember));
                    break block4;
                }
                case 1: {
                    propertyName = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMember, annotatedMember.getRawType(), BeanUtil.okNameForSetter(annotatedMember));
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (propertyName == null) {
            for (AnnotatedField annotatedField : annotatedClass.fields()) {
                xmlID = annotatedField.getAnnotation(XmlID.class);
                if (xmlID == null) continue;
                propertyName = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), annotatedField.getName());
                break;
            }
        }
        if (propertyName != null) {
            Class<Object> clazz = Object.class;
            return new ObjectIdInfo(propertyName, clazz, ObjectIdGenerators.PropertyGenerator.class);
        }
        return null;
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        XmlIDREF xmlIDREF;
        if (!this._ignoreXmlIDREF && (xmlIDREF = annotated.getAnnotation(XmlIDREF.class)) != null) {
            objectIdInfo = objectIdInfo.withAlwaysAsId(true);
        }
        return objectIdInfo;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        XmlRootElement xmlRootElement = this.findRootElementAnnotation(annotatedClass);
        if (xmlRootElement != null) {
            return JaxbAnnotationIntrospector._combineNames(xmlRootElement.name(), xmlRootElement.namespace(), "");
        }
        return null;
    }

    @Override
    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        return null;
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        return null;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return annotatedMember.getAnnotation(XmlTransient.class) != null;
    }

    @Override
    public PropertyName findWrapperName(Annotated annotated) {
        XmlElementWrapper xmlElementWrapper = this.findAnnotation(XmlElementWrapper.class, annotated, false, false, false);
        if (xmlElementWrapper != null) {
            PropertyName propertyName = JaxbAnnotationIntrospector._combineNames(xmlElementWrapper.name(), xmlElementWrapper.namespace(), "");
            if (!propertyName.hasSimpleName()) {
                AnnotatedMethod annotatedMethod;
                String string;
                if (annotated instanceof AnnotatedMethod && (string = (annotatedMethod = (AnnotatedMethod)annotated).getParameterCount() == 0 ? BeanUtil.okNameForGetter(annotatedMethod) : BeanUtil.okNameForSetter(annotatedMethod)) != null) {
                    return propertyName.withSimpleName(string);
                }
                return propertyName.withSimpleName(annotated.getName());
            }
            return propertyName;
        }
        return null;
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        XmlAccessType xmlAccessType = this.findAccessType(annotatedClass);
        if (xmlAccessType == null) {
            return visibilityChecker;
        }
        switch (xmlAccessType) {
            case FIELD: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case NONE: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case PROPERTY: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
            case PUBLIC_MEMBER: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
        }
        return visibilityChecker;
    }

    protected XmlAccessType findAccessType(Annotated annotated) {
        XmlAccessorType xmlAccessorType = this.findAnnotation(XmlAccessorType.class, annotated, true, true, true);
        return xmlAccessorType == null ? null : xmlAccessorType.value();
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return null;
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.isContainerType()) {
            return null;
        }
        return this._typeResolverFromXmlElements(annotatedMember);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (!javaType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + javaType + ")");
        }
        return this._typeResolverFromXmlElements(annotatedMember);
    }

    protected TypeResolverBuilder<?> _typeResolverFromXmlElements(AnnotatedMember annotatedMember) {
        XmlElements xmlElements = this.findAnnotation(XmlElements.class, annotatedMember, false, false, false);
        XmlElementRefs xmlElementRefs = this.findAnnotation(XmlElementRefs.class, annotatedMember, false, false, false);
        if (xmlElements == null && xmlElementRefs == null) {
            return null;
        }
        StdTypeResolverBuilder stdTypeResolverBuilder = new StdTypeResolverBuilder();
        stdTypeResolverBuilder = stdTypeResolverBuilder.init(JsonTypeInfo.Id.NAME, null);
        stdTypeResolverBuilder = stdTypeResolverBuilder.inclusion(JsonTypeInfo.As.WRAPPER_OBJECT);
        return stdTypeResolverBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<NamedType> findSubtypes(Annotated annotated) {
        XmlElementRefs xmlElementRefs;
        XmlElements xmlElements = this.findAnnotation(XmlElements.class, annotated, false, false, false);
        ArrayList<NamedType> arrayList = null;
        if (xmlElements != null) {
            arrayList = new ArrayList<NamedType>();
            xmlElementRefs = xmlElements.value();
            int n = ((XmlElement[])xmlElementRefs).length;
            for (int i = 0; i < n; ++i) {
                void object;
                XmlElementRefs xmlElementRefs2 = xmlElementRefs[i];
                String string = xmlElementRefs2.name();
                if (MARKER_FOR_DEFAULT.equals(string)) {
                    Object var8_14 = null;
                }
                arrayList.add(new NamedType(xmlElementRefs2.type(), (String)object));
            }
        } else {
            xmlElementRefs = this.findAnnotation(XmlElementRefs.class, annotated, false, false, false);
            if (xmlElementRefs != null) {
                arrayList = new ArrayList();
                for (XmlElementRef xmlElementRef : xmlElementRefs.value()) {
                    XmlRootElement xmlRootElement;
                    Class clazz = xmlElementRef.type();
                    if (JAXBElement.class.isAssignableFrom(clazz)) continue;
                    String string = xmlElementRef.name();
                    if ((string == null || MARKER_FOR_DEFAULT.equals(string)) && (xmlRootElement = clazz.getAnnotation(XmlRootElement.class)) != null) {
                        string = xmlRootElement.name();
                    }
                    if (string == null || MARKER_FOR_DEFAULT.equals(string)) {
                        string = Introspector.decapitalize(clazz.getSimpleName());
                    }
                    arrayList.add(new NamedType(clazz, string));
                }
            }
        }
        if ((xmlElementRefs = annotated.getAnnotation(XmlSeeAlso.class)) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            for (Class clazz : xmlElementRefs.value()) {
                arrayList.add(new NamedType(clazz));
            }
        }
        return arrayList;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        String string;
        XmlType xmlType = this.findAnnotation(XmlType.class, annotatedClass, false, false, false);
        if (xmlType != null && !MARKER_FOR_DEFAULT.equals(string = xmlType.name())) {
            return string;
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(Annotated annotated) {
        Class<?> clazz = this._rawSerializationType(annotated);
        if (clazz != null && this._dataHandlerSerializer != null && this.isDataHandler(clazz)) {
            return this._dataHandlerSerializer;
        }
        return null;
    }

    private boolean isDataHandler(Class<?> clazz) {
        return clazz != null && Object.class != clazz && ("javax.activation.DataHandler".equals(clazz.getName()) || this.isDataHandler(clazz.getSuperclass()));
    }

    @Override
    public Object findContentSerializer(Annotated annotated) {
        return null;
    }

    @Override
    public Class<?> findSerializationType(Annotated annotated) {
        XmlElement xmlElement = this.findAnnotation(XmlElement.class, annotated, false, false, false);
        if (xmlElement == null || xmlElement.type() == XmlElement.DEFAULT.class) {
            return null;
        }
        Class<?> clazz = this._rawSerializationType(annotated);
        if (this.isContainerType(clazz)) {
            return null;
        }
        Class clazz2 = xmlElement.type();
        if (annotated.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return null;
        }
        return clazz2;
    }

    @Override
    public JsonInclude.Include findSerializationInclusion(Annotated annotated, JsonInclude.Include include) {
        XmlElementWrapper xmlElementWrapper = annotated.getAnnotation(XmlElementWrapper.class);
        if (xmlElementWrapper != null) {
            return xmlElementWrapper.nillable() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL;
        }
        XmlElement xmlElement = annotated.getAnnotation(XmlElement.class);
        if (xmlElement != null) {
            return xmlElement.nillable() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL;
        }
        return include;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        XmlType xmlType = this.findAnnotation(XmlType.class, annotatedClass, true, true, true);
        if (xmlType == null) {
            return null;
        }
        String[] stringArray = xmlType.propOrder();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public Boolean findSerializationSortAlphabetically(AnnotatedClass annotatedClass) {
        XmlAccessorOrder xmlAccessorOrder = this.findAnnotation(XmlAccessorOrder.class, annotatedClass, true, true, true);
        return xmlAccessorOrder == null ? null : Boolean.valueOf(xmlAccessorOrder.value() == XmlAccessOrder.ALPHABETICAL);
    }

    @Override
    public Object findSerializationConverter(Annotated annotated) {
        Class<?> clazz = this._rawSerializationType(annotated);
        XmlAdapter<Object, Object> xmlAdapter = this.findAdapter(annotated, true, clazz);
        if (xmlAdapter != null) {
            return this._converter(xmlAdapter, true);
        }
        return null;
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember annotatedMember) {
        XmlAdapter<?, ?> xmlAdapter;
        Class<?> clazz = this._rawSerializationType(annotatedMember);
        if (this.isContainerType(clazz) && (xmlAdapter = this._findContentAdapter(annotatedMember, true)) != null) {
            return this._converter(xmlAdapter, true);
        }
        return null;
    }

    @Override
    public PropertyName findNameForSerialization(Annotated annotated) {
        if (annotated instanceof AnnotatedMethod) {
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotated;
            if (!this.isVisible(annotatedMethod)) {
                return null;
            }
            return JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, annotatedMethod.getRawType(), BeanUtil.okNameForGetter(annotatedMethod));
        }
        if (annotated instanceof AnnotatedField) {
            AnnotatedField annotatedField = (AnnotatedField)annotated;
            if (!this.isVisible(annotatedField)) {
                return null;
            }
            PropertyName propertyName = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
            if (propertyName == null) {
                return new PropertyName(annotatedField.getName());
            }
            return propertyName;
        }
        return null;
    }

    @Deprecated
    public String findSerializationName(AnnotatedMethod annotatedMethod) {
        if (!this.isVisible(annotatedMethod)) {
            return null;
        }
        return this._propertyNameToString(JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, annotatedMethod.getRawType(), BeanUtil.okNameForGetter(annotatedMethod)));
    }

    @Deprecated
    public String findSerializationName(AnnotatedField annotatedField) {
        if (!this.isVisible(annotatedField)) {
            return null;
        }
        PropertyName propertyName = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
        if (propertyName == null) {
            return annotatedField.getName();
        }
        return this._propertyNameToString(propertyName);
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    @Override
    public String findEnumValue(Enum<?> enum_) {
        Class<?> clazz = enum_.getDeclaringClass();
        String string = enum_.name();
        try {
            XmlEnumValue xmlEnumValue = clazz.getDeclaredField(string).getAnnotation(XmlEnumValue.class);
            return xmlEnumValue != null ? xmlEnumValue.value() : string;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("Could not locate Enum entry '" + string + "' (Enum class " + clazz.getName() + ")", noSuchFieldException);
        }
    }

    @Override
    public Object findDeserializer(Annotated annotated) {
        Class<?> clazz = this._rawDeserializationType(annotated);
        if (clazz != null && this._dataHandlerDeserializer != null && this.isDataHandler(clazz)) {
            return this._dataHandlerDeserializer;
        }
        return null;
    }

    @Override
    public Object findKeyDeserializer(Annotated annotated) {
        return null;
    }

    @Override
    public Object findContentDeserializer(Annotated annotated) {
        return null;
    }

    @Override
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        if (!javaType.isContainerType()) {
            return this._doFindDeserializationType(annotated, javaType);
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        return this._doFindDeserializationType(annotated, javaType);
    }

    protected Class<?> _doFindDeserializationType(Annotated annotated, JavaType javaType) {
        Class clazz;
        if (annotated.hasAnnotation(XmlJavaTypeAdapter.class)) {
            return null;
        }
        XmlElement xmlElement = this.findAnnotation(XmlElement.class, annotated, false, false, false);
        if (xmlElement != null && (clazz = xmlElement.type()) != XmlElement.DEFAULT.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated annotated) {
        if (annotated instanceof AnnotatedMethod) {
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotated;
            if (!this.isVisible((AnnotatedMethod)annotated)) {
                return null;
            }
            Class<?> clazz = annotatedMethod.getRawParameterType(0);
            return JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, clazz, BeanUtil.okNameForSetter(annotatedMethod));
        }
        if (annotated instanceof AnnotatedField) {
            AnnotatedField annotatedField = (AnnotatedField)annotated;
            if (!this.isVisible(annotatedField)) {
                return null;
            }
            PropertyName propertyName = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
            if (propertyName == null) {
                return new PropertyName(annotatedField.getName());
            }
            return propertyName;
        }
        return null;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedMethod annotatedMethod) {
        if (!this.isVisible(annotatedMethod)) {
            return null;
        }
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        return this._propertyNameToString(JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, clazz, BeanUtil.okNameForSetter(annotatedMethod)));
    }

    @Deprecated
    public String findDeserializationName(AnnotatedField annotatedField) {
        if (!this.isVisible(annotatedField)) {
            return null;
        }
        PropertyName propertyName = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
        if (propertyName == null) {
            return annotatedField.getName();
        }
        return this._propertyNameToString(propertyName);
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated annotated) {
        return false;
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        XmlElement xmlElement = annotatedMember.getAnnotation(XmlElement.class);
        return xmlElement == null ? null : Boolean.valueOf(xmlElement.required());
    }

    @Override
    public Object findDeserializationConverter(Annotated annotated) {
        Class<?> clazz = this._rawDeserializationType(annotated);
        if (this.isContainerType(clazz)) {
            XmlAdapter<Object, Object> xmlAdapter = this.findAdapter(annotated, true, clazz);
            if (xmlAdapter != null) {
                return this._converter(xmlAdapter, false);
            }
        } else {
            XmlAdapter<Object, Object> xmlAdapter = this.findAdapter(annotated, true, clazz);
            if (xmlAdapter != null) {
                return this._converter(xmlAdapter, false);
            }
        }
        return null;
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember annotatedMember) {
        XmlAdapter<?, ?> xmlAdapter;
        Class<?> clazz = this._rawDeserializationType(annotatedMember);
        if (this.isContainerType(clazz) && (xmlAdapter = this._findContentAdapter(annotatedMember, true)) != null) {
            return this._converter(xmlAdapter, false);
        }
        return null;
    }

    private boolean isVisible(AnnotatedField annotatedField) {
        for (XmlAccessType xmlAccessType : annotatedField.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isJAXBAnnotation((Annotation)xmlAccessType)) continue;
            return true;
        }
        XmlAccessType xmlAccessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType xmlAccessorType = this.findAnnotation(XmlAccessorType.class, annotatedField, true, true, true);
        if (xmlAccessorType != null) {
            xmlAccessType = xmlAccessorType.value();
        }
        if (xmlAccessType == XmlAccessType.FIELD) {
            return true;
        }
        if (xmlAccessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(annotatedField.getAnnotated().getModifiers());
        }
        return false;
    }

    private boolean isVisible(AnnotatedMethod annotatedMethod) {
        for (XmlAccessType xmlAccessType : annotatedMethod.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isJAXBAnnotation((Annotation)xmlAccessType)) continue;
            return true;
        }
        XmlAccessType xmlAccessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType xmlAccessorType = this.findAnnotation(XmlAccessorType.class, annotatedMethod, true, true, true);
        if (xmlAccessorType != null) {
            xmlAccessType = xmlAccessorType.value();
        }
        if (xmlAccessType == XmlAccessType.PROPERTY || xmlAccessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(annotatedMethod.getModifiers());
        }
        return false;
    }

    private <A extends Annotation> A findAnnotation(Class<A> clazz, Annotated annotated, boolean bl, boolean bl2, boolean bl3) {
        AnnotatedElement annotatedElement;
        A a = annotated.getAnnotation(clazz);
        if (a != null) {
            return a;
        }
        Class clazz2 = null;
        if (annotated instanceof AnnotatedParameter) {
            clazz2 = ((AnnotatedParameter)annotated).getDeclaringClass();
        } else {
            annotatedElement = annotated.getAnnotated();
            if (annotatedElement instanceof Member) {
                clazz2 = ((Member)((Object)annotatedElement)).getDeclaringClass();
                if (bl2 && (a = clazz2.getAnnotation(clazz)) != null) {
                    return a;
                }
            } else if (annotatedElement instanceof Class) {
                clazz2 = (Class)annotatedElement;
            } else {
                throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
            }
        }
        if (clazz2 != null) {
            if (bl3) {
                for (annotatedElement = clazz2.getSuperclass(); annotatedElement != null && annotatedElement != Object.class; annotatedElement = ((Class)annotatedElement).getSuperclass()) {
                    a = ((Class)annotatedElement).getAnnotation(clazz);
                    if (a == null) continue;
                    return a;
                }
            }
            if (bl && (annotatedElement = clazz2.getPackage()) != null) {
                return clazz2.getPackage().getAnnotation(clazz);
            }
        }
        return null;
    }

    protected boolean isJAXBAnnotation(Annotation annotation) {
        String string;
        Class<? extends Annotation> clazz = annotation.annotationType();
        Package package_ = clazz.getPackage();
        String string2 = string = package_ != null ? package_.getName() : clazz.getName();
        return string.startsWith(this._jaxbPackageName);
    }

    private static PropertyName findJaxbPropertyName(Annotated annotated, Class<?> clazz, String string) {
        XmlValue xmlValue;
        XmlAttribute xmlAttribute = annotated.getAnnotation(XmlAttribute.class);
        if (xmlAttribute != null) {
            return JaxbAnnotationIntrospector._combineNames(xmlAttribute.name(), xmlAttribute.namespace(), string);
        }
        XmlElement xmlElement = annotated.getAnnotation(XmlElement.class);
        if (xmlElement != null) {
            return JaxbAnnotationIntrospector._combineNames(xmlElement.name(), xmlElement.namespace(), string);
        }
        XmlElementRef xmlElementRef = annotated.getAnnotation(XmlElementRef.class);
        if (xmlElementRef != null) {
            if (!MARKER_FOR_DEFAULT.equals(xmlElementRef.name())) {
                return JaxbAnnotationIntrospector._combineNames(xmlElementRef.name(), xmlElementRef.namespace(), string);
            }
            if (clazz != null && (xmlValue = clazz.getAnnotation(XmlRootElement.class)) != null) {
                String string2 = xmlValue.name();
                if (!MARKER_FOR_DEFAULT.equals(string2)) {
                    return JaxbAnnotationIntrospector._combineNames(string2, xmlValue.namespace(), string);
                }
                return new PropertyName(Introspector.decapitalize(clazz.getSimpleName()));
            }
        }
        if ((xmlValue = annotated.getAnnotation(XmlValue.class)) != null) {
            return new PropertyName("value");
        }
        return null;
    }

    private static PropertyName _combineNames(String string, String string2, String string3) {
        if (MARKER_FOR_DEFAULT.equals(string)) {
            if (MARKER_FOR_DEFAULT.equals(string2)) {
                return new PropertyName(string3);
            }
            return new PropertyName(string3, string2);
        }
        if (MARKER_FOR_DEFAULT.equals(string2)) {
            return new PropertyName(string);
        }
        return new PropertyName(string, string2);
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass annotatedClass) {
        return this.findAnnotation(XmlRootElement.class, annotatedClass, true, false, true);
    }

    private XmlAdapter<Object, Object> findAdapter(Annotated annotated, boolean bl, Class<?> clazz) {
        XmlJavaTypeAdapters xmlJavaTypeAdapters;
        if (annotated instanceof AnnotatedClass) {
            return this.findAdapterForClass((AnnotatedClass)annotated, bl);
        }
        XmlJavaTypeAdapter xmlJavaTypeAdapter = this.findAnnotation(XmlJavaTypeAdapter.class, annotated, true, false, false);
        if (xmlJavaTypeAdapter != null && (xmlJavaTypeAdapters = this.checkAdapter(xmlJavaTypeAdapter, clazz, bl)) != null) {
            return xmlJavaTypeAdapters;
        }
        xmlJavaTypeAdapters = this.findAnnotation(XmlJavaTypeAdapters.class, annotated, true, false, false);
        if (xmlJavaTypeAdapters != null) {
            for (XmlJavaTypeAdapter xmlJavaTypeAdapter2 : xmlJavaTypeAdapters.value()) {
                XmlAdapter<Object, Object> xmlAdapter = this.checkAdapter(xmlJavaTypeAdapter2, clazz, bl);
                if (xmlAdapter == null) continue;
                return xmlAdapter;
            }
        }
        return null;
    }

    private final XmlAdapter<Object, Object> checkAdapter(XmlJavaTypeAdapter xmlJavaTypeAdapter, Class<?> clazz, boolean bl) {
        Object object;
        Class<?> clazz2 = xmlJavaTypeAdapter.type();
        if (clazz2 == XmlJavaTypeAdapter.DEFAULT.class) {
            object = this._typeFactory.findTypeParameters(xmlJavaTypeAdapter.value(), XmlAdapter.class);
            clazz2 = object[bl ? 1 : 0].getRawClass();
        }
        if (clazz2.isAssignableFrom(clazz)) {
            object = xmlJavaTypeAdapter.value();
            return (XmlAdapter)ClassUtil.createInstance(object, true);
        }
        return null;
    }

    private XmlAdapter<Object, Object> findAdapterForClass(AnnotatedClass annotatedClass, boolean bl) {
        XmlJavaTypeAdapter xmlJavaTypeAdapter = ((Class)annotatedClass.getAnnotated()).getAnnotation(XmlJavaTypeAdapter.class);
        if (xmlJavaTypeAdapter != null) {
            Class clazz = xmlJavaTypeAdapter.value();
            return (XmlAdapter)ClassUtil.createInstance(clazz, true);
        }
        return null;
    }

    protected final TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    private boolean isContainerType(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private boolean adapterTypeMatches(XmlAdapter<?, ?> xmlAdapter, Class<?> clazz) {
        return this.findAdapterBoundType(xmlAdapter).isAssignableFrom(clazz);
    }

    private Class<?> findAdapterBoundType(XmlAdapter<?, ?> xmlAdapter) {
        JavaType javaType;
        TypeFactory typeFactory = this.getTypeFactory();
        JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType = typeFactory.constructType(xmlAdapter.getClass()), XmlAdapter.class);
        if (javaTypeArray == null || javaTypeArray.length < 2) {
            return Object.class;
        }
        return javaTypeArray[1].getRawClass();
    }

    protected XmlAdapter<?, ?> _findContentAdapter(Annotated annotated, boolean bl) {
        JavaType javaType;
        Class<?> clazz;
        AnnotatedMember annotatedMember;
        XmlAdapter<Object, Object> xmlAdapter;
        Class<?> clazz2;
        Class<?> clazz3 = clazz2 = bl ? this._rawSerializationType(annotated) : this._rawDeserializationType(annotated);
        if (this.isContainerType(clazz2) && annotated instanceof AnnotatedMember && (xmlAdapter = this.findAdapter(annotatedMember = (AnnotatedMember)annotated, bl, clazz = (javaType = bl ? this._fullSerializationType(annotatedMember) : this._fullDeserializationType(annotatedMember)).getContentType().getRawClass())) != null && this.adapterTypeMatches(xmlAdapter, clazz)) {
            return xmlAdapter;
        }
        return null;
    }

    protected String _propertyNameToString(PropertyName propertyName) {
        return propertyName == null ? null : propertyName.getSimpleName();
    }

    protected Class<?> _rawDeserializationType(Annotated annotated) {
        AnnotatedMethod annotatedMethod;
        if (annotated instanceof AnnotatedMethod && (annotatedMethod = (AnnotatedMethod)annotated).getParameterCount() == 1) {
            return annotatedMethod.getRawParameterType(0);
        }
        return annotated.getRawType();
    }

    protected JavaType _fullDeserializationType(AnnotatedMember annotatedMember) {
        AnnotatedMethod annotatedMethod;
        if (annotatedMember instanceof AnnotatedMethod && (annotatedMethod = (AnnotatedMethod)annotatedMember).getParameterCount() == 1) {
            return this.getTypeFactory().constructType(((AnnotatedMethod)annotatedMember).getGenericParameterType(0), annotatedMember.getDeclaringClass());
        }
        return this.getTypeFactory().constructType(annotatedMember.getGenericType(), annotatedMember.getDeclaringClass());
    }

    protected Class<?> _rawSerializationType(Annotated annotated) {
        return annotated.getRawType();
    }

    protected JavaType _fullSerializationType(AnnotatedMember annotatedMember) {
        return this.getTypeFactory().constructType(annotatedMember.getGenericType(), annotatedMember.getDeclaringClass());
    }

    protected Converter<Object, Object> _converter(XmlAdapter<?, ?> xmlAdapter, boolean bl) {
        JavaType[] javaTypeArray = this.getTypeFactory().findTypeParameters(xmlAdapter.getClass(), XmlAdapter.class);
        if (bl) {
            return new AdapterConverter(xmlAdapter, javaTypeArray[1], javaTypeArray[0], bl);
        }
        return new AdapterConverter(xmlAdapter, javaTypeArray[0], javaTypeArray[1], bl);
    }
}

