/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.builders;

import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.gcube.common.clients.builders.AbstractBuilder;
import org.gcube.common.clients.builders.AddressingUtils;
import org.gcube.common.clients.builders.StatefulBuilderAPI;
import org.gcube.common.clients.cache.EndpointCache;
import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.delegates.ProxyPlugin;
import org.gcube.common.clients.queries.Query;

public abstract class AbstractStatefulBuilder<A, S, P>
extends AbstractBuilder<A, S, P>
implements StatefulBuilderAPI.Builder<A, P>,
StatefulBuilderAPI.SecondClause<P>,
StatefulBuilderAPI.FinalClause<P> {
    protected AbstractStatefulBuilder(ProxyPlugin<A, S, P> plugin, EndpointCache<A> cache, Property<?> ... properties) {
        super(plugin, cache, properties);
    }

    @Override
    public StatefulBuilderAPI.SecondClause<P> matching(Query<A> query) {
        this.setQuery(query);
        return this;
    }

    @Override
    public StatefulBuilderAPI.SecondClause<P> at(W3CEndpointReference address) {
        this.setAddress(address);
        return this;
    }

    @Override
    public StatefulBuilderAPI.SecondClause<P> at(String key, String host, int port) {
        this.setAddress(AddressingUtils.address(this.contextPath(), this.plugin().name(), this.plugin().namespace(), key, host, port));
        return this;
    }

    @Override
    public StatefulBuilderAPI.SecondClause<P> at(String key, URL address) {
        this.setAddress(AddressingUtils.address(this.contextPath(), this.plugin().name(), this.plugin().namespace(), key, address));
        return this;
    }

    @Override
    public StatefulBuilderAPI.SecondClause<P> at(String key, URI address) {
        this.setAddress(AddressingUtils.address(this.contextPath(), this.plugin().name(), this.plugin().namespace(), key, address));
        return this;
    }

    @Override
    public StatefulBuilderAPI.FinalClause<P> withTimeout(int duration, TimeUnit unit) {
        this.setTimeout((int)unit.toMillis(duration));
        return this;
    }

    @Override
    public StatefulBuilderAPI.SecondClause<P> with(Property<?> property) {
        this.addProperty(property);
        return this;
    }

    @Override
    public <T> StatefulBuilderAPI.SecondClause<P> with(String name, T value) {
        this.addProperty(new Property<T>(name, value));
        return this;
    }
}

