/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.mapper.CompositeTypeMapper;
import jnr.ffi.mapper.DefaultSignatureType;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.provider.ClosureManager;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.ClosureFromNativeConverter;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.SimpleNativeContext;
import ru.serce.jnrfuse.FuseException;

public class ClosureHelper {
    private final AsmClassLoader asmClassLoader;
    private final CompositeTypeMapper ctm;
    private final SimpleNativeContext ctx;
    private final ConcurrentHashMap<Class<?>, FromNativeConverter<?, Pointer>> cache = new ConcurrentHashMap();

    public static ClosureHelper getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public <T> FromNativeConverter<T, Pointer> getNativeConveter(Class<T> closureClass) {
        FromNativeConverter<?, Pointer> result = this.cache.get(closureClass);
        if (result != null) {
            return result;
        }
        result = ClosureFromNativeConverter.getInstance(Runtime.getSystemRuntime(), DefaultSignatureType.create(closureClass, this.ctx), this.asmClassLoader, this.ctm);
        this.cache.putIfAbsent(closureClass, result);
        return result;
    }

    public FromNativeContext getFromNativeContext() {
        return this.ctx;
    }

    private ClosureHelper() {
        try {
            ClosureManager closureManager = Runtime.getSystemRuntime().getClosureManager();
            Field asmClassLoadersField = NativeClosureManager.class.getDeclaredField("asmClassLoaders");
            asmClassLoadersField.setAccessible(true);
            Map asmClassLoaders = (Map)asmClassLoadersField.get(closureManager);
            this.asmClassLoader = (AsmClassLoader)asmClassLoaders.get(ClosureHelper.class.getClassLoader());
            Field typeMapperField = NativeClosureManager.class.getDeclaredField("typeMapper");
            typeMapperField.setAccessible(true);
            this.ctm = (CompositeTypeMapper)typeMapperField.get(closureManager);
            this.ctx = new SimpleNativeContext(Runtime.getSystemRuntime(), Collections.emptyList());
        }
        catch (Exception e) {
            throw new FuseException("Unable to create helper", e);
        }
    }

    private static class SingletonHolder {
        private static final ClosureHelper INSTANCE = new ClosureHelper();

        private SingletonHolder() {
        }
    }
}

