/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.generic.storeByValueSimulation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.CloneCopyTransformer;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.ObjectCopyFactory;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.ObjectTransformer;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.SerializableCopyTransformer;

public class SimpleObjectCopyFactory
implements ObjectCopyFactory {
    @Override
    public <T> ObjectTransformer<T, T> createCopyTransformer(Class<T> clazz) {
        return this.createCopyTransformer(clazz, this.getClass().getClassLoader());
    }

    @Override
    public <T> ObjectTransformer<T, T> createCopyTransformer(Class<T> clazz, ClassLoader classLoader) {
        if (SimpleObjectCopyFactory.isImmutable(clazz)) {
            return ObjectTransformer.IDENT_TRANSFORM;
        }
        Method m = SimpleObjectCopyFactory.extractPublicClone(clazz);
        if (m != null) {
            return new CloneCopyTransformer(m);
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return new SerializableCopyTransformer(classLoader);
        }
        return null;
    }

    static boolean isImmutable(Class<?> clazz) {
        return String.class == clazz || Number.class.isAssignableFrom(clazz);
    }

    static Method extractPublicClone(Class<?> clazz) {
        if (Cloneable.class.isAssignableFrom(clazz)) {
            Method m = null;
            try {
                m = clazz.getMethod("clone", new Class[0]);
                if (Modifier.isPublic(m.getModifiers())) {
                    return m;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

