/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.clients.cache.EndpointCache;
import org.gcube.common.clients.cache.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointCache<A>
implements EndpointCache<A> {
    private static Logger logger = LoggerFactory.getLogger(DefaultEndpointCache.class);
    private Map<Key, A> cache = Collections.synchronizedMap(new HashMap());

    @Override
    public void clear(Key key) throws IllegalArgumentException {
        this.assertnotNull(key, "key");
        logger.debug("clearing cache {} for {}", (Object)this, (Object)key);
        this.cache.put(key, null);
    }

    @Override
    public A get(Key key) throws IllegalArgumentException {
        this.assertnotNull(key, "key");
        return this.cache.get(key);
    }

    @Override
    public void put(Key key, A address) throws IllegalArgumentException {
        this.assertnotNull(key, "key");
        this.assertnotNull(address, "address");
        logger.debug("caching {} for {}", (Object)address, (Object)key);
        this.cache.put(key, address);
    }

    private void assertnotNull(Object object, String msg) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(msg + " is null");
        }
    }
}

