/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration;

import org.cache2k.impl.xmlConfiguration.ConfigurationException;
import org.cache2k.impl.xmlConfiguration.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.ParsedConfiguration;

public class ConfigurationParser {
    static ParsedConfiguration parse(ConfigurationTokenizer _parser) throws Exception {
        ParsedConfiguration c = new ParsedConfiguration(_parser.getSource(), _parser.getLineNumber());
        ConfigurationParser.parseTopLevelSections(_parser, c);
        ConfigurationTokenizer.Item _item = _parser.next();
        return c;
    }

    private static void parseSection(ConfigurationTokenizer _parser, ParsedConfiguration _container) throws Exception {
        while (true) {
            ConfigurationTokenizer.Item _item;
            if ((_item = _parser.next()) == null) {
                throw new ConfigurationException("null item", _parser);
            }
            if (_item instanceof ConfigurationTokenizer.Unnest) {
                return;
            }
            if (_item instanceof ConfigurationTokenizer.Property) {
                _container.addProperty((ConfigurationTokenizer.Property)_item);
                continue;
            }
            if (!(_item instanceof ConfigurationTokenizer.Nest)) continue;
            ConfigurationParser.parseSections(((ConfigurationTokenizer.Nest)_item).getSectionName(), _parser, _container);
        }
    }

    private static void parseSections(String _containerName, ConfigurationTokenizer _parser, ParsedConfiguration _container) throws Exception {
        boolean _maybeSection = true;
        ConfigurationTokenizer.Item _item;
        while ((_item = _parser.next()) != null) {
            if (_item instanceof ConfigurationTokenizer.Unnest) {
                return;
            }
            if (_item instanceof ConfigurationTokenizer.Property && _maybeSection) {
                ParsedConfiguration _nestedContainer = new ParsedConfiguration(_parser.getSource(), _parser.getLineNumber());
                _nestedContainer.setName(_containerName);
                _nestedContainer.setPropertyContext(_containerName);
                _nestedContainer.setContainer("#DIRECT");
                _nestedContainer.addProperty((ConfigurationTokenizer.Property)_item);
                ConfigurationParser.parseSection(_parser, _nestedContainer);
                _container.addSection(_nestedContainer);
                return;
            }
            if (!(_item instanceof ConfigurationTokenizer.Nest)) {
                throw new ConfigurationException("section start expected", _item);
            }
            ConfigurationTokenizer.Nest _sectionStart = (ConfigurationTokenizer.Nest)_item;
            ParsedConfiguration _nestedContainer = new ParsedConfiguration(_parser.getSource(), _parser.getLineNumber());
            _nestedContainer.setName(_sectionStart.getSectionName());
            _nestedContainer.setPropertyContext(_sectionStart.getSectionName());
            _nestedContainer.setContainer(_containerName);
            ConfigurationParser.parseSection(_parser, _nestedContainer);
            _container.addSection(_nestedContainer);
            _maybeSection = false;
        }
        return;
    }

    private static void parseTopLevelSections(ConfigurationTokenizer _parser, ParsedConfiguration _container) throws Exception {
        ConfigurationTokenizer.Item _item = _parser.next();
        if (!(_item instanceof ConfigurationTokenizer.Nest)) {
            throw new ConfigurationException("start expected", _item);
        }
        while ((_item = _parser.next()) != null) {
            if (_item instanceof ConfigurationTokenizer.Unnest) {
                return;
            }
            if (_item instanceof ConfigurationTokenizer.Property) {
                _container.addProperty((ConfigurationTokenizer.Property)_item);
                continue;
            }
            if (!(_item instanceof ConfigurationTokenizer.Nest)) continue;
            ConfigurationTokenizer.Nest _sectionStart = (ConfigurationTokenizer.Nest)_item;
            ParsedConfiguration _nestedContainer = new ParsedConfiguration(_parser.getSource(), _parser.getLineNumber());
            _nestedContainer.setName(_sectionStart.getSectionName());
            ConfigurationParser.parseSections(((ConfigurationTokenizer.Nest)_item).getSectionName(), _parser, _nestedContainer);
            if (_nestedContainer.getPropertyMap().isEmpty() && _nestedContainer.getSections().size() == 1 && _nestedContainer.getSections().get(0).getContainer().equals("#DIRECT")) {
                _nestedContainer = _nestedContainer.getSections().get(0);
            }
            _container.addSection(_nestedContainer);
        }
        return;
    }
}

