/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.client.proxies.DefaultManagerClient;
import org.gcube.common.storagehub.client.proxies.MessageManagerClient;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.messages.Message;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.types.MessageList;

public class DefaultMessageManager
extends DefaultManagerClient
implements MessageManagerClient {
    public DefaultMessageManager(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
        super(delegate);
    }

    @Override
    public Message get(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Message> call = new Call<GXWebTargetAdapterRequest, Message>(){

            @Override
            public Message call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id);
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                Message item = response.getSource().readEntity(Message.class);
                return item;
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<Message> getReceivedMessages(int reduceBody) throws StorageHubException {
        return this.getMessages("inbox", reduceBody);
    }

    @Override
    public List<Message> getSentMessages(int reduceBody) throws StorageHubException {
        return this.getMessages("sent", reduceBody);
    }

    @Override
    public List<Message> getReceivedMessages() throws StorageHubException {
        return this.getMessages("inbox", -1);
    }

    @Override
    public List<Message> getSentMessages() throws StorageHubException {
        return this.getMessages("sent", -1);
    }

    @Override
    public void setRead(String id, Boolean value) throws StorageHubException {
        this.setBooleanProp("hl:read", value, id);
    }

    @Override
    public void setOpened(String id, Boolean value) throws StorageHubException {
        this.setBooleanProp("hl:open", value, id);
    }

    private void setBooleanProp(final String prop, final Boolean bool, final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path(id).path(prop);
                GXInboundResponse response = myManager.put(Entity.json(bool));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String sendMessage(final List<String> recipients, final String subject, final String body, final List<String> attachments) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            @Override
            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.requireNonNull(recipients, "recipients cannot be null");
                Objects.requireNonNull(subject, "subject cannot be null");
                Objects.requireNonNull(body, "body cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path("send");
                MultivaluedHashMap<String, String> formData = new MultivaluedHashMap<String, String>();
                recipients.forEach(r -> formData.add("to[]", (String)r));
                formData.add("subject", subject);
                formData.add("body", body);
                if (attachments != null) {
                    attachments.forEach(a -> formData.add("attachments[]", (String)a));
                }
                if ((response = myManager.post(Entity.entity(formData, "application/x-www-form-urlencoded"))).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return response.getSource().readEntity(String.class);
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void delete(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            @Override
            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id);
                GXInboundResponse response = myManager.delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return null;
            }
        };
        try {
            this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<? extends Item> getAttachments(final String messageId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            @Override
            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path(messageId).path("attachments");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return response.getSource().readEntity(ItemList.class);
            }
        };
        try {
            return this.delegate.make(call).getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private List<Message> getMessages(final String path, final int reduceBody) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<Message>> call = new Call<GXWebTargetAdapterRequest, List<Message>>(){

            @Override
            public List<Message> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                GXWebTargetAdapterRequest myManager = manager.path(path);
                if (reduceBody > 0) {
                    myManager.queryParams(Collections.singletonMap("reduceBody", new Object[]{reduceBody}));
                }
                if ((response = myManager.get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return response.getSource().readEntity(MessageList.class).getMessages();
            }
        };
        try {
            return this.delegate.make(call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }
}

