/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cache2k.AbstractCacheEntry;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.core.BaseCache;
import org.cache2k.core.CacheBaseInfo;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.CommonMetricsFactory;
import org.cache2k.core.ConcurrentEntryIterator;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.Eviction;
import org.cache2k.core.EvictionMetrics;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.ExclusiveExecutor;
import org.cache2k.core.ExpiryPolicyException;
import org.cache2k.core.Hash2;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.MapValueConverterProxy;
import org.cache2k.core.ResiliencePolicyException;
import org.cache2k.core.StandardCommonMetricsFactory;
import org.cache2k.core.StandardExceptionPropagator;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.concurrency.DefaultThreadFactoryProvider;
import org.cache2k.core.concurrency.Job;
import org.cache2k.core.concurrency.OptimisticLock;
import org.cache2k.core.concurrency.ThreadFactoryProvider;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.ReadOnlyCacheEntry;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.util.InternalClock;
import org.cache2k.core.util.Log;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;
import org.cache2k.core.util.Util;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoaderException;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.RefreshedTimeWrapper;
import org.cache2k.processor.EntryProcessor;

public class HeapCache<K, V>
extends BaseCache<K, V> {
    static final CacheOperationCompletionListener DUMMY_LOAD_COMPLETED_LISTENER = new CacheOperationCompletionListener(){

        @Override
        public void onCompleted() {
        }

        @Override
        public void onException(Throwable _exception) {
        }
    };
    static final Random SEED_RANDOM = new Random(new SecureRandom().nextLong());
    static int cacheCnt = 0;
    public static final Tunable TUNABLE = TunableFactory.get(Tunable.class);
    public static final ExceptionPropagator DEFAULT_EXCEPTION_PROPAGATOR = HeapCache.TUNABLE.exceptionPropagator;
    protected final int hashSeed;
    protected String name;
    public CacheManagerImpl manager;
    protected AdvancedCacheLoader<K, V> loader;
    protected InternalClock clock;
    protected TimingHandler<K, V> timing;
    public final Object lock;
    protected CacheBaseInfo info;
    CommonMetrics.Updater metrics;
    protected volatile long keyMutationCnt;
    protected long clearedTime;
    protected long startedTime;
    Eviction eviction;
    protected long clearRemovedCnt;
    protected long clearCnt;
    protected long internalExceptionCnt;
    protected volatile Executor loaderExecutor;
    protected volatile Executor prefetchExecutor;
    protected final Hash2<K, V> hash;
    private volatile boolean closing;
    protected CacheType keyType;
    protected CacheType valueType;
    protected ExceptionPropagator<K> exceptionPropagator;
    private Collection<CustomizationSupplier<CacheClosedListener>> cacheClosedListeners;
    private int featureBits;
    private static final int KEEP_AFTER_EXPIRED = 2;
    private static final int REJECT_NULL_VALUES = 8;
    private static final int BACKGROUND_REFRESH = 16;
    private static final int UPDATE_TIME_NEEDED = 32;
    private static final int RECORD_REFRESH_TIME = 64;
    static final byte INSERT_STAT_LOAD = 1;
    static final byte INSERT_STAT_PUT = 2;
    private static final Object RESTART_AFTER_EVICTION = new Object();

    public HeapCache() {
        this.hashSeed = HeapCache.TUNABLE.disableHashRandomization ? HeapCache.TUNABLE.hashSeed : SEED_RANDOM.nextInt();
        this.timing = TimingHandler.ETERNAL;
        this.lock = new Object();
        this.keyMutationCnt = 0L;
        this.clearedTime = 0L;
        this.clearRemovedCnt = 0L;
        this.clearCnt = 0L;
        this.internalExceptionCnt = 0L;
        this.loaderExecutor = new LazyLoaderExecutor();
        this.prefetchExecutor = new LazyPrefetchExecutor();
        this.hash = this.createHashTable();
        this.closing = true;
        this.exceptionPropagator = DEFAULT_EXCEPTION_PROPAGATOR;
        this.cacheClosedListeners = Collections.EMPTY_LIST;
        this.featureBits = 0;
    }

    protected final boolean isKeepAfterExpired() {
        return (this.featureBits & 2) > 0;
    }

    protected final boolean isRejectNullValues() {
        return (this.featureBits & 8) > 0;
    }

    @Override
    public final boolean isNullValuePermitted() {
        return !this.isRejectNullValues();
    }

    protected final boolean isRefreshAhead() {
        return (this.featureBits & 0x10) > 0;
    }

    protected final boolean isUpdateTimeNeeded() {
        return (this.featureBits & 0x20) > 0;
    }

    protected final boolean isRecordRefreshTime() {
        return (this.featureBits & 0x40) > 0;
    }

    protected final void setFeatureBit(int _bitmask, boolean _flag) {
        this.featureBits = _flag ? (this.featureBits |= _bitmask) : (this.featureBits &= ~_bitmask);
    }

    public String getCompleteName() {
        return this.manager.getName() + ":" + this.name;
    }

    @Override
    public Log getLog() {
        return Log.getLog(Cache.class.getName() + '/' + this.getCompleteName());
    }

    public void setCacheConfig(final Cache2kConfiguration c) {
        this.valueType = c.getValueType();
        this.keyType = c.getKeyType();
        if (this.name != null) {
            throw new IllegalStateException("already configured");
        }
        this.setName(c.getName());
        this.setFeatureBit(2, c.isKeepDataAfterExpired());
        this.setFeatureBit(8, !c.isPermitNullValues());
        this.setFeatureBit(16, c.isRefreshAhead());
        this.setFeatureBit(32, c.isRecordRefreshedTime());
        this.setFeatureBit(64, c.isRecordRefreshedTime());
        this.metrics = HeapCache.TUNABLE.commonMetricsFactory.create(new CommonMetricsFactory.Parameters(){

            @Override
            public boolean isDisabled() {
                return c.isDisableStatistics();
            }

            @Override
            public boolean isPrecise() {
                return false;
            }
        });
        if (c.getLoaderExecutor() != null) {
            this.loaderExecutor = this.createCustomization(c.getLoaderExecutor());
        } else if (c.getLoaderThreadCount() > 0) {
            this.loaderExecutor = this.provideDefaultLoaderExecutor(c.getLoaderThreadCount());
        }
        if (c.getPrefetchExecutor() != null) {
            this.prefetchExecutor = this.createCustomization(c.getPrefetchExecutor());
        }
    }

    String getThreadNamePrefix() {
        return "cache2k-loader-" + Util.compactFullName(this.manager, this.name);
    }

    Executor provideDefaultLoaderExecutor(int _threadCount) {
        return new ExclusiveExecutor(_threadCount, this.getThreadNamePrefix());
    }

    public void setTiming(TimingHandler<K, V> rh) {
        this.timing = rh;
        if (!(rh instanceof TimingHandler.TimeAgnostic)) {
            this.setFeatureBit(32, true);
        }
    }

    public void setClock(InternalClock _clock) {
        this.clock = _clock;
    }

    public void setExceptionPropagator(ExceptionPropagator ep) {
        this.exceptionPropagator = ep;
    }

    public void setAdvancedLoader(AdvancedCacheLoader<K, V> al) {
        this.loader = al;
    }

    public void setName(String n) {
        if (n == null) {
            n = this.getClass().getSimpleName() + "#" + cacheCnt++;
        }
        this.name = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setCacheManager(CacheManagerImpl cm) {
        this.manager = cm;
    }

    @Override
    public CacheType getKeyType() {
        return this.keyType;
    }

    @Override
    public CacheType getValueType() {
        return this.valueType;
    }

    public void init() {
        this.timing.init(this);
        this.initWithoutTimerHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWithoutTimerHandler() {
        if (this.name == null) {
            this.name = String.valueOf(cacheCnt++);
        }
        Object object = this.lock;
        synchronized (object) {
            this.initializeHeapCache();
            if (this.isRefreshAhead() && this.loader == null) {
                throw new IllegalArgumentException("refresh ahead enabled, but no loader defined");
            }
            if (this.isRefreshAhead() && this.timing instanceof TimingHandler.TimeAgnostic) {
                throw new IllegalArgumentException("refresh ahead enabled, but no expiry variant defined");
            }
            this.closing = false;
        }
    }

    public void checkClosed() {
        if (this.closing) {
            throw new CacheClosedException(this);
        }
    }

    @Override
    public final void clear() {
        this.executeWithGlobalLock(new Job<Void>(){

            @Override
            public Void call() {
                HeapCache.this.clearLocalCache();
                return null;
            }
        });
    }

    public final void clearLocalCache() {
        long _removed = this.eviction.removeAll();
        this.clearRemovedCnt += _removed;
        ++this.clearCnt;
        this.initializeHeapCache();
        this.hash.clearWhenLocked();
        this.clearedTime = this.clock.millis();
    }

    protected void initializeHeapCache() {
        if (this.startedTime == 0L) {
            this.startedTime = this.clock.millis();
        }
        this.timing.reset();
    }

    @Override
    public void cancelTimerJobs() {
        this.timing.close();
    }

    @Override
    public boolean isClosed() {
        return this.closing;
    }

    public void closePart1() throws CacheClosedException {
        this.executeWithGlobalLock(new Job<Void>(){

            @Override
            public Void call() {
                HeapCache.this.closing = true;
                return null;
            }
        });
        this.closeCustomization(this.loaderExecutor, "loaderExecutor");
        this.cancelTimerJobs();
    }

    @Override
    public void close() {
        try {
            this.closePart1();
        }
        catch (CacheClosedException ex) {
            return;
        }
        this.closePart2(this);
    }

    public void closePart2(final InternalCache _userCache) {
        this.executeWithGlobalLock(new Job<Void>(){

            @Override
            public Void call() {
                HeapCache.this.eviction.close();
                HeapCache.this.timing.shutdown();
                HeapCache.this.hash.close();
                HeapCache.this.closeCustomization(HeapCache.this.loader, "loader");
                for (CustomizationSupplier s : HeapCache.this.cacheClosedListeners) {
                    ((CacheClosedListener)HeapCache.this.createCustomization(s)).onCacheClosed(_userCache);
                }
                HeapCache.this.manager.cacheDestroyed(_userCache);
                return null;
            }
        }, false);
    }

    public void setCacheClosedListeners(Collection<CustomizationSupplier<CacheClosedListener>> l) {
        this.cacheClosedListeners = l;
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        return new IteratorFilterEntry2Entry(this, this.iterateAllHeapEntries(), true);
    }

    protected void recordHit(Entry e) {
        ++e.hitCnt;
    }

    @Override
    public V get(K key) {
        Entry e = this.getEntryInternal(key);
        if (e == null) {
            return null;
        }
        return this.returnValue(e);
    }

    protected CacheEntry<K, V> returnEntry(ExaminationEntry<K, V> e) {
        if (e == null) {
            return null;
        }
        return this.returnCacheEntry(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEntryState(K key) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            return null;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            return e.toString(this);
        }
    }

    @Override
    public CacheEntry<K, V> returnCacheEntry(ExaminationEntry<K, V> _entry) {
        return this.returnCacheEntry(_entry.getKey(), _entry.getValueOrException());
    }

    public CacheEntry<K, V> returnCacheEntry(final K key, final V _valueOrException) {
        if (_valueOrException instanceof ExceptionWrapper) {
            final ExceptionWrapper _warpper = (ExceptionWrapper)_valueOrException;
            final ExceptionPropagator<K> _exceptionPropagator = this.exceptionPropagator;
            return new BaseCacheEntry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    throw _exceptionPropagator.propagateException(key, _warpper);
                }

                @Override
                public Throwable getException() {
                    return _warpper.getException();
                }
            };
        }
        return new BaseCacheEntry<K, V>(){
            V _value;
            {
                this._value = _valueOrException;
            }

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return this._value;
            }
        };
    }

    @Override
    public CacheEntry<K, V> getEntry(K key) {
        return this.returnEntry(this.getEntryInternal(key));
    }

    protected Entry getEntryInternal(K key) {
        int hc = this.modifiedHash(key.hashCode());
        return this.getEntryInternal(key, hc, this.extractIntKeyValue(key, hc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Entry<K, V> getEntryInternal(K key, int hc, int val) {
        Entry<K, V> e;
        if (this.loader == null) {
            return this.peekEntryInternal(key, hc, val);
        }
        while (true) {
            if ((e = this.lookupOrNewEntry(key, hc, val)).hasFreshData(this.clock)) {
                return e;
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (e.hasFreshData(this.clock)) {
                    return e;
                }
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            e.startProcessing(4);
        }
        boolean _finished = false;
        try {
            this.load(e);
            _finished = true;
        }
        finally {
            e.ensureAbort(_finished);
        }
        if (e.getValueOrException() == null && this.isRejectNullValues()) {
            return null;
        }
        return e;
    }

    protected void finishLoadOrEviction(Entry e, long _nextRefreshTime) {
        if (e.getProcessingState() != 7) {
            this.restartTimer(e, _nextRefreshTime);
        } else {
            this.startRefreshProbationTimer(e, _nextRefreshTime);
        }
        e.processingDone();
    }

    private void restartTimer(Entry e, long _nextRefreshTime) {
        e.setNextRefreshTime(this.timing.stopStartTimer(_nextRefreshTime, e));
        this.checkIfImmediatelyExpired(e);
    }

    private void checkIfImmediatelyExpired(Entry e) {
        if (e.isExpired()) {
            this.expireAndRemoveEventuallyAfterProcessing(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeEntry(Entry e) {
        boolean _removed;
        int hc = this.extractModifiedHash(e);
        OptimisticLock l = this.hash.getSegmentLock(hc);
        long _stamp = l.writeLock();
        try {
            _removed = this.hash.removeWithinLock(e, hc);
            e.setGone();
            if (_removed) {
                this.eviction.submitWithoutEviction(e);
            }
        }
        finally {
            l.unlockWrite(_stamp);
        }
        this.checkForHashCodeChange(e);
        this.timing.cancelExpiryTimer(e);
        return _removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V peekAndPut(K key, V _value) {
        Entry<K, V> e;
        int hc = this.modifiedHash(key.hashCode());
        int val = this.extractIntKeyValue(key, hc);
        Object _previousValue = null;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key, hc, val);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            boolean _hasFreshData = e.hasFreshData(this.clock);
            if (_hasFreshData) {
                _previousValue = e.getValueOrException();
            } else if (e.isVirgin()) {
                this.metrics.peekMiss();
            } else {
                this.metrics.peekHitNotFresh();
            }
            this.putValue(e, _value);
            return (V)this.returnValue(_previousValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V peekAndReplace(K key, V _value) {
        Entry<K, V> e;
        while ((e = this.lookupEntry(key)) != null) {
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (e.isGone()) {
                    this.metrics.goneSpin();
                    continue;
                }
                if (e.hasFreshData(this.clock)) {
                    Object _previousValue = e.getValueOrException();
                    this.putValue(e, _value);
                    return (V)this.returnValue(_previousValue);
                }
                break;
            }
        }
        this.metrics.peekMiss();
        return null;
    }

    protected final void putValue(Entry e, V _value) {
        if (!this.isUpdateTimeNeeded()) {
            this.insertOrUpdateAndCalculateExpiry(e, _value, 0L, 0L, 0L, (byte)2);
        } else {
            long t = this.clock.millis();
            this.insertOrUpdateAndCalculateExpiry(e, _value, t, t, t, (byte)2);
        }
    }

    @Override
    public boolean replace(K key, V _newValue) {
        return this.replace(key, false, null, _newValue);
    }

    @Override
    public boolean replaceIfEquals(K key, V _oldValue, V _newValue) {
        return this.replace(key, true, _oldValue, _newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean replace(K key, boolean _compare, V _oldValue, V _newValue) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            this.metrics.peekMiss();
            return false;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone() || !e.hasFreshData(this.clock)) {
                return false;
            }
            if (_compare && !e.equalsValue((Object)_oldValue)) {
                return false;
            }
            this.putValue(e, _newValue);
        }
        return true;
    }

    protected final Entry<K, V> peekEntryInternal(K key) {
        int hc = this.modifiedHash(key.hashCode());
        return this.peekEntryInternal(key, hc, this.extractIntKeyValue(key, hc));
    }

    protected final Entry<K, V> peekEntryInternal(K key, int hc, int val) {
        Entry<K, V> e = this.lookupEntry(key, hc, val);
        if (e == null) {
            this.metrics.peekMiss();
            return null;
        }
        if (e.hasFreshData(this.clock)) {
            return e;
        }
        this.metrics.peekHitNotFresh();
        return null;
    }

    @Override
    public boolean containsKey(K key) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e != null) {
            this.metrics.heapHitButNoRead();
            return e.hasFreshData(this.clock);
        }
        return false;
    }

    @Override
    public V peek(K key) {
        Entry<K, V> e = this.peekEntryInternal(key);
        if (e != null) {
            return this.returnValue(e);
        }
        return null;
    }

    @Override
    public CacheEntry<K, V> peekEntry(K key) {
        return this.returnEntry(this.peekEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V computeIfAbsent(K key, Callable<V> callable) {
        Entry<K, V> e;
        while (true) {
            if ((e = this.lookupOrNewEntry(key)).hasFreshData(this.clock)) {
                return this.returnValue(e);
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (e.hasFreshData(this.clock)) {
                    return this.returnValue(e);
                }
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            e.startProcessing(6);
        }
        this.metrics.peekMiss();
        boolean _finished = false;
        long t = 0L;
        long t0 = 0L;
        try {
            V _value;
            if (!this.isUpdateTimeNeeded()) {
                _value = callable.call();
            } else {
                t0 = this.clock.millis();
                _value = callable.call();
                if (!this.metrics.isDisabled()) {
                    t = this.clock.millis();
                }
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                this.insertOrUpdateAndCalculateExpiry(e, _value, t0, t, t0, (byte)2);
                e.processingDone();
            }
            _finished = true;
            return this.returnValue(e);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CacheLoaderException(ex);
        }
        finally {
            e.ensureAbort(_finished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean putIfAbsent(K key, V value) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            if (e.hasFreshData(this.clock)) {
                return false;
            }
            this.metrics.peekMiss();
            this.putValue(e, value);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(K key, V value) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            if (!e.isVirgin()) {
                this.metrics.heapHitButNoRead();
            }
            this.putValue(e, value);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAndRemove(K key) {
        Entry<K, V> e = this.lookupEntryNoHitRecord(key);
        if (e == null) {
            return false;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                return false;
            }
            boolean f = e.hasFreshData(this.clock);
            this.removeEntry(e);
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIfEquals(K key, V _value) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            this.metrics.peekMiss();
            return false;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                this.metrics.peekMiss();
                return false;
            }
            boolean f = e.hasFreshData(this.clock);
            if (f) {
                if (!e.equalsValue((Object)_value)) {
                    return false;
                }
            } else {
                this.metrics.peekHitNotFresh();
                return false;
            }
            this.removeEntry(e);
            return f;
        }
    }

    @Override
    public void remove(K key) {
        this.containsAndRemove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V peekAndRemove(K key) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            this.metrics.peekMiss();
            return null;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                this.metrics.peekMiss();
                return null;
            }
            Object _value = null;
            boolean f = e.hasFreshData(this.clock);
            if (f) {
                _value = e.getValueOrException();
            } else {
                this.metrics.peekHitNotFresh();
            }
            this.removeEntry(e);
            return (V)this.returnValue(_value);
        }
    }

    public Executor getPrefetchExecutor() {
        return this.prefetchExecutor;
    }

    @Override
    public void prefetch(final K key) {
        if (this.loader == null) {
            return;
        }
        Entry<K, V> e = this.lookupEntryNoHitRecord(key);
        if (e != null && e.hasFreshData(this.clock)) {
            return;
        }
        try {
            this.getPrefetchExecutor().execute(new RunWithCatch(this){

                @Override
                public void action() {
                    HeapCache.this.getEntryInternal(key);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prefetchAll(Iterable<? extends K> _keys, CacheOperationCompletionListener l) {
        CacheOperationCompletionListener _listener;
        CacheOperationCompletionListener cacheOperationCompletionListener = _listener = l != null ? l : DUMMY_LOAD_COMPLETED_LISTENER;
        if (this.loader == null) {
            _listener.onCompleted();
            return;
        }
        Set<K> _keysToLoad = this.checkAllPresent(_keys);
        final AtomicInteger _count = new AtomicInteger(2);
        try {
            Iterator<K> iterator = _keysToLoad.iterator();
            while (iterator.hasNext()) {
                K k;
                final K key = k = iterator.next();
                RunWithCatch r = new RunWithCatch(this){

                    @Override
                    public void action() {
                        try {
                            HeapCache.this.getEntryInternal(key);
                        }
                        finally {
                            if (_count.decrementAndGet() == 0) {
                                _listener.onCompleted();
                            }
                        }
                    }
                };
                try {
                    this.getPrefetchExecutor().execute(r);
                    _count.incrementAndGet();
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
        finally {
            if (_count.addAndGet(-2) == 0) {
                _listener.onCompleted();
            }
        }
    }

    @Override
    public void loadAll(Iterable<? extends K> _keys, CacheOperationCompletionListener l) {
        this.checkLoaderPresent();
        final CacheOperationCompletionListener _listener = l != null ? l : DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keysToLoad = this.checkAllPresent(_keys);
        if (_keysToLoad.isEmpty()) {
            _listener.onCompleted();
            return;
        }
        final AtomicInteger _countDown = new AtomicInteger(_keysToLoad.size());
        Iterator<K> iterator = _keysToLoad.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            RunWithCatch r = new RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        HeapCache.this.getEntryInternal(key);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.onCompleted();
                        }
                    }
                }
            };
            try {
                this.loaderExecutor.execute(r);
            }
            catch (RejectedExecutionException ex) {
                r.run();
            }
        }
    }

    @Override
    public void reloadAll(Iterable<? extends K> _keys, CacheOperationCompletionListener l) {
        this.checkLoaderPresent();
        final CacheOperationCompletionListener _listener = l != null ? l : DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keySet = this.generateKeySet(_keys);
        final AtomicInteger _countDown = new AtomicInteger(_keySet.size());
        Iterator<K> iterator = _keySet.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            RunWithCatch r = new RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        HeapCache.this.loadAndReplace(key);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.onCompleted();
                        }
                    }
                }
            };
            try {
                this.loaderExecutor.execute(r);
            }
            catch (RejectedExecutionException ex) {
                r.run();
            }
        }
    }

    public Set<K> generateKeySet(Iterable<? extends K> _keys) {
        HashSet<K> _keySet = new HashSet<K>();
        for (K k : _keys) {
            _keySet.add(k);
        }
        return _keySet;
    }

    public Set<K> checkAllPresent(Iterable<? extends K> keys) {
        HashSet<K> _keysToLoad = new HashSet<K>();
        for (K k : keys) {
            Entry<K, V> e = this.lookupEntryNoHitRecord(k);
            if (e != null && e.hasFreshData(this.clock)) continue;
            _keysToLoad.add(k);
        }
        return _keysToLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadAndReplace(K key) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            e.startProcessing(4);
        }
        boolean _finished = false;
        try {
            this.load(e);
            _finished = true;
            return;
        }
        finally {
            e.ensureAbort(_finished);
        }
    }

    protected Entry<K, V> lookupOrNewEntry(K key) {
        int hc = this.modifiedHash(key.hashCode());
        return this.lookupOrNewEntry(key, hc, this.extractIntKeyValue(key, hc));
    }

    protected Entry<K, V> lookupOrNewEntry(K key, int hc, int val) {
        Entry<K, V> e = this.lookupEntry(key, hc, val);
        if (e == null) {
            return this.insertNewEntry(key, hc, val);
        }
        return e;
    }

    protected Entry<K, V> lookupOrNewEntryNoHitRecord(K key) {
        int hc = this.modifiedHash(key.hashCode());
        Entry<K, V> e = this.lookupEntryNoHitRecord(key, hc, this.extractIntKeyValue(key, hc));
        if (e == null) {
            e = this.insertNewEntry(key, hc, this.extractIntKeyValue(key, hc));
        }
        return e;
    }

    protected V returnValue(V v) {
        if (v instanceof ExceptionWrapper) {
            ExceptionWrapper w = (ExceptionWrapper)v;
            throw this.exceptionPropagator.propagateException(w.getKey(), w);
        }
        return v;
    }

    protected V returnValue(Entry<K, V> e) {
        Object v = e.getValueOrException();
        if (v instanceof ExceptionWrapper) {
            ExceptionWrapper w = (ExceptionWrapper)v;
            throw this.exceptionPropagator.propagateException(w.getKey(), w);
        }
        return (V)v;
    }

    protected Entry<K, V> lookupEntry(K key) {
        int hc = this.modifiedHash(key.hashCode());
        return this.lookupEntry(key, hc, this.extractIntKeyValue(key, hc));
    }

    protected Entry<K, V> lookupEntryNoHitRecord(K key) {
        int hc = this.modifiedHash(key.hashCode());
        return this.lookupEntryNoHitRecord(key, hc, this.extractIntKeyValue(key, hc));
    }

    protected final Entry<K, V> lookupEntry(K key, int hc, int val) {
        Entry<K, V> e = this.lookupEntryNoHitRecord(key, hc, val);
        if (e != null) {
            this.recordHit(e);
            return e;
        }
        return null;
    }

    protected final Entry<K, V> lookupEntryNoHitRecord(K key, int hc, int val) {
        return this.hash.lookup(this.extractIntKeyObj(key), hc, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry<K, V> insertNewEntry(K key, int hc, int val) {
        Entry<K, V> e2;
        Entry e = new Entry(this.extractIntKeyObj(key), val);
        OptimisticLock l = this.hash.getSegmentLock(hc);
        long _stamp = l.writeLock();
        boolean _needsEviction = false;
        try {
            e2 = this.hash.insertWithinLock(e, hc, val);
            if (e == e2) {
                _needsEviction = this.eviction.submitWithoutEviction(e);
            }
        }
        finally {
            l.unlockWrite(_stamp);
        }
        if (_needsEviction) {
            this.eviction.evictEventually(hc);
        }
        this.hash.checkExpand(hc);
        return e2;
    }

    public void removeEntryForEviction(Entry<K, V> e) {
        boolean f = this.hash.remove(e);
        this.checkForHashCodeChange(e);
        this.timing.cancelExpiryTimer(e);
        e.setGone();
    }

    private void checkForHashCodeChange(Entry<K, V> e) {
        K key = this.extractKeyObj(e);
        if (this.extractIntKeyValue(key, this.modifiedHash(key.hashCode())) != e.hashCode) {
            if (this.keyMutationCnt == 0L) {
                this.getLog().warn("Key mismatch! Key hashcode changed! keyClass=" + e.getKey().getClass().getName());
                try {
                    String s = e.getKey().toString();
                    if (s != null) {
                        this.getLog().warn("Key mismatch! key.toString(): " + s);
                    }
                }
                catch (Throwable t) {
                    this.getLog().warn("Key mismatch! key.toString() threw exception", t);
                }
            }
            ++this.keyMutationCnt;
        }
    }

    protected void load(Entry<K, V> e) {
        V v;
        long t0;
        long refreshTime = t0 = !this.isUpdateTimeNeeded() ? 0L : this.clock.millis();
        if (e.getNextRefreshTime() == 6L && this.entryInRefreshProbationAccessed(e, t0)) {
            return;
        }
        try {
            this.checkLoaderPresent();
            v = e.isVirgin() ? this.loader.load(this.extractKeyObj(e), t0, null) : this.loader.load(this.extractKeyObj(e), t0, e);
            if (v instanceof RefreshedTimeWrapper) {
                RefreshedTimeWrapper wr = (RefreshedTimeWrapper)RefreshedTimeWrapper.class.cast(v);
                refreshTime = wr.getRefreshTime();
                v = wr.getValue();
            }
        }
        catch (Throwable _ouch) {
            long t = t0;
            if (!this.metrics.isDisabled() && this.isUpdateTimeNeeded()) {
                t = this.clock.millis();
            }
            this.loadGotException(e, t0, t, _ouch);
            return;
        }
        long t = t0;
        if (!this.metrics.isDisabled() && this.isUpdateTimeNeeded()) {
            t = this.clock.millis();
        }
        this.insertOrUpdateAndCalculateExpiry(e, v, t0, t, refreshTime, (byte)1);
    }

    private boolean entryInRefreshProbationAccessed(Entry<K, V> e, long now) {
        long nrt = e.getRefreshProbationNextRefreshTime();
        if (nrt > now) {
            this.reviveRefreshedEntry(e, nrt);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviveRefreshedEntry(Entry<K, V> e, long _nrt) {
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.metrics.refreshedHit();
            this.finishLoadOrEviction(e, _nrt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGotException(Entry<K, V> e, long t0, long t, Throwable _wrappedException) {
        ExceptionWrapper<K> _value = new ExceptionWrapper<K>(this.extractKeyObj(e), _wrappedException, t0, e);
        long _nextRefreshTime = 0L;
        boolean _suppressException = false;
        try {
            if ((e.isDataValid() || e.isExpired()) && e.getException() == null) {
                _nextRefreshTime = this.timing.suppressExceptionUntil(e, _value);
            }
            if (_nextRefreshTime > t0) {
                _suppressException = true;
            } else {
                _nextRefreshTime = this.timing.cacheExceptionUntil(e, _value);
            }
        }
        catch (Exception ex) {
            this.resiliencePolicyException(e, t0, t, new ResiliencePolicyException(ex));
            return;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.insertUpdateStats(e, _value, t0, t, (byte)1, _nextRefreshTime, _suppressException);
            if (_suppressException) {
                e.setSuppressedLoadExceptionInformation(_value);
            } else {
                if (this.isRecordRefreshTime()) {
                    e.setRefreshTime(t0);
                }
                e.setValueOrException(_value);
            }
            _value.setUntil(Math.abs(_nextRefreshTime));
            this.finishLoadOrEviction(e, _nextRefreshTime);
        }
    }

    private void resiliencePolicyException(Entry<K, V> e, long t0, long t, Throwable _exception) {
        ExceptionWrapper<K> _value = new ExceptionWrapper<K>(this.extractKeyObj(e), _exception, t0, e);
        this.insert(e, _value, t0, t, t0, (byte)1, 0L);
    }

    private void checkLoaderPresent() {
        if (this.loader == null) {
            throw new UnsupportedOperationException("loader not set");
        }
    }

    protected final void insertOrUpdateAndCalculateExpiry(Entry<K, V> e, V v, long t0, long t, long _refreshTime, byte _updateStatistics) {
        long _nextRefreshTime;
        try {
            _nextRefreshTime = this.timing.calculateNextRefreshTime(e, v, _refreshTime);
        }
        catch (Exception ex) {
            ExpiryPolicyException _wrappedException = new ExpiryPolicyException(ex);
            if (_updateStatistics == 1) {
                this.loadGotException(e, t0, t, _wrappedException);
                return;
            }
            this.insertUpdateStats(e, v, t0, t, _updateStatistics, Long.MAX_VALUE, false);
            throw _wrappedException;
        }
        this.insert(e, v, t0, t, _refreshTime, _updateStatistics, _nextRefreshTime);
    }

    public RuntimeException returnNullValueDetectedException() {
        return new NullPointerException("null value not allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void insert(Entry<K, V> e, V _value, long t0, long t, long _refreshTime, byte _updateStatistics, long _nextRefreshTime) {
        if (_updateStatistics == 1) {
            if (_value == null && this.isRejectNullValues() && _nextRefreshTime != 0L) {
                this.loadGotException(e, t0, t, this.returnNullValueDetectedException());
                return;
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                if (this.isRecordRefreshTime()) {
                    e.setRefreshTime(_refreshTime);
                }
                this.insertUpdateStats(e, _value, t0, t, _updateStatistics, _nextRefreshTime, false);
                e.setValueOrException((Object)_value);
                e.resetSuppressedLoadExceptionInformation();
                this.finishLoadOrEviction(e, _nextRefreshTime);
            }
        } else {
            if (_value == null && this.isRejectNullValues()) {
                throw this.returnNullValueDetectedException();
            }
            if (this.isRecordRefreshTime()) {
                e.setRefreshTime(_refreshTime);
            }
            e.setValueOrException((Object)_value);
            e.resetSuppressedLoadExceptionInformation();
            this.insertUpdateStats(e, _value, t0, t, _updateStatistics, _nextRefreshTime, false);
            this.restartTimer(e, _nextRefreshTime);
        }
    }

    private void insertUpdateStats(Entry<K, V> e, V _value, long t0, long t, byte _updateStatistics, long _nextRefreshTime, boolean _suppressException) {
        if (_updateStatistics == 1) {
            if (_suppressException) {
                this.metrics.suppressedException();
            } else if (_value instanceof ExceptionWrapper) {
                this.metrics.loadException();
            }
            long _millis = t - t0;
            if (e.isGettingRefresh()) {
                this.metrics.refresh(_millis);
            } else if (e.isVirgin()) {
                this.metrics.load(_millis);
            } else {
                this.metrics.reload(_millis);
            }
        } else if (_nextRefreshTime != 0L) {
            this.metrics.putNewEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventRefresh(final Entry<K, V> e) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.isGone()) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HeapCache.this.refreshEntry(e);
                }
            };
            try {
                this.loaderExecutor.execute(r);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.metrics.refreshFailed();
                this.expireOrScheduleFinalExpireEvent(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshEntry(Entry<K, V> e) {
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                return;
            }
            e.startProcessing(7);
        }
        boolean _finished = false;
        try {
            this.load(e);
            _finished = true;
        }
        catch (CacheClosedException cacheClosedException) {
        }
        catch (Throwable ex) {
            this.logAndCountInternalException("Refresh exception", ex);
            try {
                Entry<K, V> entry2 = e;
                synchronized (entry2) {
                    this.expireEntry(e);
                }
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
        finally {
            e.ensureAbort(_finished);
        }
    }

    public void startRefreshProbationTimer(Entry<K, V> e, long _nextRefreshTime) {
        boolean _expired = this.timing.startRefreshProbationTimer(e, _nextRefreshTime);
        if (_expired) {
            this.expireAndRemoveEventually(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventProbationTerminated(Entry<K, V> e) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.expireEntry(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logAndCountInternalException(String _text, Throwable _exception) {
        Object object = this.lock;
        synchronized (object) {
            ++this.internalExceptionCnt;
        }
        this.getLog().warn(_text, _exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventExpireEntry(Entry<K, V> e) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.expireOrScheduleFinalExpireEvent(e);
        }
    }

    @Override
    public void expireOrScheduleFinalExpireEvent(Entry<K, V> e) {
        long nrt = e.getNextRefreshTime();
        if (e.isGone() || e.isExpired()) {
            return;
        }
        long t = this.clock.millis();
        if (t >= Math.abs(nrt)) {
            try {
                this.expireEntry(e);
            }
            catch (CacheClosedException cacheClosedException) {}
        } else {
            if (nrt <= 0L) {
                return;
            }
            this.timing.scheduleFinalTimerForSharpExpiry(e);
            e.setNextRefreshTime(-nrt);
        }
    }

    protected void expireEntry(Entry e) {
        if (e.isGone() || e.isExpired()) {
            return;
        }
        e.setExpiredState();
        this.expireAndRemoveEventually(e);
    }

    private void expireAndRemoveEventually(Entry e) {
        if (this.isKeepAfterExpired() || e.isProcessing()) {
            this.metrics.expiredKept();
        } else {
            this.removeEntry(e);
        }
    }

    private void expireAndRemoveEventuallyAfterProcessing(Entry e) {
        if (this.isKeepAfterExpired()) {
            this.metrics.expiredKept();
        } else {
            this.removeEntry(e);
        }
    }

    public final ConcurrentEntryIterator<K, V> iterateAllHeapEntries() {
        return new ConcurrentEntryIterator(this);
    }

    @Override
    public Map<K, V> getAll(Iterable<? extends K> _inputKeys) {
        HashMap map = new HashMap();
        for (K k : _inputKeys) {
            Entry e = this.getEntryInternal(k);
            if (e == null) continue;
            map.put(this.extractKeyObj(e), ReadOnlyCacheEntry.of(e));
        }
        return this.convertValueMap(map);
    }

    public Map<K, V> convertValueMap(Map<K, ExaminationEntry<K, V>> _map) {
        return new MapValueConverterProxy<K, V, ExaminationEntry<K, V>>(_map){

            @Override
            protected V convert(ExaminationEntry<K, V> v) {
                return HeapCache.this.returnValue(v.getValueOrException());
            }
        };
    }

    public Map<K, V> convertCacheEntry2ValueMap(Map<K, CacheEntry<K, V>> _map) {
        return new MapValueConverterProxy<K, V, CacheEntry<K, V>>(_map){

            @Override
            protected V convert(CacheEntry<K, V> v) {
                return v.getValue();
            }
        };
    }

    @Override
    public Map<K, V> peekAll(Iterable<? extends K> _inputKeys) {
        HashMap<K, Entry<K, V>> map = new HashMap<K, Entry<K, V>>();
        for (K k : _inputKeys) {
            Entry<K, V> e = this.peekEntryInternal(k);
            if (e == null) continue;
            map.put(k, e);
        }
        return this.convertValueMap(map);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> valueMap) {
        for (Map.Entry<K, V> e : valueMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    Operations<K, V> spec() {
        return Operations.SINGLETON;
    }

    @Override
    protected <R> EntryAction<K, V, R> createEntryAction(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        return new EntryAction<K, V, R>(this, this, op, key, e){

            @Override
            protected TimingHandler<K, V> timing() {
                return HeapCache.this.timing;
            }
        };
    }

    @Override
    public <R> R invoke(K key, EntryProcessor<K, V, R> entryProcessor) {
        return this.execute(key, this.spec().invoke(key, this.loader != null, entryProcessor));
    }

    @Override
    public void expireAt(K key, long _millis) {
        this.execute(key, this.spec().expire(key, _millis));
    }

    public final long getLocalSize() {
        return this.hash.getSize();
    }

    @Override
    public final int getTotalEntryCount() {
        return this.executeWithGlobalLock(new Job<Integer>(){

            @Override
            public Integer call() {
                return (int)HeapCache.this.getLocalSize();
            }
        });
    }

    protected IntegrityState getIntegrityState() {
        EvictionMetrics em = this.eviction.getMetrics();
        IntegrityState is = new IntegrityState().checkEquals("hash.getSize() == hash.calcEntryCount()", this.hash.getSize(), this.hash.calcEntryCount());
        if (em.getEvictionRunningCount() > 0) {
            is.check("eviction running: hash.getSize() == eviction.getSize()", true).check("eviction running: newEntryCnt == hash.getSize() + evictedCnt ....", true);
        } else {
            is.checkEquals("hash.getSize() == eviction.getSize()", this.getLocalSize(), em.getSize()).checkEquals("newEntryCnt == hash.getSize() + evictedCnt + expiredRemoveCnt + removeCnt + clearedCnt + virginRemovedCnt", em.getNewEntryCount(), this.getLocalSize() + em.getEvictedCount() + em.getExpiredRemovedCount() + em.getRemovedCount() + this.clearRemovedCnt + em.getVirginRemovedCount());
        }
        this.eviction.checkIntegrity(is);
        return is;
    }

    @Override
    public final void checkIntegrity() {
        this.executeWithGlobalLock(new Job<Void>(){

            @Override
            public Void call() {
                IntegrityState is = HeapCache.this.getIntegrityState();
                if (is.getStateFlags() > 0L) {
                    throw new Error("cache2k integrity error: " + is.getStateDescriptor() + ", " + is.getFailingChecks() + ", " + HeapCache.this.generateInfoUnderLock(HeapCache.this, HeapCache.this.clock.millis()).toString());
                }
                return null;
            }
        });
    }

    @Override
    public final InternalCacheInfo getInfo() {
        return this.getInfo(this);
    }

    @Override
    public final InternalCacheInfo getLatestInfo() {
        return this.getLatestInfo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InternalCacheInfo getInfo(InternalCache _userCache) {
        Object object = this.lock;
        synchronized (object) {
            long t = this.clock.millis();
            if (this.info != null && this.info.getInfoCreatedTime() + (long)(this.info.getInfoCreationDeltaMs() * HeapCache.TUNABLE.minimumStatisticsCreationTimeDeltaFactor) + (long)HeapCache.TUNABLE.minimumStatisticsCreationDeltaMillis > t) {
                return this.info;
            }
            this.info = this.generateInfo(_userCache, t);
        }
        return this.info;
    }

    public final InternalCacheInfo getLatestInfo(InternalCache _userCache) {
        return this.generateInfo(_userCache, this.clock.millis());
    }

    private CacheBaseInfo generateInfo(final InternalCache _userCache, final long t) {
        return this.executeWithGlobalLock(new Job<CacheBaseInfo>(){

            @Override
            public CacheBaseInfo call() {
                return HeapCache.this.generateInfoUnderLock(_userCache, t);
            }
        });
    }

    private CacheBaseInfo generateInfoUnderLock(InternalCache _userCache, long t) {
        this.info = new CacheBaseInfo(this, _userCache, t);
        this.info.setInfoCreationDeltaMs((int)(this.clock.millis() - t));
        return this.info;
    }

    @Override
    public CommonMetrics getCommonMetrics() {
        return this.metrics;
    }

    public <T> T executeWithGlobalLock(Job<T> job) {
        return this.executeWithGlobalLock(job, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeWithGlobalLock(final Job<T> job, final boolean _checkClosed) {
        Object object = this.lock;
        synchronized (object) {
            if (_checkClosed) {
                this.checkClosed();
            }
            this.eviction.stop();
            Object _result = this.hash.runTotalLocked(new Job<T>(){

                @Override
                public T call() {
                    boolean f;
                    if (_checkClosed) {
                        HeapCache.this.checkClosed();
                    }
                    if (f = HeapCache.this.eviction.drain()) {
                        return RESTART_AFTER_EVICTION;
                    }
                    return HeapCache.this.eviction.runLocked(new Job<T>(){

                        @Override
                        public T call() {
                            return job.call();
                        }
                    });
                }
            });
            if (_result == RESTART_AFTER_EVICTION) {
                this.eviction.evictEventually();
                _result = this.hash.runTotalLocked(new Job<T>(){

                    @Override
                    public T call() {
                        if (_checkClosed) {
                            HeapCache.this.checkClosed();
                        }
                        HeapCache.this.eviction.drain();
                        return HeapCache.this.eviction.runLocked(new Job<T>(){

                            @Override
                            public T call() {
                                return job.call();
                            }
                        });
                    }
                });
            }
            Object t = _result;
            return t;
            finally {
                this.eviction.start();
            }
        }
    }

    @Override
    public final InternalClock getClock() {
        return this.clock;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.manager;
    }

    public int modifiedHash(int h) {
        h ^= this.hashSeed;
        h ^= h >>> 7;
        h ^= h >>> 15;
        return h;
    }

    public int extractIntKeyValue(K key, int hc) {
        return hc;
    }

    public K extractIntKeyObj(K key) {
        return key;
    }

    public int extractModifiedHash(Entry e) {
        return e.hashCode;
    }

    public K extractKeyObj(Entry<K, V> e) {
        return (K)e.getKeyObj();
    }

    public Hash2<K, V> createHashTable() {
        return new Hash2(this);
    }

    public static class Tunable
    extends TunableConstants {
        public int initialHashSize = 64;
        public int hashLoadPercent = 64;
        public boolean disableHashRandomization = false;
        public int hashSeed = 0;
        public long sharpExpirySafetyGapMillis = 27127L;
        public int minimumStatisticsCreationDeltaMillis = 333;
        public int minimumStatisticsCreationTimeDeltaFactor = 123;
        public ThreadFactoryProvider threadFactoryProvider = new DefaultThreadFactoryProvider();
        public int loaderThreadCountCpuFactor = 1;
        public StandardCommonMetricsFactory commonMetricsFactory = new StandardCommonMetricsFactory();
        public ExceptionPropagator exceptionPropagator = new StandardExceptionPropagator();
        public int hashQualityWarningThreshold = 20;
        public int hashQualityErrorThreshold = 5;
        public int segmentCountOverride = 0;
    }

    public static abstract class RunWithCatch
    implements Runnable {
        InternalCache cache;

        public RunWithCatch(InternalCache _cache) {
            this.cache = _cache;
        }

        protected abstract void action();

        @Override
        public final void run() {
            if (this.cache.isClosed()) {
                return;
            }
            try {
                this.action();
            }
            catch (CacheClosedException cacheClosedException) {
            }
            catch (Throwable t) {
                this.cache.logAndCountInternalException("Loader thread exception (" + Thread.currentThread().getName() + ")", t);
            }
        }
    }

    static abstract class BaseCacheEntry<K, V>
    extends AbstractCacheEntry<K, V> {
        BaseCacheEntry() {
        }

        @Override
        public Throwable getException() {
            return null;
        }

        public String toString() {
            return "CacheEntry(key=" + this.getKey() + (this.getException() != null ? ", exception=" + this.getException() + ", " : ", value=" + this.getValue());
        }
    }

    static class IteratorFilterEntry2Entry<K, V>
    implements Iterator<CacheEntry<K, V>> {
        HeapCache<K, V> cache;
        Iterator<Entry<K, V>> iterator;
        Entry entry;
        CacheEntry<K, V> lastEntry;
        boolean filter;

        IteratorFilterEntry2Entry(HeapCache<K, V> c, Iterator<Entry<K, V>> it, boolean _filter) {
            this.cache = c;
            this.iterator = it;
            this.filter = _filter;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            if (this.iterator == null) {
                return false;
            }
            while (this.iterator.hasNext()) {
                Entry<K, V> e = this.iterator.next();
                if (this.filter) {
                    if (!e.hasFreshData(this.cache.getClock())) continue;
                    this.entry = e;
                    return true;
                }
                this.entry = e;
                return true;
            }
            this.entry = null;
            return false;
        }

        @Override
        public CacheEntry<K, V> next() {
            if (this.entry == null && !this.hasNext()) {
                throw new NoSuchElementException("not available");
            }
            this.lastEntry = this.cache.returnEntry(this.entry);
            this.entry = null;
            return this.lastEntry;
        }

        @Override
        public void remove() {
            if (this.lastEntry == null) {
                throw new IllegalStateException("Unable to remove, hasNext() / next() not called or end of iteration reached");
            }
            this.cache.remove(this.lastEntry.getKey());
        }
    }

    private class LazyPrefetchExecutor
    implements Executor {
        private LazyPrefetchExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable _command) {
            Object object = HeapCache.this.lock;
            synchronized (object) {
                HeapCache.this.checkClosed();
                HeapCache.this.loaderExecutor.execute(_command);
                HeapCache.this.prefetchExecutor = HeapCache.this.loaderExecutor;
            }
        }
    }

    private class LazyLoaderExecutor
    implements Executor {
        private LazyLoaderExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable _command) {
            Object object = HeapCache.this.lock;
            synchronized (object) {
                HeapCache.this.checkClosed();
                if (HeapCache.this.loaderExecutor == this) {
                    int _threadCount = Runtime.getRuntime().availableProcessors() * HeapCache.TUNABLE.loaderThreadCountCpuFactor;
                    HeapCache.this.loaderExecutor = HeapCache.this.provideDefaultLoaderExecutor(_threadCount);
                }
                HeapCache.this.loaderExecutor.execute(_command);
            }
        }
    }
}

