/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.fault;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.fault.DetailType;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.fault.ServerSOAPFaultException;
import com.sun.xml.ws.util.DOMUtil;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.soap.Detail;
import jakarta.xml.soap.DetailEntry;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.WebServiceException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"faultcode", "faultstring", "faultactor", "detail"})
@XmlRootElement(name="Fault", namespace="http://schemas.xmlsoap.org/soap/envelope/")
class SOAP11Fault
extends SOAPFaultBuilder {
    @XmlElement(namespace="")
    private QName faultcode;
    @XmlElement(namespace="")
    private String faultstring;
    @XmlElement(namespace="")
    private String faultactor;
    @XmlElement(namespace="")
    private DetailType detail;

    SOAP11Fault() {
    }

    SOAP11Fault(QName code, String reason, String actor, Element detailObject) {
        this.faultcode = code;
        this.faultstring = SOAP11Fault.createFaultString(reason);
        this.faultactor = actor;
        if (detailObject != null) {
            if ((detailObject.getNamespaceURI() == null || "".equals(detailObject.getNamespaceURI())) && "detail".equals(detailObject.getLocalName())) {
                this.detail = new DetailType();
                for (Element detailEntry : DOMUtil.getChildElements(detailObject)) {
                    this.detail.getDetails().add(detailEntry);
                }
            } else {
                this.detail = new DetailType(detailObject);
            }
        }
    }

    SOAP11Fault(SOAPFault fault) {
        this.faultcode = fault.getFaultCodeAsQName();
        this.faultstring = SOAP11Fault.createFaultString(fault.getFaultString());
        this.faultactor = fault.getFaultActor();
        if (fault.getDetail() != null) {
            this.detail = new DetailType();
            Iterator<DetailEntry> iter = fault.getDetail().getDetailEntries();
            while (iter.hasNext()) {
                Element fd = iter.next();
                this.detail.getDetails().add(fd);
            }
        }
    }

    QName getFaultcode() {
        return this.faultcode;
    }

    void setFaultcode(QName faultcode) {
        this.faultcode = faultcode;
    }

    @Override
    String getFaultString() {
        return this.faultstring;
    }

    void setFaultstring(String faultstring) {
        this.faultstring = faultstring;
    }

    String getFaultactor() {
        return this.faultactor;
    }

    void setFaultactor(String faultactor) {
        this.faultactor = faultactor;
    }

    @Override
    DetailType getDetail() {
        return this.detail;
    }

    @Override
    void setDetail(DetailType detail) {
        this.detail = detail;
    }

    @Override
    protected Throwable getProtocolException() {
        try {
            SOAPFault fault = SOAPVersion.SOAP_11.getSOAPFactory().createFault(this.faultstring, this.faultcode);
            fault.setFaultActor(this.faultactor);
            if (this.detail != null) {
                Detail d = fault.addDetail();
                for (Element det : this.detail.getDetails()) {
                    Node n = fault.getOwnerDocument().importNode(det, true);
                    d.appendChild(n);
                }
            }
            return new ServerSOAPFaultException(fault);
        }
        catch (SOAPException e) {
            throw new WebServiceException(e);
        }
    }
}

