/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.ArrayList;
import java.util.List;

public class IntegrityState {
    List<String> failingTests = new ArrayList<String>();
    long state = 0L;
    long bitNr = 0L;
    int stringsHashCode = 0;
    String groupPrefix = "";

    IntegrityState check(boolean f) {
        this.check(null, f);
        return this;
    }

    protected IntegrityState check(String _check, String _note, boolean f) {
        if (_check == null || _check.length() == 0) {
            _check = "test#" + this.bitNr;
        }
        this.stringsHashCode = this.stringsHashCode * 31 + _check.hashCode();
        if (!f) {
            if (_note != null) {
                this.failingTests.add(this.groupPrefix + '\"' + _check + "\" => " + _note);
            } else {
                this.failingTests.add(this.groupPrefix + '\"' + _check + '\"');
            }
            this.state |= (long)(1 << (int)this.bitNr);
        }
        ++this.bitNr;
        return this;
    }

    public IntegrityState group(String _group) {
        this.groupPrefix = _group + ": ";
        return this;
    }

    public IntegrityState check(String _check, boolean f) {
        this.check(_check, null, f);
        return this;
    }

    public IntegrityState checkEquals(String _check, int v1, int v2) {
        if (v1 == v2) {
            this.check(_check, null, true);
        } else {
            this.check(_check, v1 + "==" + v2, false);
        }
        return this;
    }

    public IntegrityState checkEquals(String _check, long v1, long v2) {
        if (v1 == v2) {
            this.check(_check, null, true);
        } else {
            this.check(_check, v1 + "==" + v2, false);
        }
        return this;
    }

    public IntegrityState checkLessOrEquals(String _check, int v1, int v2) {
        if (v1 <= v2) {
            this.check(_check, null, true);
        } else {
            this.check(_check, v1 + "<=" + v2, false);
        }
        return this;
    }

    public IntegrityState checkLess(String _check, int v1, int v2) {
        if (v1 < v2) {
            this.check(_check, null, true);
        } else {
            this.check(_check, v1 + "<" + v2, false);
        }
        return this;
    }

    public IntegrityState checkGreaterOrEquals(String _check, int v1, int v2) {
        if (v1 >= v2) {
            this.check(_check, null, true);
        } else {
            this.check(_check, v1 + ">=" + v2, false);
        }
        return this;
    }

    public IntegrityState checkGreater(String _check, int v1, int v2) {
        if (v1 > v2) {
            this.check(_check, null, true);
        } else {
            this.check(_check, v1 + ">" + v2, false);
        }
        return this;
    }

    public String getStateDescriptor() {
        return Long.toHexString(this.state) + '.' + this.bitNr + '.' + Integer.toHexString(this.stringsHashCode);
    }

    public long getStateFlags() {
        return this.state;
    }

    public String getFailingChecks() {
        return this.failingTests.toString();
    }

    public void throwIfNeeded() {
        if (this.state > 0L) {
            throw new IllegalStateException("Integrity test failed: " + this.failingTests.toString());
        }
    }
}

