/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.response.inbound;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxhttp.util.ContentUtils;
import org.gcube.common.gxrest.response.entity.SerializableErrorEntity;
import org.gcube.common.gxrest.response.inbound.ErrorCodeDeserializer;
import org.gcube.common.gxrest.response.inbound.ExceptionDeserializer;
import org.gcube.common.gxrest.response.inbound.JsonUtils;
import org.gcube.common.gxrest.response.outbound.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXInboundResponse {
    private SerializableErrorEntity entity;
    private final int responseCode;
    private String contentType = "";
    private String message = "";
    private String body = "";
    private byte[] streamedContent;
    private Map<String, List<String>> headerFields;
    private static final Logger logger = LoggerFactory.getLogger(GXInboundResponse.class);
    private boolean hasGXError = false;
    private Response source;
    private HttpURLConnection connection;
    private boolean contentAlreadyConsumed = false;
    private boolean fromConnection = false;
    private boolean fromResponse = false;

    public GXInboundResponse(Response source) {
        this.fromResponse = true;
        this.source = source;
        this.responseCode = source.getStatusInfo().getStatusCode();
        this.message = source.getStatusInfo().getReasonPhrase();
        this.headerFields = source.getStringHeaders();
        if (Objects.nonNull(source.getMediaType())) {
            this.contentType = source.getMediaType().getType();
        }
        try {
            if (Objects.nonNull(source.getEntityTag()) && source.getEntityTag().getValue().equals("GXErrorResponse")) {
                this.entity = source.readEntity(SerializableErrorEntity.class);
                this.hasGXError = true;
                this.contentAlreadyConsumed = true;
            }
        }
        catch (ProcessingException | IllegalStateException runtimeException) {
            // empty catch block
        }
    }

    public GXInboundResponse(HttpURLConnection connection) throws IOException {
        this.fromConnection = true;
        this.connection = connection;
        this.responseCode = connection.getResponseCode();
        this.message = connection.getResponseMessage();
        this.headerFields = connection.getHeaderFields();
        this.contentType = connection.getContentType();
        String eTag = connection.getHeaderField("ETag");
        if (Objects.nonNull(eTag) && eTag.replaceAll("^\"|\"$", "").equals("GXErrorResponse")) {
            logger.debug("GXErrorResponse detected.");
            this.hasGXError = true;
            try {
                this.streamedContent = ContentUtils.toByteArray(connection.getErrorStream());
                this.contentAlreadyConsumed = true;
                this.body = ContentUtils.toString(this.streamedContent);
                this.entity = JsonUtils.fromJson(this.body, SerializableErrorEntity.class);
                logger.trace("Response's content: " + this.body);
            }
            catch (Exception ioe) {
                logger.warn("No data are available in the response.");
            }
        } else {
            try {
                if (this.contentType.equals("text/plain") || this.contentType.equals("application/json")) {
                    this.body = ContentUtils.toString(ContentUtils.toByteArray(this.getInputStream()));
                    logger.trace("Response's content: " + this.body);
                    this.contentAlreadyConsumed = true;
                }
            }
            catch (Exception ioe) {
                logger.warn("No data are available in the response.", ioe);
            }
        }
    }

    public GXInboundResponse(Response response, MediaType[] expectedMediaTypes) {
        this(response);
        if (Objects.isNull(expectedMediaTypes) || expectedMediaTypes.length == 0) {
            throw new IllegalArgumentException("No expected type was set)");
        }
        boolean compatible = false;
        for (MediaType media : expectedMediaTypes) {
            if (!Objects.nonNull(response.getMediaType()) || !response.getMediaType().isCompatible(media)) continue;
            compatible = true;
        }
        if (!compatible) {
            throw new IllegalArgumentException("Received MediaType is not compatible with the expected type(s)");
        }
    }

    public boolean hasException() {
        return Objects.nonNull(this.entity) && Objects.nonNull(this.entity.getExceptionClass());
    }

    public boolean isErrorResponse() {
        return this.getHTTPCode() >= 400 && this.getHTTPCode() < 600;
    }

    public boolean isSuccessResponse() {
        return this.getHTTPCode() >= 200 && this.getHTTPCode() < 300;
    }

    public boolean hasGXError() {
        return this.hasGXError;
    }

    public <E extends Exception> E getException() throws ClassNotFoundException {
        if (Objects.nonNull(this.entity)) {
            Object e = ExceptionDeserializer.deserialize(this.entity.getExceptionClass(), this.entity.getMessage());
            if (Objects.nonNull(e)) {
                if (this.entity.hasStackTrace()) {
                    ExceptionDeserializer.addStackTrace(e, this.entity.getEncodedTrace());
                } else {
                    ((Throwable)e).setStackTrace(new StackTraceElement[0]);
                }
                return e;
            }
            throw new ClassNotFoundException("Failed to deserialize: " + this.entity.getExceptionClass() + ". Not on the classpath?");
        }
        return null;
    }

    public boolean hasErrorCode() {
        if (Objects.nonNull(this.entity)) {
            return this.entity.getId() != -1;
        }
        return false;
    }

    public ErrorCode getErrorCode() {
        if (Objects.nonNull(this.entity)) {
            return ErrorCodeDeserializer.deserialize(this.entity.getId(), this.entity.getMessage());
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStreamedContentAsString() throws IOException {
        if (this.body.isEmpty()) {
            this.body = ContentUtils.toString(ContentUtils.toByteArray(this.getInputStream()));
        }
        return this.body;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.contentAlreadyConsumed) {
            if (this.fromConnection) {
                this.contentAlreadyConsumed = true;
                return this.isSuccessResponse() ? this.connection.getInputStream() : this.connection.getErrorStream();
            }
            if (this.fromResponse) {
                this.contentAlreadyConsumed = true;
                return (InputStream)this.source.getEntity();
            }
            return null;
        }
        throw new IOException("Content Already Consumed");
    }

    public byte[] getStreamedContent() throws IOException {
        this.streamedContent = !this.body.isEmpty() ? this.body.getBytes() : ContentUtils.toByteArray(this.getInputStream());
        return this.streamedContent;
    }

    public <T> T tryConvertStreamedContentFromJson(Class<T> raw) throws Exception {
        return JsonUtils.fromJson(this.getStreamedContentAsString(), raw);
    }

    public int getHTTPCode() {
        return this.responseCode;
    }

    public boolean hasCREATEDCode() {
        return this.getHTTPCode() == Response.Status.CREATED.getStatusCode();
    }

    public boolean hasOKCode() {
        return this.getHTTPCode() == Response.Status.OK.getStatusCode();
    }

    public boolean hasNOT_ACCEPTABLECode() {
        return this.getHTTPCode() == Response.Status.NOT_ACCEPTABLE.getStatusCode();
    }

    public boolean hasBAD_REQUESTCode() {
        return this.getHTTPCode() == Response.Status.BAD_REQUEST.getStatusCode();
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    public Response getSource() throws UnsupportedOperationException {
        if (Objects.isNull(this.source)) {
            new UnsupportedOperationException();
        }
        return this.source;
    }
}

