/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak;

import org.gcube.common.keycloak.DefaultKeycloakClient;
import org.gcube.common.keycloak.KeycloakClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakClientFactory {
    protected static final Logger logger = LoggerFactory.getLogger(KeycloakClientFactory.class);
    protected static String CUSTOM_BASE_URL;

    public static void setCustomBaseURL(String customBaseURL) {
        if (customBaseURL != null) {
            logger.info("Setting custom base URL static value to {}", (Object)customBaseURL);
        } else {
            logger.info("Removing custom base URL static value");
        }
        CUSTOM_BASE_URL = customBaseURL == null || customBaseURL.endsWith("/") ? customBaseURL : (customBaseURL = customBaseURL + "/");
    }

    public static String getCustomBaseURL() {
        return CUSTOM_BASE_URL;
    }

    public static KeycloakClient newInstance() {
        logger.debug("Instantiating a new keycloak client instance");
        DefaultKeycloakClient newInstance = new DefaultKeycloakClient();
        if (KeycloakClientFactory.getCustomBaseURL() != null) {
            newInstance.setCustomBaseURL(CUSTOM_BASE_URL);
        }
        return newInstance;
    }
}

