/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import java.net.URL;
import java.util.List;
import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.service.Version;

public class FileContainer
extends ItemContainer<AbstractFileItem> {
    protected FileContainer(ItemManagerClient itemclient, AbstractFileItem item) {
        super(itemclient, item);
    }

    protected FileContainer(ItemManagerClient itemclient, String fileId) {
        super(itemclient, fileId);
    }

    @Override
    public ContainerType getType() {
        return ContainerType.FILE;
    }

    public URL getPublicLink() throws StorageHubException {
        return this.itemclient.getPublickLink(this.itemId);
    }

    public URL getPublicLink(String version) throws StorageHubException {
        return this.itemclient.getPublickLink(this.itemId, version);
    }

    public List<Version> getVersions() throws StorageHubException {
        return this.itemclient.getFileVersions(this.itemId);
    }

    public StreamDescriptor downloadSpecificVersion(String versionName) throws StorageHubException {
        return this.itemclient.downloadSpecificVersion(this.itemId, versionName);
    }

    public FileContainer deleteVersion(String version) throws StorageHubException {
        this.itemclient.deleteFileVersion(this.itemId, version);
        return this;
    }

    public FileContainer copy(FolderContainer folder, String newFileName) throws StorageHubException {
        return new FileContainer(this.itemclient, this.itemclient.copy(this.itemId, ((FolderItem)folder.get()).getId(), newFileName));
    }
}

