/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.gcube.io.jsonwebtoken.JweHeader;
import org.gcube.io.jsonwebtoken.impl.DefaultJweHeader;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.ParameterReadable;
import org.gcube.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import org.gcube.io.jsonwebtoken.impl.security.AesAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DefaultKeyResult;
import org.gcube.io.jsonwebtoken.io.Encoders;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.DecryptionKeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyResult;
import org.gcube.io.jsonwebtoken.security.SecretKeyAlgorithm;
import org.gcube.io.jsonwebtoken.security.SecurityException;

public class AesGcmKeyAlgorithm
extends AesAlgorithm
implements SecretKeyAlgorithm {
    public static final String TRANSFORMATION = "AES/GCM/NoPadding";

    public AesGcmKeyAlgorithm(int keyLen) {
        super("A" + keyLen + "GCMKW", TRANSFORMATION, keyLen);
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        JweHeader header = Assert.notNull(request.getHeader(), "Request JweHeader cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getPayload());
        final SecretKey cek = this.generateCek(request);
        byte[] iv = this.ensureInitializationVector(request);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        byte[] taggedCiphertext = this.jca(request).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                cipher.init(3, (Key)kek, ivSpec);
                return cipher.wrap(cek);
            }
        });
        int tagByteLength = this.tagBitLength / 8;
        int ciphertextLength = taggedCiphertext.length - tagByteLength;
        byte[] ciphertext = new byte[ciphertextLength];
        System.arraycopy(taggedCiphertext, 0, ciphertext, 0, ciphertextLength);
        byte[] tag = new byte[tagByteLength];
        System.arraycopy(taggedCiphertext, ciphertextLength, tag, 0, tagByteLength);
        String encodedIv = Encoders.BASE64URL.encode(iv);
        String encodedTag = Encoders.BASE64URL.encode(tag);
        header.put(DefaultJweHeader.IV.getId(), encodedIv);
        header.put(DefaultJweHeader.TAG.getId(), encodedTag);
        return new DefaultKeyResult(cek, ciphertext);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getKey());
        byte[] cekBytes = Assert.notEmpty((byte[])request.getPayload(), "Decryption request content (ciphertext) cannot be null or empty.");
        JweHeader header = Assert.notNull(request.getHeader(), "Request JweHeader cannot be null.");
        ParameterReadable frHeader = Assert.isInstanceOf(ParameterReadable.class, header, "Header must implement ParameterReadable.");
        RequiredParameterReader reader = new RequiredParameterReader(frHeader);
        byte[] tag = reader.get(DefaultJweHeader.TAG);
        byte[] iv = reader.get(DefaultJweHeader.IV);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        final byte[] taggedCiphertext = Bytes.concat(cekBytes, tag);
        return this.jca(request).withCipher(new CheckedFunction<Cipher, SecretKey>(){

            @Override
            public SecretKey apply(Cipher cipher) throws Exception {
                cipher.init(4, (Key)kek, ivSpec);
                Key key = cipher.unwrap(taggedCiphertext, "AES", 3);
                Assert.state(key instanceof SecretKey, "cipher.unwrap must produce a SecretKey instance.");
                return (SecretKey)key;
            }
        });
    }
}

