/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.io;

import java.io.Reader;
import java.util.Map;
import org.gcube.io.jsonwebtoken.MalformedJwtException;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.io.DeserializationException;
import org.gcube.io.jsonwebtoken.io.Deserializer;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class JsonObjectDeserializer
implements Function<Reader, Map<String, ?>> {
    private static final String MALFORMED_ERROR = "Malformed %s JSON: %s";
    private static final String MALFORMED_COMPLEX_ERROR = "Malformed or excessively complex %s JSON. If experienced in a production environment, this could reflect a potential malicious %s, please investigate the source further. Cause: %s";
    private final Deserializer<?> deserializer;
    private final String name;

    public JsonObjectDeserializer(Deserializer<?> deserializer, String name) {
        this.deserializer = Assert.notNull(deserializer, "JSON Deserializer cannot be null.");
        this.name = Assert.hasText(name, "name cannot be null or empty.");
    }

    @Override
    public Map<String, ?> apply(Reader in) {
        Assert.notNull(in, "InputStream argument cannot be null.");
        try {
            Object value = this.deserializer.deserialize(in);
            if (value == null) {
                String msg = "Deserialized data resulted in a null value; cannot create Map<String,?>";
                throw new DeserializationException(msg);
            }
            if (!(value instanceof Map)) {
                String msg = "Deserialized data is not a JSON Object; cannot create Map<String,?>";
                throw new DeserializationException(msg);
            }
            return (Map)value;
        }
        catch (StackOverflowError e) {
            String msg = String.format(MALFORMED_COMPLEX_ERROR, this.name, this.name, e.getMessage());
            throw new DeserializationException(msg, e);
        }
        catch (Throwable t) {
            throw this.malformed(t);
        }
    }

    protected RuntimeException malformed(Throwable t) {
        String msg = String.format(MALFORMED_ERROR, this.name, t.getMessage());
        throw new MalformedJwtException(msg, t);
    }
}

