/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.Converters;
import org.gcube.io.jsonwebtoken.impl.lang.DefaultParameterBuilder;
import org.gcube.io.jsonwebtoken.impl.lang.IdRegistry;
import org.gcube.io.jsonwebtoken.impl.lang.JwtDateConverter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.ParameterBuilder;
import org.gcube.io.jsonwebtoken.impl.lang.ParameterReadable;
import org.gcube.io.jsonwebtoken.lang.Arrays;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Objects;
import org.gcube.io.jsonwebtoken.lang.Registry;

public final class Parameters {
    private Parameters() {
    }

    public static Parameter<String> string(String id, String name) {
        return (Parameter)Parameters.builder(String.class).setId(id).setName(name).build();
    }

    public static Parameter<Date> rfcDate(String id, String name) {
        return (Parameter)Parameters.builder(Date.class).setConverter(JwtDateConverter.INSTANCE).setId(id).setName(name).build();
    }

    public static Parameter<List<X509Certificate>> x509Chain(String id, String name) {
        return (Parameter)Parameters.builder(X509Certificate.class).setConverter(Converters.X509_CERTIFICATE).list().setId(id).setName(name).build();
    }

    public static <T> ParameterBuilder<T> builder(Class<T> type) {
        return new DefaultParameterBuilder<T>(type);
    }

    public static Parameter<Set<String>> stringSet(String id, String name) {
        return (Parameter)Parameters.builder(String.class).set().setId(id).setName(name).build();
    }

    public static Parameter<URI> uri(String id, String name) {
        return (Parameter)Parameters.builder(URI.class).setConverter(Converters.URI).setId(id).setName(name).build();
    }

    public static ParameterBuilder<byte[]> bytes(String id, String name) {
        return Parameters.builder(byte[].class).setConverter(Converters.BASE64URL_BYTES).setId(id).setName(name);
    }

    public static ParameterBuilder<BigInteger> bigInt(String id, String name) {
        return Parameters.builder(BigInteger.class).setConverter(Converters.BIGINT).setId(id).setName(name);
    }

    public static Parameter<BigInteger> secretBigInt(String id, String name) {
        return (Parameter)Parameters.bigInt(id, name).setSecret(true).build();
    }

    public static Registry<String, Parameter<?>> registry(Parameter<?> ... params) {
        return Parameters.registry(Arrays.asList(params));
    }

    public static Registry<String, Parameter<?>> registry(Collection<Parameter<?>> params) {
        return new IdRegistry("Parameter", params, true);
    }

    public static Registry<String, Parameter<?>> registry(Registry<String, Parameter<?>> parent, Parameter<?> ... params) {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(parent.size() + params.length);
        set.addAll(parent.values());
        set.addAll(Arrays.asList(params));
        return new IdRegistry("Parameter", set, true);
    }

    public static Registry<String, ? extends Parameter<?>> replace(Registry<String, ? extends Parameter<?>> registry, Parameter<?> param) {
        Assert.notEmpty(registry, "Registry cannot be null or empty.");
        Assert.notNull(param, "Parameter cannot be null.");
        String id = Assert.hasText(param.getId(), "Parameter id cannot be null or empty.");
        LinkedHashMap newParams = new LinkedHashMap(registry);
        newParams.remove(id);
        newParams.put(id, param);
        return Parameters.registry(newParams.values());
    }

    private static byte[] bytes(BigInteger i) {
        return i != null ? i.toByteArray() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bytesEquals(BigInteger a, BigInteger b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        byte[] aBytes = Parameters.bytes(a);
        byte[] bBytes = Parameters.bytes(b);
        try {
            boolean bl = MessageDigest.isEqual(aBytes, bBytes);
            return bl;
        }
        finally {
            Bytes.clear(aBytes);
            Bytes.clear(bBytes);
        }
    }

    private static <T> boolean equals(T a, T b, Parameter<T> param) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (param.isSecret()) {
            if (a instanceof byte[]) {
                return b instanceof byte[] && MessageDigest.isEqual((byte[])a, (byte[])b);
            }
            if (a instanceof BigInteger) {
                return b instanceof BigInteger && Parameters.bytesEquals((BigInteger)a, (BigInteger)b);
            }
        }
        return Objects.nullSafeEquals(a, b);
    }

    public static <T> boolean equals(ParameterReadable a, Object o, Parameter<T> param) {
        if (a == o) {
            return true;
        }
        if (a == null || !(o instanceof ParameterReadable)) {
            return false;
        }
        ParameterReadable b = (ParameterReadable)o;
        return Parameters.equals(a.get(param), b.get(param), param);
    }
}

