/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.impl.lang.RedactedSupplier;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Supplier;

public class RedactedValueConverter<T>
implements Converter<T, Object> {
    private final Converter<T, Object> delegate;

    public RedactedValueConverter(Converter<T, Object> delegate) {
        this.delegate = Assert.notNull(delegate, "Delegate cannot be null.");
    }

    @Override
    public Object applyTo(T t) {
        RedactedSupplier<Object> value = this.delegate.applyTo(t);
        if (value != null && !(value instanceof RedactedSupplier)) {
            value = new RedactedSupplier<Object>(value);
        }
        return value;
    }

    @Override
    public T applyFrom(Object o) {
        if (o instanceof RedactedSupplier) {
            o = ((Supplier)o).get();
        }
        return this.delegate.applyFrom(o);
    }
}

