/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.gcube.io.jsonwebtoken.impl.lang.DefaultRegistry;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.impl.lang.Functions;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.lang.Strings;

public class StringRegistry<V>
extends DefaultRegistry<String, V> {
    private final Function<String, String> CASE_FN;
    private final Map<String, V> CI_VALUES;

    public StringRegistry(String name, String keyName, Collection<V> values, Function<V, String> keyFn, boolean caseSensitive) {
        this(name, keyName, values, keyFn, caseSensitive ? Functions.identity() : CaseInsensitiveFunction.ENGLISH);
    }

    public StringRegistry(String name, String keyName, Collection<V> values, Function<V, String> keyFn, Function<String, String> caseFn) {
        super(name, keyName, values, keyFn);
        this.CASE_FN = Assert.notNull(caseFn, "Case function cannot be null.");
        LinkedHashMap<String, V> m = new LinkedHashMap<String, V>(this.values().size());
        for (V value : values) {
            String key = keyFn.apply(value);
            key = this.CASE_FN.apply(key);
            m.put(key, value);
        }
        this.CI_VALUES = Collections.immutable(m);
    }

    @Override
    public V get(Object key) {
        String id = (String)key;
        Assert.hasText(id, "id argument cannot be null or empty.");
        Object instance = super.get(id);
        if (instance == null) {
            id = this.CASE_FN.apply(id);
            instance = this.CI_VALUES.get(id);
        }
        return instance;
    }

    private static final class CaseInsensitiveFunction
    implements Function<String, String> {
        private static final CaseInsensitiveFunction ENGLISH = new CaseInsensitiveFunction(Locale.ENGLISH);
        private final Locale LOCALE;

        private CaseInsensitiveFunction(Locale locale) {
            this.LOCALE = Assert.notNull(locale, "Case insensitive Locale argument cannot be null.");
        }

        @Override
        public String apply(String s) {
            s = Assert.notNull(Strings.clean(s), "String identifier cannot be null or empty.");
            return s.toUpperCase(this.LOCALE);
        }
    }
}

