/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.io.InputStream;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import org.gcube.io.jsonwebtoken.impl.ParameterMap;
import org.gcube.io.jsonwebtoken.impl.io.Streams;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.impl.lang.Functions;
import org.gcube.io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import org.gcube.io.jsonwebtoken.impl.security.DefaultHashAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DefaultRequest;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.lang.Objects;
import org.gcube.io.jsonwebtoken.security.HashAlgorithm;
import org.gcube.io.jsonwebtoken.security.Jwks;
import org.gcube.io.jsonwebtoken.security.X509Builder;

public class X509BuilderSupport
implements X509Builder<X509BuilderSupport> {
    private final ParameterMap map;
    protected boolean computeX509Sha1Thumbprint;
    protected Boolean computeX509Sha256Thumbprint = null;
    private final Function<X509Certificate, byte[]> GET_X509_BYTES;

    private static Function<X509Certificate, byte[]> createGetBytesFunction(Class<? extends RuntimeException> clazz) {
        return Functions.wrapFmt(new CheckedFunction<X509Certificate, byte[]>(){

            @Override
            public byte[] apply(X509Certificate cert) throws Exception {
                return cert.getEncoded();
            }
        }, clazz, "Unable to access X509Certificate encoded bytes necessary to compute thumbprint. Certificate: %s");
    }

    public X509BuilderSupport(ParameterMap map, Class<? extends RuntimeException> getBytesFailedException) {
        this.map = Assert.notNull(map, "ParameterMap cannot be null.");
        this.GET_X509_BYTES = X509BuilderSupport.createGetBytesFunction(getBytesFailedException);
    }

    @Override
    public X509BuilderSupport x509Url(URI uri) {
        this.map.put(AbstractAsymmetricJwk.X5U.getId(), (Object)uri);
        return this;
    }

    @Override
    public X509BuilderSupport x509Chain(List<X509Certificate> chain) {
        this.map.put(AbstractAsymmetricJwk.X5C.getId(), (Object)chain);
        return this;
    }

    @Override
    public X509BuilderSupport x509Sha1Thumbprint(byte[] thumbprint) {
        this.map.put(AbstractAsymmetricJwk.X5T.getId(), (Object)thumbprint);
        return this;
    }

    @Override
    public X509BuilderSupport x509Sha1Thumbprint(boolean enable) {
        this.computeX509Sha1Thumbprint = enable;
        return this;
    }

    @Override
    public X509BuilderSupport x509Sha256Thumbprint(byte[] thumbprint) {
        this.map.put(AbstractAsymmetricJwk.X5T_S256.getId(), (Object)thumbprint);
        return this;
    }

    @Override
    public X509BuilderSupport x509Sha256Thumbprint(boolean enable) {
        this.computeX509Sha256Thumbprint = enable;
        return this;
    }

    private byte[] computeThumbprint(X509Certificate cert, HashAlgorithm alg) {
        byte[] encoded = this.GET_X509_BYTES.apply(cert);
        InputStream in = Streams.of(encoded);
        DefaultRequest<InputStream> request = new DefaultRequest<InputStream>(in, null, null);
        return alg.digest(request);
    }

    public void apply() {
        Boolean computeX509Sha256;
        List<X509Certificate> chain = this.map.get(AbstractAsymmetricJwk.X5C);
        X509Certificate firstCert = null;
        if (!Collections.isEmpty(chain)) {
            firstCert = chain.get(0);
        }
        if ((computeX509Sha256 = this.computeX509Sha256Thumbprint) == null) {
            computeX509Sha256 = firstCert != null && !this.computeX509Sha1Thumbprint && Objects.isEmpty(this.map.get(AbstractAsymmetricJwk.X5T_S256));
        }
        if (firstCert != null) {
            byte[] thumbprint;
            if (this.computeX509Sha1Thumbprint) {
                thumbprint = this.computeThumbprint(firstCert, DefaultHashAlgorithm.SHA1);
                this.x509Sha1Thumbprint(thumbprint);
            }
            if (computeX509Sha256.booleanValue()) {
                thumbprint = this.computeThumbprint(firstCert, Jwks.HASH.SHA256);
                this.x509Sha256Thumbprint(thumbprint);
            }
        }
    }
}

