/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.common.BooleanWrapper;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.DateFormatterAdapter;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.resources.gcore.utils.Utils;

@XmlRootElement(name="Resource")
public class HostingNode
extends Resource {
    private static final String CURRENT_VERSION = "1.3.0";
    @XmlElementRef
    private Profile profile;

    public HostingNode() {
        this.type(Resource.Type.NODE);
        this.version(CURRENT_VERSION);
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    public Profile newProfile() {
        this.profile = new Profile();
        return this.profile;
    }

    @XmlType(propOrder={"infrastructure", "ghn", "site", "packages"})
    @XmlRootElement(name="Profile")
    public static class Profile {
        @XmlElement(name="Infrastructure")
        private String infrastructure;
        @XmlElementRef
        private NodeDescription ghn;
        @XmlElementRef
        private Site site;
        @XmlElementWrapper(name="DeployedPackages")
        @XmlElementRef
        private Set<DeployedPackage> packages = new LinkedHashSet<DeployedPackage>();

        void beforeMarshal(Marshaller marshaller) {
            if (this.packages != null && this.packages.isEmpty()) {
                this.packages = null;
            }
        }

        void afterMarshal(Marshaller marshaller) {
            if (this.packages == null) {
                this.packages = new LinkedHashSet<DeployedPackage>();
            }
        }

        public String infrastructure() {
            return this.infrastructure;
        }

        public Profile infrastructure(String infrastructure) {
            this.infrastructure = infrastructure;
            return this;
        }

        public NodeDescription description() {
            return this.ghn;
        }

        public NodeDescription newDescription() {
            this.ghn = new NodeDescription();
            return this.ghn;
        }

        public Site site() {
            return this.site;
        }

        public Site newSite() {
            this.site = new Site();
            return this.site;
        }

        public Group<DeployedPackage> packages() {
            return new Group<DeployedPackage>(this.packages, DeployedPackage.class);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ghn == null ? 0 : this.ghn.hashCode());
            result = 31 * result + (this.infrastructure == null ? 0 : this.infrastructure.hashCode());
            result = 31 * result + (this.packages == null ? 0 : this.packages.hashCode());
            result = 31 * result + (this.site == null ? 0 : this.site.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Profile other = (Profile)obj;
            if (this.ghn == null ? other.ghn != null : !this.ghn.equals(other.ghn)) {
                return false;
            }
            if (this.infrastructure == null ? other.infrastructure != null : !this.infrastructure.equals(other.infrastructure)) {
                return false;
            }
            if (this.packages == null ? other.packages != null : !this.packages.equals(other.packages)) {
                return false;
            }
            return !(this.site == null ? other.site != null : !this.site.equals(other.site));
        }

        public String toString() {
            return "Profile [infrastructure=" + this.infrastructure + ", ghn=" + this.ghn + ", site=" + this.site + ", packages=" + this.packages + "]";
        }

        @XmlType(propOrder={"packageName", "packageVersion", "serviceName", "serviceClass", "serviceVersion"})
        @XmlRootElement(name="Package")
        public static class DeployedPackage {
            @XmlElement(name="PackageName")
            private String packageName;
            @XmlElement(name="PackageVersion")
            private String packageVersion;
            @XmlElement(name="ServiceName")
            private String serviceName;
            @XmlElement(name="ServiceClass")
            private String serviceClass;
            @XmlElement(name="ServiceVersion")
            private String serviceVersion;

            public String name() {
                return this.packageName;
            }

            public DeployedPackage name(String name) {
                this.packageName = name;
                return this;
            }

            public String packageVersion() {
                return this.packageVersion;
            }

            public DeployedPackage packageVersion(String version) {
                this.packageVersion = version;
                return this;
            }

            public String serviceName() {
                return this.serviceName;
            }

            public DeployedPackage serviceName(String name) {
                this.serviceName = name;
                return this;
            }

            public String serviceClass() {
                return this.serviceClass;
            }

            public DeployedPackage serviceClass(String serviceClass) {
                this.serviceClass = serviceClass;
                return this;
            }

            public String serviceVersion() {
                return this.serviceVersion;
            }

            public DeployedPackage serviceVersion(String version) {
                this.serviceVersion = version;
                return this;
            }

            public String toString() {
                return "InstalledPackage [packageName=" + this.packageName + ", packageVersion=" + this.packageVersion() + ", serviceName=" + this.serviceName + ", serviceClass=" + this.serviceClass + ", serviceVersion=" + this.serviceVersion() + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
                result = 31 * result + (this.packageVersion == null ? 0 : this.packageVersion.hashCode());
                result = 31 * result + (this.serviceClass == null ? 0 : this.serviceClass.hashCode());
                result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
                result = 31 * result + (this.serviceVersion == null ? 0 : this.serviceVersion.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DeployedPackage other = (DeployedPackage)obj;
                if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
                    return false;
                }
                if (this.packageVersion == null ? other.packageVersion != null : !this.packageVersion.equals(other.packageVersion)) {
                    return false;
                }
                if (this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass)) {
                    return false;
                }
                if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
                    return false;
                }
                return !(this.serviceVersion == null ? other.serviceVersion != null : !this.serviceVersion.equals(other.serviceVersion));
            }
        }

        @XmlType(propOrder={"location", "country", "latitude", "longitude", "domain"})
        @XmlRootElement(name="Site")
        public static class Site {
            @XmlElement(name="Location")
            private String location;
            @XmlElement(name="Country")
            private String country;
            @XmlElement(name="Latitude")
            private String latitude;
            @XmlElement(name="Longitude")
            private String longitude;
            @XmlElement(name="Domain")
            private String domain;

            public String location() {
                return this.location;
            }

            public Site location(String location) {
                this.location = location;
                return this;
            }

            public String country() {
                return this.country;
            }

            public Site country(String country) {
                this.country = country;
                return this;
            }

            public String latitude() {
                return this.latitude;
            }

            public Site latitude(String latitude) {
                this.latitude = latitude;
                return this;
            }

            public String longitude() {
                return this.longitude;
            }

            public Site longitude(String longitude) {
                this.longitude = longitude;
                return this;
            }

            public String domain() {
                return this.domain;
            }

            public Site domain(String domain) {
                this.domain = domain;
                return this;
            }

            public String toString() {
                return "Site [location=" + this.location + ", country=" + this.country + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", domain=" + this.domain + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
                result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
                result = 31 * result + (this.latitude == null ? 0 : this.latitude.hashCode());
                result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
                result = 31 * result + (this.longitude == null ? 0 : this.longitude.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Site other = (Site)obj;
                if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
                    return false;
                }
                if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
                    return false;
                }
                if (this.latitude == null ? other.latitude != null : !this.latitude.equals(other.latitude)) {
                    return false;
                }
                if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
                    return false;
                }
                return !(this.longitude == null ? other.longitude != null : !this.longitude.equals(other.longitude));
            }
        }

        @XmlType(propOrder={"name", "activationTime", "status", "statusMessage", "ghnType", "platforms", "securityEnabled", "securityData", "architecture", "operatingSystem", "processors", "networkAdapters", "benchmark", "runtimeEnvironment", "storageDevices", "storagePartitions", "localFileSystems", "remoteFileSystems", "devicePartitionMap", "partitionFilesystemMap", "uptime", "load", "historicalLoad", "mainMemory", "localAvailableSpace", "lastUpdate"})
        @XmlRootElement(name="GHNDescription")
        public static class NodeDescription {
            @XmlElement(name="Name")
            private String name;
            @XmlElement(name="ActivationTime")
            @XmlJavaTypeAdapter(value=DateFormatterAdapter.class)
            private Calendar activationTime;
            @XmlElement(name="Status")
            private String status;
            @XmlElement(name="StatusMessage")
            private String statusMessage;
            @XmlElement(name="Type")
            private GHNType ghnType = GHNType.Dynamic;
            @XmlElementWrapper(name="AvailablePlatforms")
            @XmlElementRef
            private Set<Platform> platforms = new LinkedHashSet<Platform>();
            @XmlElement(name="SecurityEnabled")
            private BooleanWrapper securityEnabled = new BooleanWrapper(false);
            @XmlElementRef
            private Security securityData;
            @XmlElementRef
            private Architecture architecture;
            @XmlElementRef
            private OperatingSystem operatingSystem;
            @XmlElementRef
            private Set<Processor> processors = new LinkedHashSet<Processor>();
            @XmlElementRef
            private Set<NetworkAdapter> networkAdapters = new LinkedHashSet<NetworkAdapter>();
            @XmlElementRef
            private Benchmark benchmark;
            @XmlElementWrapper(name="RunTimeEnv")
            @XmlElementRef
            private Set<Variable> runtimeEnvironment = new LinkedHashSet<Variable>();
            @XmlElementRef
            private Set<StorageDevice> storageDevices = new LinkedHashSet<StorageDevice>();
            @XmlElementRef
            private Set<StoragePartition> storagePartitions = new LinkedHashSet<StoragePartition>();
            @XmlElementRef
            private Set<LocalFileSystem> localFileSystems = new LinkedHashSet<LocalFileSystem>();
            @XmlElementRef
            private Set<RemoteFileSystem> remoteFileSystems = new LinkedHashSet<RemoteFileSystem>();
            @XmlElementRef
            private Set<DevicePartition> devicePartitionMap = new LinkedHashSet<DevicePartition>();
            @XmlElementRef
            private Set<FileSystemPartition> partitionFilesystemMap = new LinkedHashSet<FileSystemPartition>();
            @XmlElement(name="Uptime")
            private String uptime;
            @XmlElementRef
            private Load load;
            @XmlElementRef
            private HistoricalLoad historicalLoad;
            @XmlElementRef
            private MainMemory mainMemory;
            @XmlElement(name="LocalAvailableSpace")
            private Long localAvailableSpace;
            @XmlElement(name="LastUpdate")
            @XmlJavaTypeAdapter(value=DateFormatterAdapter.class)
            private Calendar lastUpdate;

            void beforeMarshal(Marshaller marshaller) {
                if (this.platforms != null && this.platforms.isEmpty()) {
                    this.platforms = null;
                }
                if (this.runtimeEnvironment != null && this.runtimeEnvironment.isEmpty()) {
                    this.runtimeEnvironment = null;
                }
            }

            void afterMarshal(Marshaller marshaller) {
                if (this.platforms == null) {
                    this.platforms = new LinkedHashSet<Platform>();
                }
                if (this.runtimeEnvironment == null) {
                    this.runtimeEnvironment = new LinkedHashSet<Variable>();
                }
            }

            public String name() {
                return this.name;
            }

            public NodeDescription name(String name) {
                this.name = name;
                return this;
            }

            public Calendar activationTime() {
                return this.activationTime;
            }

            public NodeDescription activationTime(Calendar time) {
                this.activationTime = time;
                return this;
            }

            public String status() {
                return this.status;
            }

            public NodeDescription status(String status) {
                this.status = status;
                return this;
            }

            public String statusMessage() {
                return this.statusMessage;
            }

            public NodeDescription statusMessage(String message) {
                this.statusMessage = message;
                return this;
            }

            public GHNType type() {
                return this.ghnType;
            }

            public NodeDescription type(GHNType type) {
                this.ghnType = type;
                return this;
            }

            public Group<Platform> platforms() {
                return new Group<Platform>(this.platforms, Platform.class);
            }

            public boolean isSecurityEnabled() {
                return this.securityEnabled.value;
            }

            public NodeDescription enableSecurity(boolean enabled) {
                if (this.securityEnabled == null) {
                    this.securityEnabled = new BooleanWrapper();
                }
                this.securityEnabled.value = enabled;
                return this;
            }

            public Security security() {
                return this.securityData;
            }

            public Security newSecurity() {
                this.securityData = new Security();
                return this.securityData;
            }

            public Architecture architecture() {
                return this.architecture;
            }

            public Architecture newArchitecture() {
                this.architecture = new Architecture();
                return this.architecture;
            }

            public OperatingSystem operatingSystem() {
                return this.operatingSystem;
            }

            public OperatingSystem newOperatingSystem() {
                this.operatingSystem = new OperatingSystem();
                return this.operatingSystem;
            }

            public Group<Processor> processors() {
                return new Group<Processor>(this.processors, Processor.class);
            }

            public Group<NetworkAdapter> networkAdapters() {
                return new Group<NetworkAdapter>(this.networkAdapters, NetworkAdapter.class);
            }

            public Benchmark benchmark() {
                return this.benchmark;
            }

            public Benchmark newBenchmark() {
                this.benchmark = new Benchmark();
                return this.benchmark;
            }

            public Group<Variable> environmentVariables() {
                return new Group<Variable>(this.runtimeEnvironment, Variable.class);
            }

            public Map<String, Variable> variablesMap() {
                HashMap<String, Variable> map = new HashMap<String, Variable>();
                for (Variable v : this.runtimeEnvironment) {
                    if (v.key() == null) continue;
                    map.put(v.key(), v);
                }
                return map;
            }

            public Group<StorageDevice> storageDevices() {
                return new Group<StorageDevice>(this.storageDevices, StorageDevice.class);
            }

            public Group<StoragePartition> storagePartitions() {
                return new Group<StoragePartition>(this.storagePartitions, StoragePartition.class);
            }

            public Group<LocalFileSystem> localFileSystems() {
                return new Group<LocalFileSystem>(this.localFileSystems, LocalFileSystem.class);
            }

            public Group<RemoteFileSystem> remoteFileSystems() {
                return new Group<RemoteFileSystem>(this.remoteFileSystems, RemoteFileSystem.class);
            }

            public Group<DevicePartition> devicePartitions() {
                return new Group<DevicePartition>(this.devicePartitionMap, DevicePartition.class);
            }

            public Group<FileSystemPartition> fileSystemPartitions() {
                return new Group<FileSystemPartition>(this.partitionFilesystemMap, FileSystemPartition.class);
            }

            public String uptime() {
                return this.uptime;
            }

            public NodeDescription uptime(String uptime) {
                this.uptime = uptime;
                return this;
            }

            public Load load() {
                return this.load;
            }

            public Load newLoad() {
                this.load = new Load();
                return this.load;
            }

            public HistoricalLoad historicalLoad() {
                return this.historicalLoad;
            }

            public HistoricalLoad newHistoricalLoad() {
                this.historicalLoad = new HistoricalLoad();
                return this.historicalLoad;
            }

            public MainMemory mainMemory() {
                return this.mainMemory;
            }

            public MainMemory newMainMemory() {
                this.mainMemory = new MainMemory();
                return this.mainMemory;
            }

            public Long localAvailableSpace() {
                return this.localAvailableSpace;
            }

            public void localAvailableSpace(Long amount) {
                this.localAvailableSpace = amount;
            }

            @Deprecated
            public Integer localAvailableStorage() {
                return this.localAvailableSpace.intValue();
            }

            @Deprecated
            public NodeDescription localAvailableStorage(int amount) {
                this.localAvailableSpace = amount;
                return this;
            }

            public Calendar lastUpdate() {
                return this.lastUpdate;
            }

            public NodeDescription lastUpdate(Calendar time) {
                this.lastUpdate = time;
                return this;
            }

            public String toString() {
                return "GHNDescriptor [name=" + this.name + ", activationTime=" + Utils.toString(this.activationTime) + ", status=" + this.status + ", statusMessage=" + this.statusMessage + ", ghnType=" + (Object)((Object)this.ghnType) + ", platforms=" + this.platforms + ", securityEnabled=" + this.securityEnabled.value + ", securityData=" + this.securityData + ", architecture=" + this.architecture + ", operatingSystem=" + this.operatingSystem + ", processors=" + this.processors + ", networkAdapters=" + this.networkAdapters + ", benchmark=" + this.benchmark + ", runtimeEnvironment=" + this.runtimeEnvironment + ", storageDevices=" + this.storageDevices + ", storagePartitions=" + this.storagePartitions + ", localFileSystems=" + this.localFileSystems + ", remoteFileSystems=" + this.remoteFileSystems + ", devicePartitionMap=" + this.devicePartitionMap + ", partitionFilesystemMap=" + this.partitionFilesystemMap + ", uptime=" + this.uptime + ", load=" + this.load + ", historicalLoad=" + this.historicalLoad + ", mainMemory=" + this.mainMemory + ", localAvailableSpace=" + this.localAvailableSpace + ", lastUpdate=" + Utils.toString(this.lastUpdate) + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.activationTime == null ? 0 : this.activationTime.hashCode());
                result = 31 * result + (this.architecture == null ? 0 : this.architecture.hashCode());
                result = 31 * result + (this.benchmark == null ? 0 : this.benchmark.hashCode());
                result = 31 * result + (this.devicePartitionMap == null ? 0 : this.devicePartitionMap.hashCode());
                result = 31 * result + (this.ghnType == null ? 0 : this.ghnType.hashCode());
                result = 31 * result + (this.historicalLoad == null ? 0 : this.historicalLoad.hashCode());
                result = 31 * result + (this.lastUpdate == null ? 0 : this.lastUpdate.hashCode());
                result = 31 * result + (this.load == null ? 0 : this.load.hashCode());
                result = 31 * result + this.localAvailableSpace.hashCode();
                result = 31 * result + (this.localFileSystems == null ? 0 : this.localFileSystems.hashCode());
                result = 31 * result + (this.mainMemory == null ? 0 : this.mainMemory.hashCode());
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.networkAdapters == null ? 0 : this.networkAdapters.hashCode());
                result = 31 * result + (this.operatingSystem == null ? 0 : this.operatingSystem.hashCode());
                result = 31 * result + (this.partitionFilesystemMap == null ? 0 : this.partitionFilesystemMap.hashCode());
                result = 31 * result + (this.platforms == null ? 0 : this.platforms.hashCode());
                result = 31 * result + (this.processors == null ? 0 : this.processors.hashCode());
                result = 31 * result + (this.remoteFileSystems == null ? 0 : this.remoteFileSystems.hashCode());
                result = 31 * result + (this.runtimeEnvironment == null ? 0 : this.runtimeEnvironment.hashCode());
                result = 31 * result + (this.securityData == null ? 0 : this.securityData.hashCode());
                result = 31 * result + (this.securityEnabled == null ? 0 : this.securityEnabled.hashCode());
                result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
                result = 31 * result + (this.statusMessage == null ? 0 : this.statusMessage.hashCode());
                result = 31 * result + (this.storageDevices == null ? 0 : this.storageDevices.hashCode());
                result = 31 * result + (this.storagePartitions == null ? 0 : this.storagePartitions.hashCode());
                result = 31 * result + (this.uptime == null ? 0 : this.uptime.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                NodeDescription other = (NodeDescription)obj;
                if (this.activationTime == null ? other.activationTime != null : !this.activationTime.equals(other.activationTime)) {
                    return false;
                }
                if (this.architecture == null ? other.architecture != null : !this.architecture.equals(other.architecture)) {
                    return false;
                }
                if (this.benchmark == null ? other.benchmark != null : !this.benchmark.equals(other.benchmark)) {
                    return false;
                }
                if (this.devicePartitionMap == null ? other.devicePartitionMap != null : !this.devicePartitionMap.equals(other.devicePartitionMap)) {
                    return false;
                }
                if (this.ghnType != other.ghnType) {
                    return false;
                }
                if (this.historicalLoad == null ? other.historicalLoad != null : !this.historicalLoad.equals(other.historicalLoad)) {
                    return false;
                }
                if (this.lastUpdate == null ? other.lastUpdate != null : !this.lastUpdate.equals(other.lastUpdate)) {
                    return false;
                }
                if (this.load == null ? other.load != null : !this.load.equals(other.load)) {
                    return false;
                }
                if (this.localAvailableSpace != other.localAvailableSpace) {
                    return false;
                }
                if (this.localFileSystems == null ? other.localFileSystems != null : !this.localFileSystems.equals(other.localFileSystems)) {
                    return false;
                }
                if (this.mainMemory == null ? other.mainMemory != null : !this.mainMemory.equals(other.mainMemory)) {
                    return false;
                }
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                if (this.networkAdapters == null ? other.networkAdapters != null : !this.networkAdapters.equals(other.networkAdapters)) {
                    return false;
                }
                if (this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals(other.operatingSystem)) {
                    return false;
                }
                if (this.partitionFilesystemMap == null ? other.partitionFilesystemMap != null : !this.partitionFilesystemMap.equals(other.partitionFilesystemMap)) {
                    return false;
                }
                if (this.platforms == null ? other.platforms != null : !this.platforms.equals(other.platforms)) {
                    return false;
                }
                if (this.processors == null ? other.processors != null : !this.processors.equals(other.processors)) {
                    return false;
                }
                if (this.remoteFileSystems == null ? other.remoteFileSystems != null : !this.remoteFileSystems.equals(other.remoteFileSystems)) {
                    return false;
                }
                if (this.runtimeEnvironment == null ? other.runtimeEnvironment != null : !this.runtimeEnvironment.equals(other.runtimeEnvironment)) {
                    return false;
                }
                if (this.securityData == null ? other.securityData != null : !this.securityData.equals(other.securityData)) {
                    return false;
                }
                if (this.securityEnabled == null ? other.securityEnabled != null : !this.securityEnabled.equals(other.securityEnabled)) {
                    return false;
                }
                if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
                    return false;
                }
                if (this.statusMessage == null ? other.statusMessage != null : !this.statusMessage.equals(other.statusMessage)) {
                    return false;
                }
                if (this.storageDevices == null ? other.storageDevices != null : !this.storageDevices.equals(other.storageDevices)) {
                    return false;
                }
                if (this.storagePartitions == null ? other.storagePartitions != null : !this.storagePartitions.equals(other.storagePartitions)) {
                    return false;
                }
                return !(this.uptime == null ? other.uptime != null : !this.uptime.equals(other.uptime));
            }

            @XmlRootElement(name="MainMemory")
            public static class MainMemory {
                @XmlAttribute(name="RAMSize")
                private long ramSize;
                @XmlAttribute(name="VirtualSize")
                private long virtualSize;
                @XmlAttribute(name="RAMAvailable")
                private long ramAvailable;
                @XmlAttribute(name="VirtualAvailable")
                private long virtualAvailable;

                public Long ramSize() {
                    return this.ramSize;
                }

                public MainMemory ramSize(long size) {
                    this.ramSize = size;
                    return this;
                }

                public long virtualSize() {
                    return this.virtualSize;
                }

                public MainMemory virtualSize(long size) {
                    this.virtualSize = size;
                    return this;
                }

                public Long ramAvailable() {
                    return this.ramAvailable;
                }

                public MainMemory ramAvailable(long amount) {
                    this.ramAvailable = amount;
                    return this;
                }

                public Long virtualAvailable() {
                    return this.virtualAvailable;
                }

                public MainMemory virtualAvailable(long amount) {
                    this.virtualAvailable = amount;
                    return this;
                }

                public String toString() {
                    return "MainMemory [ramSize=" + this.ramSize + ", virtualSize=" + this.virtualSize + ", ramAvailable=" + this.ramAvailable + ", virtualAvailable=" + this.virtualAvailable + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (int)(this.ramAvailable ^ this.ramAvailable >>> 32);
                    result = 31 * result + (int)(this.ramSize ^ this.ramSize >>> 32);
                    result = 31 * result + (int)(this.virtualAvailable ^ this.virtualAvailable >>> 32);
                    result = 31 * result + (int)(this.virtualSize ^ this.virtualSize >>> 32);
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    MainMemory other = (MainMemory)obj;
                    if (this.ramAvailable != other.ramAvailable) {
                        return false;
                    }
                    if (this.ramSize != other.ramSize) {
                        return false;
                    }
                    if (this.virtualAvailable != other.virtualAvailable) {
                        return false;
                    }
                    return this.virtualSize == other.virtualSize;
                }
            }

            @XmlRootElement(name="HistoricalLoad")
            public static class HistoricalLoad {
                @XmlAttribute(name="Last1H")
                private Double last1H;
                @XmlAttribute(name="Last1Day")
                private Double last1Day;
                @XmlAttribute(name="Last1Week")
                private Double last1Week;

                public Double lastHour() {
                    return this.last1H;
                }

                public HistoricalLoad lastHour(double load) {
                    this.last1H = load;
                    return this;
                }

                public Double lastDay() {
                    return this.last1Day;
                }

                public HistoricalLoad lastDay(double load) {
                    this.last1Day = load;
                    return this;
                }

                public Double lastWeek() {
                    return this.last1Week;
                }

                public HistoricalLoad lastWeek(double load) {
                    this.last1Week = load;
                    return this;
                }

                public String toString() {
                    return "HistoricalLoad [last1H=" + this.last1H + ", last1Day=" + this.last1Day + ", last1Week=" + this.last1Week + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    long temp = Double.doubleToLongBits(this.last1Day);
                    result = 31 * result + (int)(temp ^ temp >>> 32);
                    temp = Double.doubleToLongBits(this.last1H);
                    result = 31 * result + (int)(temp ^ temp >>> 32);
                    temp = Double.doubleToLongBits(this.last1Week);
                    result = 31 * result + (int)(temp ^ temp >>> 32);
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    HistoricalLoad other = (HistoricalLoad)obj;
                    if (Double.doubleToLongBits(this.last1Day) != Double.doubleToLongBits(other.last1Day)) {
                        return false;
                    }
                    if (Double.doubleToLongBits(this.last1H) != Double.doubleToLongBits(other.last1H)) {
                        return false;
                    }
                    return Double.doubleToLongBits(this.last1Week) == Double.doubleToLongBits(other.last1Week);
                }
            }

            @XmlRootElement(name="Load")
            public static class Load {
                @XmlAttribute(name="Last1Min")
                private Double last1Min;
                @XmlAttribute(name="Last5Min")
                private Double last5Min;
                @XmlAttribute(name="Last15Min")
                private Double last15Min;

                public Double lastMin() {
                    return this.last1Min;
                }

                public Load lastMin(double load) {
                    this.last1Min = load;
                    return this;
                }

                public Double last5Mins() {
                    return this.last5Min;
                }

                public Load last5Mins(double load) {
                    this.last5Min = load;
                    return this;
                }

                public Double last15Mins() {
                    return this.last15Min;
                }

                public Load last15Mins(double load) {
                    this.last15Min = load;
                    return this;
                }

                public String toString() {
                    return "[last1Min=" + this.last1Min + ", last5Min=" + this.last5Min + ", last15Min=" + this.last15Min + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.last15Min == null ? 0 : this.last15Min.hashCode());
                    result = 31 * result + (this.last1Min == null ? 0 : this.last1Min.hashCode());
                    result = 31 * result + (this.last5Min == null ? 0 : this.last5Min.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Load other = (Load)obj;
                    if (this.last15Min == null ? other.last15Min != null : !this.last15Min.equals(other.last15Min)) {
                        return false;
                    }
                    if (this.last1Min == null ? other.last1Min != null : !this.last1Min.equals(other.last1Min)) {
                        return false;
                    }
                    return !(this.last5Min == null ? other.last5Min != null : !this.last5Min.equals(other.last5Min));
                }
            }

            @XmlRootElement(name="StoragePartition2FileSystem")
            public static class FileSystemPartition {
                @XmlAttribute(name="StoragePartitionName")
                private String storagePartitionName;
                @XmlAttribute(name="FileSystemName")
                private String fileSystemName;

                public String storagePartitionName() {
                    return this.storagePartitionName;
                }

                public FileSystemPartition storageName(String name) {
                    this.storagePartitionName = name;
                    return this;
                }

                public String fsName() {
                    return this.fileSystemName;
                }

                public FileSystemPartition fsName(String name) {
                    this.fileSystemName = name;
                    return this;
                }

                public String toString() {
                    return "PartitionFilesystemMapping [storagePartitionName=" + this.storagePartitionName + ", fileSystemName=" + this.fileSystemName + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.fileSystemName == null ? 0 : this.fileSystemName.hashCode());
                    result = 31 * result + (this.storagePartitionName == null ? 0 : this.storagePartitionName.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    FileSystemPartition other = (FileSystemPartition)obj;
                    if (this.fileSystemName == null ? other.fileSystemName != null : !this.fileSystemName.equals(other.fileSystemName)) {
                        return false;
                    }
                    return !(this.storagePartitionName == null ? other.storagePartitionName != null : !this.storagePartitionName.equals(other.storagePartitionName));
                }
            }

            @XmlRootElement(name="StorageDevice2StoragePartition")
            public static class DevicePartition {
                @XmlAttribute(name="StorageDeviceName")
                private String storageDeviceName;
                @XmlAttribute(name="StoragePartitionName")
                private String storagePartitionName;

                public String device() {
                    return this.storageDeviceName;
                }

                public DevicePartition device(String name) {
                    this.storageDeviceName = name;
                    return this;
                }

                public String name() {
                    return this.storagePartitionName;
                }

                public DevicePartition name(String name) {
                    this.storagePartitionName = name;
                    return this;
                }

                public String toString() {
                    return "DevicePartitionMapping [storageDeviceName=" + this.storageDeviceName + ", storagePartitionName=" + this.storagePartitionName + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.storageDeviceName == null ? 0 : this.storageDeviceName.hashCode());
                    result = 31 * result + (this.storagePartitionName == null ? 0 : this.storagePartitionName.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    DevicePartition other = (DevicePartition)obj;
                    if (this.storageDeviceName == null ? other.storageDeviceName != null : !this.storageDeviceName.equals(other.storageDeviceName)) {
                        return false;
                    }
                    return !(this.storagePartitionName == null ? other.storagePartitionName != null : !this.storagePartitionName.equals(other.storagePartitionName));
                }
            }

            @XmlType(name="FileSystemType")
            public static class FileSystemType {
                @XmlAttribute(name="Name")
                private String name;
                @XmlAttribute(name="Root")
                private String root;
                @XmlAttribute(name="Size")
                private int size;
                @XmlAttribute(name="ReadOnly")
                private boolean readonly;
                @XmlAttribute(name="Type")
                private String type;

                public String name() {
                    return this.name;
                }

                public FileSystemType name(String name) {
                    this.name = name;
                    return this;
                }

                public String root() {
                    return this.root;
                }

                public FileSystemType root(String root) {
                    this.root = root;
                    return this;
                }

                public int size() {
                    return this.size;
                }

                public FileSystemType size(int size) {
                    this.size = size;
                    return this;
                }

                public boolean isReadOnly() {
                    return this.readonly;
                }

                public FileSystemType readOnly(boolean value) {
                    this.readonly = value;
                    return this;
                }

                public String type() {
                    return this.type;
                }

                public FileSystemType type(String type) {
                    this.type = type;
                    return this;
                }

                public String toString() {
                    return "FileSystemType [name=" + this.name + ", root=" + this.root + ", size=" + this.size + ", readonly=" + this.readonly + ", type=" + this.type + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    result = 31 * result + (this.readonly ? 1231 : 1237);
                    result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
                    result = 31 * result + this.size;
                    result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    FileSystemType other = (FileSystemType)obj;
                    if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                        return false;
                    }
                    if (this.readonly != other.readonly) {
                        return false;
                    }
                    if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
                        return false;
                    }
                    if (this.size != other.size) {
                        return false;
                    }
                    return !(this.type == null ? other.type != null : !this.type.equals(other.type));
                }
            }

            @XmlRootElement(name="RemoteFileSystem")
            public static class RemoteFileSystem
            extends FileSystemType {
            }

            @XmlRootElement(name="LocalFileSystem")
            public static class LocalFileSystem
            extends FileSystemType {
            }

            @XmlRootElement(name="StoragePartition")
            public static class StoragePartition {
                @XmlAttribute(name="Name")
                private String name;
                @XmlAttribute(name="Size")
                private String size;
                @XmlAttribute(name="ReadRate")
                private int readRate;
                @XmlAttribute(name="WriteRate")
                private int writeRate;

                public String name() {
                    return this.name;
                }

                public StoragePartition name(String name) {
                    this.name = name;
                    return this;
                }

                public String size() {
                    return this.size;
                }

                public StoragePartition size(String size) {
                    this.size = size;
                    return this;
                }

                public int readRate() {
                    return this.readRate;
                }

                public StoragePartition readRate(int rate) {
                    this.readRate = rate;
                    return this;
                }

                public int writeRate() {
                    return this.writeRate;
                }

                public StoragePartition writeRate(int rate) {
                    this.writeRate = rate;
                    return this;
                }

                public String toString() {
                    return "StoragePartition [name=" + this.name + ", size=" + this.size + ", readRate=" + this.readRate + ", writeRate=" + this.writeRate + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    result = 31 * result + this.readRate;
                    result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
                    result = 31 * result + this.writeRate;
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    StoragePartition other = (StoragePartition)obj;
                    if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                        return false;
                    }
                    if (this.readRate != other.readRate) {
                        return false;
                    }
                    if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
                        return false;
                    }
                    return this.writeRate == other.writeRate;
                }
            }

            @XmlRootElement(name="StorageDevice")
            public static class StorageDevice {
                @XmlAttribute(name="Name")
                private String name;
                @XmlAttribute(name="Type")
                private String type;
                @XmlAttribute(name="TransferRate")
                private int transferRate;
                @XmlAttribute(name="Size")
                private int size;

                public String name() {
                    return this.name;
                }

                public StorageDevice name(String name) {
                    this.name = name;
                    return this;
                }

                public String type() {
                    return this.type;
                }

                public StorageDevice type(String type) {
                    this.type = type;
                    return this;
                }

                public int transferRate() {
                    return this.transferRate;
                }

                public StorageDevice transferRate(int rate) {
                    this.transferRate = rate;
                    return this;
                }

                public int size() {
                    return this.size;
                }

                public StorageDevice size(int size) {
                    this.size = size;
                    return this;
                }

                public String toString() {
                    return "StorageDevice [name=" + this.name + ", type=" + this.type + ", transferRate=" + this.transferRate + ", size=" + this.size + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    result = 31 * result + this.size;
                    result = 31 * result + this.transferRate;
                    result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    StorageDevice other = (StorageDevice)obj;
                    if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                        return false;
                    }
                    if (this.size != other.size) {
                        return false;
                    }
                    if (this.transferRate != other.transferRate) {
                        return false;
                    }
                    return !(this.type == null ? other.type != null : !this.type.equals(other.type));
                }
            }

            @XmlType(propOrder={"key", "value"})
            @XmlRootElement(name="Variable")
            public static class Variable {
                @XmlElement(name="Key")
                private String key;
                @XmlElement(name="Value")
                private String value;

                public String key() {
                    return this.key;
                }

                public String value() {
                    return this.value;
                }

                public void keyAndValue(String key, String value) {
                    this.key = key;
                    this.value = value;
                }

                public String toString() {
                    return "Variable [key=" + this.key + ", value=" + this.value + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
                    result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Variable other = (Variable)obj;
                    if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                        return false;
                    }
                    return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                }
            }

            @XmlRootElement(name="Benchmark")
            public static class Benchmark {
                @XmlAttribute(name="SI00")
                private int si00;
                @XmlAttribute(name="SF00")
                private int sf00;

                public int si00() {
                    return this.si00;
                }

                public Benchmark si(int si) {
                    this.si00 = si;
                    return this;
                }

                public int sf00() {
                    return this.sf00;
                }

                public Benchmark sf(int sf) {
                    this.sf00 = sf;
                    return this;
                }

                public String toString() {
                    return "Benchmark [si00=" + this.si00 + ", sf00=" + this.sf00 + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + this.sf00;
                    result = 31 * result + this.si00;
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Benchmark other = (Benchmark)obj;
                    if (this.sf00 != other.sf00) {
                        return false;
                    }
                    return this.si00 == other.si00;
                }
            }

            @XmlRootElement(name="NetworkAdapter")
            public static class NetworkAdapter {
                @XmlAttribute(name="InboundIP")
                private String inboundIP;
                @XmlAttribute(name="OutboundIP")
                private String outboundIP;
                @XmlAttribute(name="Name")
                private String name;
                @XmlAttribute(name="IPAddress")
                private String ipAddress;
                @XmlAttribute(name="MTU")
                private int mtu;

                public String inboundIP() {
                    return this.inboundIP;
                }

                public NetworkAdapter inboundIP(String ip) {
                    this.inboundIP = ip;
                    return this;
                }

                public String outboundIP() {
                    return this.outboundIP;
                }

                public NetworkAdapter outboundIP(String ip) {
                    this.outboundIP = ip;
                    return this;
                }

                public String name() {
                    return this.name;
                }

                public NetworkAdapter name(String name) {
                    this.name = name;
                    return this;
                }

                public String ipAddress() {
                    return this.ipAddress;
                }

                public NetworkAdapter ipAddress(String address) {
                    this.ipAddress = address;
                    return this;
                }

                public int mtu() {
                    return this.mtu;
                }

                public NetworkAdapter mtu(int mtu) {
                    this.mtu = mtu;
                    return this;
                }

                public String toString() {
                    return "NetworkAdapter [inboundIP=" + this.inboundIP + ", outboundIP=" + this.outboundIP + ", name=" + this.name + ", ipAddress=" + this.ipAddress + ", mtu=" + this.mtu + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.inboundIP == null ? 0 : this.inboundIP.hashCode());
                    result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
                    result = 31 * result + this.mtu;
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    result = 31 * result + (this.outboundIP == null ? 0 : this.outboundIP.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    NetworkAdapter other = (NetworkAdapter)obj;
                    if (this.inboundIP == null ? other.inboundIP != null : !this.inboundIP.equals(other.inboundIP)) {
                        return false;
                    }
                    if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
                        return false;
                    }
                    if (this.mtu != other.mtu) {
                        return false;
                    }
                    if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                        return false;
                    }
                    return !(this.outboundIP == null ? other.outboundIP != null : !this.outboundIP.equals(other.outboundIP));
                }
            }

            @XmlRootElement(name="Processor")
            public static class Processor {
                @XmlAttribute(name="Vendor")
                private String vendor;
                @XmlAttribute(name="Model")
                private String model;
                @XmlAttribute(name="ModelName")
                private String modelName;
                @XmlAttribute(name="Family")
                private String family;
                @XmlAttribute(name="ClockSpeedMhz")
                private BigDecimal clockSpeedMhz;
                @XmlAttribute(name="Bogomips")
                private BigDecimal bogomips;
                @XmlAttribute(name="CacheL1")
                private int cacheL1;
                @XmlAttribute(name="CacheL1I")
                private int cacheL1I;
                @XmlAttribute(name="CacheL1D")
                private int cacheL1D;
                @XmlAttribute(name="CacheL2")
                private int cacheL2;

                public String vendor() {
                    return this.vendor;
                }

                public Processor vendor(String vendor) {
                    this.vendor = vendor;
                    return this;
                }

                public String model() {
                    return this.model;
                }

                public Processor model(String model) {
                    this.model = model;
                    return this;
                }

                public String modelName() {
                    return this.modelName;
                }

                public Processor modelName(String name) {
                    this.modelName = name;
                    return this;
                }

                public String family() {
                    return this.family;
                }

                public Processor family(String family) {
                    this.family = family;
                    return this;
                }

                public BigDecimal clockSpeedMhz() {
                    return this.clockSpeedMhz;
                }

                public Processor clockSpeedMhz(BigDecimal speed) {
                    this.clockSpeedMhz = speed;
                    return this;
                }

                public BigDecimal bogomips() {
                    return this.bogomips;
                }

                public Processor bogomips(BigDecimal bogomips) {
                    this.bogomips = bogomips;
                    return this;
                }

                public int cacheL1() {
                    return this.cacheL1;
                }

                public Processor cacheL1(int cache) {
                    this.cacheL1 = cache;
                    return this;
                }

                public int cacheL1I() {
                    return this.cacheL1I;
                }

                public Processor cacheL1I(int cache) {
                    this.cacheL1I = cache;
                    return this;
                }

                public int cacheL1D() {
                    return this.cacheL1D;
                }

                public Processor cacheL1D(int cache) {
                    this.cacheL1D = cache;
                    return this;
                }

                public int cacheL2() {
                    return this.cacheL2;
                }

                public Processor cacheL2(int cache) {
                    this.cacheL2 = cache;
                    return this;
                }

                public String toString() {
                    return "Processor [vendor=" + this.vendor + ", model=" + this.model + ", modelName=" + this.modelName + ", family=" + this.family + ", clockSpeedMhz=" + this.clockSpeedMhz + ", bogomips=" + this.bogomips + ", cacheL1=" + this.cacheL1 + ", cacheL1I=" + this.cacheL1I + ", cacheL1D=" + this.cacheL1D + ", cacheL2=" + this.cacheL2 + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.bogomips == null ? 0 : this.bogomips.hashCode());
                    result = 31 * result + this.cacheL1;
                    result = 31 * result + this.cacheL1D;
                    result = 31 * result + this.cacheL1I;
                    result = 31 * result + this.cacheL2;
                    result = 31 * result + (this.clockSpeedMhz == null ? 0 : this.clockSpeedMhz.hashCode());
                    result = 31 * result + (this.family == null ? 0 : this.family.hashCode());
                    result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
                    result = 31 * result + (this.modelName == null ? 0 : this.modelName.hashCode());
                    result = 31 * result + (this.vendor == null ? 0 : this.vendor.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Processor other = (Processor)obj;
                    if (this.bogomips == null ? other.bogomips != null : !this.bogomips.equals(other.bogomips)) {
                        return false;
                    }
                    if (this.cacheL1 != other.cacheL1) {
                        return false;
                    }
                    if (this.cacheL1D != other.cacheL1D) {
                        return false;
                    }
                    if (this.cacheL1I != other.cacheL1I) {
                        return false;
                    }
                    if (this.cacheL2 != other.cacheL2) {
                        return false;
                    }
                    if (this.clockSpeedMhz == null ? other.clockSpeedMhz != null : !this.clockSpeedMhz.equals(other.clockSpeedMhz)) {
                        return false;
                    }
                    if (this.family == null ? other.family != null : !this.family.equals(other.family)) {
                        return false;
                    }
                    if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
                        return false;
                    }
                    if (this.modelName == null ? other.modelName != null : !this.modelName.equals(other.modelName)) {
                        return false;
                    }
                    return !(this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor));
                }
            }

            @XmlRootElement(name="OperatingSystem")
            public static class OperatingSystem {
                @XmlAttribute(name="Name")
                private String name;
                @XmlAttribute(name="Release")
                private String release;
                @XmlAttribute(name="Version")
                private String version;

                public String name() {
                    return this.name;
                }

                public OperatingSystem name(String name) {
                    this.name = name;
                    return this;
                }

                public String release() {
                    return this.release;
                }

                public OperatingSystem release(String release) {
                    this.release = release;
                    return this;
                }

                public String version() {
                    return this.version;
                }

                public OperatingSystem version(String version) {
                    this.version = version;
                    return this;
                }

                public String toString() {
                    return "OperatingSystem [name=" + this.name + ", release=" + this.release + ", version=" + this.version + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    result = 31 * result + (this.release == null ? 0 : this.release.hashCode());
                    result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    OperatingSystem other = (OperatingSystem)obj;
                    if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                        return false;
                    }
                    if (this.release == null ? other.release != null : !this.release.equals(other.release)) {
                        return false;
                    }
                    return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                }
            }

            @XmlRootElement(name="Architecture")
            public static class Architecture {
                @XmlAttribute(name="PlatformType")
                private String platformType;
                @XmlAttribute(name="SMPSize")
                private int smpSize;
                @XmlAttribute(name="SMTSize")
                private int smtSize;

                public String platformType() {
                    return this.platformType;
                }

                public Architecture platformType(String type) {
                    this.platformType = type;
                    return this;
                }

                public int smpSize() {
                    return this.smpSize;
                }

                public Architecture smpSize(int size) {
                    this.smpSize = size;
                    return this;
                }

                public int smtSize() {
                    return this.smtSize;
                }

                public Architecture smtSize(int size) {
                    this.smtSize = size;
                    return this;
                }

                public String toString() {
                    return "Architecture [platformType=" + this.platformType + ", smpSize=" + this.smpSize + ", smtSize=" + this.smtSize + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.platformType == null ? 0 : this.platformType.hashCode());
                    result = 31 * result + this.smpSize;
                    result = 31 * result + this.smtSize;
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Architecture other = (Architecture)obj;
                    if (this.platformType == null ? other.platformType != null : !this.platformType.equals(other.platformType)) {
                        return false;
                    }
                    if (this.smpSize != other.smpSize) {
                        return false;
                    }
                    return this.smtSize == other.smtSize;
                }
            }

            @XmlType(name="SecurityData", propOrder={"certificationAuthority", "credentialDistinguishedName", "credentialsExpirationDate"})
            @XmlRootElement(name="SecurityData")
            public static class Security {
                @XmlElement(name="CA")
                private String certificationAuthority;
                @XmlElement(name="CredentialsDistinguishedName")
                private String credentialDistinguishedName;
                @XmlElement(name="CredentialsExpireOn")
                @XmlJavaTypeAdapter(value=DateFormatterAdapter.class)
                private Calendar credentialsExpirationDate;

                public String authority() {
                    return this.certificationAuthority;
                }

                public Security authority(String authority) {
                    this.certificationAuthority = authority;
                    return this;
                }

                public String distinguishedName() {
                    return this.credentialDistinguishedName;
                }

                public Security distinguishedName(String dn) {
                    this.credentialDistinguishedName = dn;
                    return this;
                }

                public Calendar expirationDate() {
                    return this.credentialsExpirationDate;
                }

                public Security expirationDate(Calendar date) {
                    this.credentialsExpirationDate = date;
                    return this;
                }

                public String toString() {
                    return "SecurityData [certificationAuthority=" + this.certificationAuthority + ", credentialDistinguishedName=" + this.credentialDistinguishedName + ", credentialsExpirationDate=" + Utils.toString(this.credentialsExpirationDate) + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.certificationAuthority == null ? 0 : this.certificationAuthority.hashCode());
                    result = 31 * result + (this.credentialDistinguishedName == null ? 0 : this.credentialDistinguishedName.hashCode());
                    result = 31 * result + (this.credentialsExpirationDate == null ? 0 : this.credentialsExpirationDate.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Security other = (Security)obj;
                    if (this.certificationAuthority == null ? other.certificationAuthority != null : !this.certificationAuthority.equals(other.certificationAuthority)) {
                        return false;
                    }
                    if (this.credentialDistinguishedName == null ? other.credentialDistinguishedName != null : !this.credentialDistinguishedName.equals(other.credentialDistinguishedName)) {
                        return false;
                    }
                    return !(this.credentialsExpirationDate == null ? other.credentialsExpirationDate != null : !this.credentialsExpirationDate.equals(other.credentialsExpirationDate));
                }
            }

            @XmlType(name="GHNType")
            @XmlEnum
            public static enum GHNType {
                Dynamic,
                Static,
                SelfCleaning;


                public String value() {
                    return this.toString();
                }

                public static GHNType fromValue(String v) {
                    return GHNType.valueOf(v);
                }
            }
        }
    }
}

