/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.GenericItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.OpenResolver;
import org.gcube.common.storagehub.client.dsl.VREFolderManager;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.client.proxies.UserManagerClient;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.types.SHUBUser;

public class StorageHubClient {
    protected WorkspaceManagerClient wsClient = (WorkspaceManagerClient)AbstractPlugin.workspace().build();
    protected ItemManagerClient itemclient = (ItemManagerClient)AbstractPlugin.item().build();
    protected GroupManagerClient groupClient = (GroupManagerClient)AbstractPlugin.groups().build();
    protected UserManagerClient userClient = (UserManagerClient)AbstractPlugin.users().build();

    public StorageHubClient() {
    }

    public StorageHubClient(URI uri) {
        this.wsClient = (WorkspaceManagerClient)AbstractPlugin.workspace().at(uri).build();
        this.itemclient = (ItemManagerClient)AbstractPlugin.item().at(uri).build();
        this.groupClient = (GroupManagerClient)AbstractPlugin.groups().at(uri).build();
        this.userClient = (UserManagerClient)AbstractPlugin.users().at(uri).build();
    }

    public void impersonate(String user) {
        this.wsClient.impersonate(user);
        this.itemclient.impersonate(user);
    }

    public FolderContainer getWSRoot() {
        return new FolderContainer(this.itemclient, (FolderItem)this.wsClient.getWorkspace(new String[0]));
    }

    public OpenResolver open(String id) throws StorageHubException {
        Item item = this.itemclient.get(id, new String[0]);
        return new OpenResolver(item, this.itemclient);
    }

    public FolderContainer openVREFolder() {
        return new FolderContainer(this.itemclient, (FolderItem)this.wsClient.getVreFolder(new String[0]));
    }

    public ListResolver getVREFolders() {
        return new ListResolver((onlyType, includeHidden, excludes) -> this.wsClient.getVreFolders(excludes), this.itemclient);
    }

    public VREFolderManager getVreFolderManager(String vreTitle) {
        return new VREFolderManager(this.wsClient, this.groupClient, vreTitle);
    }

    public VREFolderManager getVreFolderManager() {
        return new VREFolderManager(this.wsClient, this.groupClient, null);
    }

    public FolderContainer openTrash() {
        return new FolderContainer(this.itemclient, (FolderItem)this.wsClient.getTrashFolder(new String[0]));
    }

    public void emptyTrash() throws StorageHubException {
        this.wsClient.emptyTrash();
    }

    public long getTotalVolume() {
        return this.wsClient.getTotalVolume();
    }

    public long getTotalItemCount() {
        return this.wsClient.getTotalItemCount();
    }

    public GenericItemContainer restoreThrashItem(String trashItemId) throws StorageHubException {
        return new GenericItemContainer(this.itemclient, this.wsClient.restoreFromTrash(trashItemId, null));
    }

    public GenericItemContainer restoreThrashItem(String trashItemId, String destinationFolderId) throws StorageHubException {
        return new GenericItemContainer(this.itemclient, this.wsClient.restoreFromTrash(trashItemId, destinationFolderId));
    }

    public void createUserAccount(String userId) throws StorageHubException {
        this.userClient.createUser(userId);
    }

    public void deleteUserAccount(String userId) throws StorageHubException {
        this.userClient.removeUser(userId);
    }

    public List<SHUBUser> getUsers() throws StorageHubException {
        return this.userClient.getUsers();
    }

    public boolean userExists(String user) throws StorageHubException {
        return this.userClient.exists(user);
    }

    public String uploadFileOnVolatile(File file) throws StorageHubException {
        return this.wsClient.uploadFileToVolatile(file);
    }

    public String uploadFileOnVolatile(InputStream stream, String fileName) throws StorageHubException {
        return this.wsClient.uploadFileToVolatile(stream, fileName);
    }

    public String uploadFileOnVolatile(InputStream stream, String fileName, long size) throws StorageHubException {
        return this.wsClient.uploadFileToVolatile(stream, fileName, size);
    }
}

