/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import java.util.List;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;

public class VREFolderManager {
    private GroupManagerClient groupClient;
    private String vreTitle;

    protected VREFolderManager(WorkspaceManagerClient wsClient, GroupManagerClient groupClient, String vreTitle) {
        this.groupClient = groupClient;
        this.vreTitle = vreTitle;
    }

    public void removeUser(String userId) throws StorageHubException {
        this.groupClient.removeUserFromGroup(userId, this.vreTitle);
    }

    public void addUser(String userId) throws StorageHubException {
        this.groupClient.addUserToGroup(userId, this.vreTitle);
    }

    public List<String> getUsers() throws StorageHubException {
        return this.groupClient.getUsersOfGroup(this.vreTitle);
    }

    public void setAdmin(String userId) throws StorageHubException {
        this.groupClient.addAdmin(this.vreTitle, userId);
    }

    public void removeAdmin(String userId) throws StorageHubException {
        this.groupClient.removeAdmin(this.vreTitle, userId);
    }

    public List<String> getAdmins() throws StorageHubException {
        return this.groupClient.getAdmins(this.vreTitle);
    }

    public void createVRE(AccessType accessType, String folderOwner) throws StorageHubException {
        this.groupClient.createGroup(this.vreTitle, accessType, folderOwner);
    }

    public void createVRE(AccessType accessType, String folderOwner, boolean useDefaultStorage) throws StorageHubException {
        this.groupClient.createGroup(this.vreTitle, accessType, folderOwner, useDefaultStorage);
    }

    public void removeVRE() throws StorageHubException {
        this.groupClient.removeGroup(this.vreTitle);
    }
}

