/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl;

import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.publishing.gCatFeeder.service.engine.Infrastructure;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DatabaseConnectionDescriptor;
import org.gcube.data.publishing.gCatFeeder.utils.CommonUtils;
import org.gcube.data.publishing.gCatFeeder.utils.ContextUtils;
import org.gcube.data.publishing.gCatFeeder.utils.ISUtils;
import org.gcube.data.publishing.gCatFeeder.utils.TokenUtils;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfrastructureUtilsImpl
implements Infrastructure {
    private static final Logger log = LoggerFactory.getLogger(InfrastructureUtilsImpl.class);

    public String getCurrentToken() {
        return TokenUtils.getCurrentToken();
    }

    public String getCurrentContext() {
        return ContextUtils.getCurrentScope();
    }

    public String getClientID(String token) {
        try {
            return TokenUtils.getClientId((String)token);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get client id from " + token);
        }
    }

    public void setToken(String token) {
        TokenUtils.setToken((String)token);
    }

    public String getCurrentContextName() {
        return ContextUtils.getCurrentScopeName();
    }

    public String decrypt(String toDecrypt) {
        return CommonUtils.decryptString((String)toDecrypt);
    }

    public String encrypt(String toEncrypt) {
        return CommonUtils.encryptString((String)toEncrypt);
    }

    public DatabaseConnectionDescriptor queryForDatabase(String category, String name) throws InternalError {
        log.debug("Querying for DB {},{} under {}", new Object[]{category, name, this.getCurrentContext()});
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'");
        query.addCondition("$resource/Profile/Name/text() eq '" + name + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List found = client.submit((Query)query);
        if (found.size() == 0) {
            throw new InternalError("Unable to find DB " + category + "/" + name + " in " + this.getCurrentContext());
        }
        if (found.size() > 1) {
            log.warn("Multiple DB " + category + "/" + name + " in " + this.getCurrentContext());
        }
        ServiceEndpoint.AccessPoint point = (ServiceEndpoint.AccessPoint)((ServiceEndpoint)found.get(0)).profile().accessPoints().iterator().next();
        String url = "jdbc:postgresql://" + point.address() + "/" + point.name();
        DatabaseConnectionDescriptor toReturn = new DatabaseConnectionDescriptor(point.username(), url, CommonUtils.decryptString((String)point.password()));
        log.debug("Going to use DB : " + toReturn);
        return toReturn;
    }

    public Map<String, String> getEnvironmentConfigurationParameters() {
        return ISUtils.loadConfiguration();
    }
}

