/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.UUID;
import javax.inject.Inject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.publishing.gCatFeeder.service.engine.Infrastructure;
import org.gcube.data.publishing.gCatFeeder.service.engine.Storage;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InternalError;
import org.gcube.data.publishing.gCatFeeder.service.model.reports.ExecutionReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageImpl
implements Storage {
    private static final Logger log = LoggerFactory.getLogger(StorageImpl.class);
    protected static ObjectMapper mapper = new ObjectMapper();
    @Inject
    private Infrastructure infra;

    private final IClient getClient() {
        return new StorageClient("data-publishing", "gcat-feeder", this.infra.getClientID(this.infra.getCurrentToken()), AccessType.SHARED, MemoryType.PERSISTENT).getClient();
    }

    private final String putOntoStorage(File source) throws RemoteBackendException, FileNotFoundException {
        IClient client = this.getClient();
        log.debug("Uploading local file " + source.getAbsolutePath());
        String id = client.put(true).LFile((InputStream)new FileInputStream(source)).RFile(UUID.randomUUID().toString());
        log.debug("File uploaded. ID : " + id);
        String toReturn = client.getHttpUrl().RFile(id);
        log.debug("Created URL : " + toReturn);
        return toReturn;
    }

    protected File asFile(ExecutionReport report) throws InternalError {
        try {
            File f = File.createTempFile("report", ".json");
            String serialized = mapper.writeValueAsString((Object)report);
            Files.write(Paths.get(f.getAbsolutePath(), new String[0]), serialized.getBytes(), new OpenOption[0]);
            return f;
        }
        catch (IOException e) {
            throw new InternalError("Unable to rite report : ", (Throwable)e);
        }
    }

    public String storeReport(ExecutionReport report) throws InternalError {
        try {
            return this.putOntoStorage(this.asFile(report));
        }
        catch (FileNotFoundException | RemoteBackendException e) {
            throw new InternalError("Unable to store report ", e);
        }
    }
}

