package org.gcube.gcat.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.ws.rs.WebApplicationException;
import javax.xml.ws.WebServiceException;

import org.gcube.gcat.api.GCatConstants;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class Item extends GCatClient implements org.gcube.gcat.api.interfaces.Item<String,Void> {
	
	public Item() throws MalformedURLException {
		super(ITEMS);
	}
	
	public Item(URL enforcedServiceURL) throws MalformedURLException {
		super(enforcedServiceURL, ITEMS);
	}
	
	/**
	 * List the item in the organization correspondent to the current VRE.
	 * 
	 * If the client is entitled to run at VO or ROOT level the method return all the item in all the organization
	 * in the catalogue. To filter per organization used the method {@link #list(int, int, String)}
	 */
	@Override
	public String list(int limit, int offset) throws WebApplicationException {
		Map<String, String> queryParams = new HashMap<>();
		queryParams.put(GCatConstants.LIMIT_PARAMETER, String.valueOf(limit));
		queryParams.put(GCatConstants.OFFSET_PARAMETER, String.valueOf(offset));
		return super.list(queryParams);
	}
	
	/**
	 * List the item of a specific organization. 
	 * This API is only available if the client is entitles to run at VO and ROOT level.
	 */
	public String list(int limit, int offset, String organizationName) throws WebApplicationException {
		Map<String, String> queryParams = new HashMap<>();
		queryParams.put(GCatConstants.LIMIT_PARAMETER, String.valueOf(limit));
		queryParams.put(GCatConstants.OFFSET_PARAMETER, String.valueOf(offset));
		queryParams.put(GCatConstants.ORGANIZATION_PARAMETER, organizationName);
		return super.list(queryParams);
	}
	
	public String create(String json, boolean socialPost) {
		try {
			Map<String,String> queryParams = new HashMap<>();
			queryParams.put(GCatConstants.SOCIAL_POST_PARAMETER, String.valueOf(socialPost));
			return super.create(json, queryParams);
		}catch (WebApplicationException e) {
			throw e;
		}catch (Exception e) {
			throw new WebApplicationException(e);
		}
	}
	
	@Override
	public String create(String json) {
		return super.create(json);
	}

	@Override
	public String read(String name) {
		return super.read(name);
	}

	@Override
	public String update(String name, String json) {
		return super.update(json, name);
	}

	@Override
	public Void delete(String name) {
		super.delete(false, name);
		return null;
	}

	@Override
	public Void delete(String name, boolean purge) throws WebServiceException {
		super.delete(purge, name);
		return null;
	}

	@Override
	public Void purge(String name) throws WebServiceException {
		super.delete(true, name);
		return null;
	}
}
