/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.gcat.annotation.PATCH;
import org.gcube.gcat.persistence.ckan.CKANResource;
import org.gcube.gcat.rest.BaseREST;

@Path(value="items/{ITEM_ID}/resources")
public class Resource
extends BaseREST {
    protected static final String ITEM_ID_PARAMETER = "ITEM_ID";
    protected static final String RESOURCE_ID_PARAMETER = "RESOURCE_ID";
    protected static final String COLLECTION = "items/{ITEM_ID}/resources";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@PathParam(value="ITEM_ID") String itemID) {
        this.setCalledMethod("GET /items/{ITEM_ID}/resources");
        CKANResource ckanResource = new CKANResource(itemID);
        ckanResource.setName(itemID);
        return ckanResource.list();
    }

    @POST
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@PathParam(value="ITEM_ID") String itemID, String json) {
        this.setCalledMethod("POST /items/{ITEM_ID}/resources");
        CKANResource ckanResource = new CKANResource(itemID);
        return ckanResource.create(json);
    }

    @GET
    @Path(value="/{RESOURCE_ID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="ITEM_ID") String itemID, @PathParam(value="RESOURCE_ID") String resourceID) {
        this.setCalledMethod("GET /items/{ITEM_ID}/resources/{RESOURCE_ID}");
        CKANResource ckanResource = new CKANResource(itemID);
        ckanResource.setName(resourceID);
        return ckanResource.read();
    }

    @PUT
    @Path(value="/{RESOURCE_ID}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@PathParam(value="ITEM_ID") String itemID, @PathParam(value="RESOURCE_ID") String resourceID, String json) {
        this.setCalledMethod("PUT /items/{ITEM_ID}/resources/{RESOURCE_ID}");
        CKANResource ckanResource = new CKANResource(itemID);
        ckanResource.setName(resourceID);
        return ckanResource.update(json);
    }

    @PATCH
    @Path(value="/{RESOURCE_ID}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String patch(@PathParam(value="ITEM_ID") String itemID, @PathParam(value="RESOURCE_ID") String resourceID, String json) {
        this.setCalledMethod("PATCH /items/{ITEM_ID}/resources/{RESOURCE_ID}");
        CKANResource ckanResource = new CKANResource(itemID);
        ckanResource.setName(resourceID);
        return ckanResource.patch(json);
    }

    @DELETE
    @Path(value="/{RESOURCE_ID}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public void delete(@PathParam(value="ITEM_ID") String itemID, @PathParam(value="RESOURCE_ID") String resourceID) {
        this.setCalledMethod("DELETE /items/{ITEM_ID}/resources/{RESOURCE_ID}");
        CKANResource ckanResource = new CKANResource(itemID);
        ckanResource.setName(resourceID);
        ckanResource.delete(false);
    }
}

