/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import javax.cache.Cache;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datacatalogue.metadatadiscovery.DataCalogueMetadataFormatReader;
import org.gcube.datacatalogue.metadatadiscovery.bean.MetadataProfile;
import org.gcube.gcat.oldutils.CachesManager;
import org.gcube.gcat.rest.BaseREST;
import org.json.JSONObject;
import org.json.XML;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="profiles")
public class Profile
extends BaseREST {
    public static final String PROFILE_NAME_PARAMETER = "PROFILE_NAME";
    public static int PRETTY_PRINT_INDENT_FACTOR = 4;

    public static DataCalogueMetadataFormatReader getDataCalogueMetadataFormatReader() throws Exception {
        DataCalogueMetadataFormatReader reader;
        String context;
        Cache readerCache = CachesManager.getReaderCache();
        if (readerCache.containsKey((Object)(context = ScopeProvider.instance.get()))) {
            reader = (DataCalogueMetadataFormatReader)readerCache.get((Object)context);
        } else {
            reader = new DataCalogueMetadataFormatReader();
            readerCache.put((Object)context, (Object)reader);
        }
        return reader;
    }

    public static List<String> getProfilesNames() throws Exception {
        DataCalogueMetadataFormatReader reader = Profile.getDataCalogueMetadataFormatReader();
        ArrayList<String> toReturn = new ArrayList<String>();
        List listProfiles = reader.getListOfMetadataProfiles();
        if (listProfiles != null && !listProfiles.isEmpty()) {
            for (MetadataProfile profile : listProfiles) {
                toReturn.add(profile.getName());
            }
        }
        return toReturn;
    }

    public static String getProfileSource(String profileName) throws Exception {
        DataCalogueMetadataFormatReader reader = Profile.getDataCalogueMetadataFormatReader();
        List listProfiles = reader.getListOfMetadataProfiles();
        String xmlToReturn = null;
        if (listProfiles != null && !listProfiles.isEmpty()) {
            for (MetadataProfile profile : listProfiles) {
                if (!profile.getName().equals(profileName)) continue;
                xmlToReturn = reader.getMetadataFormatForMetadataProfile(profile).getMetadataSource();
                break;
            }
        }
        return xmlToReturn;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public String list() {
        this.setCalledMethod("GET /profiles");
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        try {
            List names = Profile.getProfilesNames();
            for (String name : names) {
                arrayNode.add(name);
            }
            return mapper.writeValueAsString((Object)arrayNode);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    @GET
    @Path(value="/{PROFILE_NAME}")
    @Produces(value={"application/xml", "application/json;charset=UTF-8"})
    public String read(@PathParam(value="PROFILE_NAME") String id, @DefaultValue(value="application/json") @HeaderParam(value="Accept") String accept) {
        this.setCalledMethod("GET /profiles/{PROFILE_NAME}");
        try {
            String profile = Profile.getProfileSource((String)id);
            if (accept.startsWith("application/xml")) {
                return profile;
            }
            JSONObject xmlJSONObj = XML.toJSONObject((String)profile);
            String jsonString = xmlJSONObj.toString(PRETTY_PRINT_INDENT_FACTOR);
            return jsonString;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }
}

