/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.gcat.utils.HTTPCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPCall {
    private static final Logger logger = LoggerFactory.getLogger(HTTPCall.class);
    protected static final String USER_AGENT_KEY = "User-Agent";
    protected static final String USER_AGENT_NAME = "ScienceCatalogue";
    public static final String PATH_SEPARATOR = "/";
    public static final String PARAM_STARTER = "?";
    public static final String PARAM_EQUALS = "=";
    public static final String PARAM_SEPARATOR = "&";
    public static final String UTF8 = "UTF-8";
    protected final String address;
    protected final String userAgent;
    protected Map<String, String> headers;
    protected boolean gCubeTargetService;

    public boolean isgCubeTargetService() {
        return this.gCubeTargetService;
    }

    public void setgCubeTargetService(boolean gCubeTargetService) {
        this.gCubeTargetService = gCubeTargetService;
    }

    public HTTPCall(String address) {
        this(address, USER_AGENT_NAME);
    }

    protected HTTPCall(String address, String userAgent) {
        this.address = address;
        this.userAgent = userAgent;
        this.gCubeTargetService = true;
        this.headers = new HashMap();
        this.addHeader(USER_AGENT_KEY, this.userAgent);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    protected String getParametersDataString(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (parameters == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String key : parameters.keySet()) {
            if (first) {
                first = false;
            } else {
                result.append(PARAM_SEPARATOR);
            }
            result.append(URLEncoder.encode(key, UTF8));
            result.append(PARAM_EQUALS);
            result.append(URLEncoder.encode(parameters.get(key), UTF8));
        }
        return result.toString();
    }

    protected URL getURL(String address, String path, String urlParameters) throws MalformedURLException {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(address);
        if (address.endsWith(PATH_SEPARATOR)) {
            if (path.startsWith(PATH_SEPARATOR)) {
                path = path.substring(1);
            }
        } else if (path.compareTo("") != 0 && !path.startsWith(PATH_SEPARATOR)) {
            stringWriter.append(PATH_SEPARATOR);
        }
        stringWriter.append(path);
        if (urlParameters != null) {
            stringWriter.append(PARAM_STARTER);
            stringWriter.append(urlParameters);
        }
        return this.getURL(stringWriter.toString());
    }

    protected URL getURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        if (url.getProtocol().compareTo("https") == 0) {
            url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getFile());
        }
        return url;
    }

    protected HttpURLConnection getConnection(String path, String urlParameters, HTTPMETHOD method, String body, InputStream inputStream, String contentType) throws Exception {
        URL url = this.getURL(this.address, path, urlParameters);
        return this.getConnection(url, method, body, inputStream, contentType);
    }

    public URL getFinalURL(URL url) {
        try {
            URL finalURL = url;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(false);
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            if (responseCode >= Response.Status.BAD_REQUEST.getStatusCode()) {
                Response.Status status = Response.Status.fromStatusCode((int)responseCode);
                throw new WebApplicationException(responseMessage, status);
            }
            if (responseCode == 302 || responseCode == 301 || responseCode == 303 || responseCode == Response.Status.TEMPORARY_REDIRECT.getStatusCode() || responseCode == 308) {
                finalURL = this.getURL(connection.getHeaderField("Location"));
                finalURL = this.getFinalURL(finalURL);
            }
            return finalURL;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected HttpURLConnection getConnection(URL url, HTTPMETHOD method, String body, InputStream inputStream, String contentType) throws Exception {
        DataOutputStream wr;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (this.gCubeTargetService) {
            if (SecurityTokenProvider.instance.get() == null) {
                if (ScopeProvider.instance.get() == null) {
                    throw new RuntimeException("Null Token and Scope. Please set your token first.");
                }
                connection.setRequestProperty("gcube-scope", ScopeProvider.instance.get());
            } else {
                connection.setRequestProperty("gcube-token", SecurityTokenProvider.instance.get());
            }
        }
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-type", contentType);
        for (String key : this.headers.keySet()) {
            connection.setRequestProperty(key, (String)this.headers.get(key));
        }
        connection.setRequestMethod(method.toString());
        if (inputStream != null && (method == HTTPMETHOD.POST || method == HTTPMETHOD.PUT)) {
            int len;
            wr = new DataOutputStream(connection.getOutputStream());
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                wr.write(buffer, 0, len);
            }
            wr.flush();
            wr.close();
        }
        if (body != null && (method == HTTPMETHOD.POST || method == HTTPMETHOD.PUT)) {
            wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(body);
            wr.flush();
            wr.close();
        }
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage();
        logger.trace("{} {} : {} - {}", new Object[]{method, connection.getURL(), responseCode, responseMessage});
        if (responseCode == 302 || responseCode == 301 || responseCode == 303 || responseCode == Response.Status.TEMPORARY_REDIRECT.getStatusCode() || responseCode == 308) {
            URL redirectURL = this.getURL(connection.getHeaderField("Location"));
            logger.trace("{} is going to be redirect to {}", (Object)url.toString(), (Object)redirectURL.toString());
            connection = this.getConnection(redirectURL, method, body, inputStream, contentType);
        }
        return connection;
    }

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public String call(String path, HTTPMETHOD method, Map<String, String> parameters, String contentType) {
        return this.call(path, method, parameters, null, contentType);
    }

    public String call(String path, HTTPMETHOD method, String body, String contentType) {
        return this.call(path, method, null, body, contentType);
    }

    public String call(String path, HTTPMETHOD method, Map<String, String> parameters, String body, String contentType) {
        return this.call(path, method, body, null, parameters, contentType);
    }

    public String call(String path, HTTPMETHOD method, InputStream inputStream, Map<String, String> parameters, String contentType) {
        return this.call(path, method, null, inputStream, parameters, contentType);
    }

    private String call(String path, HTTPMETHOD method, String body, InputStream inputStream, Map<String, String> parameters, String contentType) {
        try {
            String urlParameters = this.getParametersDataString(parameters);
            HttpURLConnection connection = this.getConnection(path, urlParameters, method, body, inputStream, contentType);
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            logger.info("{} {} : {} - {}", new Object[]{method, connection.getURL(), responseCode, responseMessage});
            if (responseCode >= Response.Status.BAD_REQUEST.getStatusCode()) {
                try {
                    StringBuilder result = this.getStringBuilder(connection.getErrorStream());
                    String res = result.toString();
                    logger.trace("Server returned content : {}", (Object)res);
                    return res;
                }
                catch (Exception e) {
                    Response.Status status = Response.Status.fromStatusCode((int)responseCode);
                    throw new WebApplicationException(responseMessage, status);
                }
            }
            StringBuilder result = this.getStringBuilder(connection.getInputStream());
            String res = result.toString();
            logger.trace("Server returned content : {}", (Object)res);
            connection.disconnect();
            return res;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

