/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import org.gcube.gcat.persistence.ckan.CKAN;

/*
 * Exception performing whole class analysis ignored.
 */
public class CKANGroup
extends CKAN {
    public static final String GROUP_LIST = "/api/3/action/group_list";
    public static final String GROUP_CREATE = "/api/3/action/group_create";
    public static final String GROUP_SHOW = "/api/3/action/group_show";
    public static final String GROUP_UPDATE = "/api/3/action/group_update";
    public static final String GROUP_PATCH = "/api/3/action/group_patch";
    public static final String GROUP_DELETE = "/api/3/action/group_delete";
    public static final String GROUP_PURGE = "/api/3/action/group_purge";
    public static final String GROUPS_KEY = "groups";

    public CKANGroup() {
        this.LIST = "/api/3/action/group_list";
        this.CREATE = "/api/3/action/group_create";
        this.READ = "/api/3/action/group_show";
        this.UPDATE = "/api/3/action/group_update";
        this.PATCH = "/api/3/action/group_patch";
        this.DELETE = "/api/3/action/group_delete";
        this.PURGE = "/api/3/action/group_purge";
    }

    private static String fromGroupTitleToName(String groupName) {
        if (groupName == null) {
            return null;
        }
        String regexGroupNameTransform = "[^A-Za-z0-9-]";
        String modified = groupName.trim().replaceAll(regexGroupNameTransform, "-").replaceAll("-+", "-").toLowerCase();
        if (modified.startsWith("-")) {
            modified = modified.substring(1);
        }
        if (modified.endsWith("-")) {
            modified = modified.substring(0, modified.length() - 1);
        }
        return modified;
    }

    public static String getCKANGroupName(String name) {
        return CKANGroup.fromGroupTitleToName((String)name);
    }

    public String create() throws WebApplicationException {
        try {
            ObjectNode objectNode = this.mapper.createObjectNode();
            objectNode.put("name", CKANGroup.getCKANGroupName((String)this.name));
            objectNode.put("title", this.name);
            objectNode.put("display_name", this.name);
            objectNode.put("description", "");
            return super.create(this.mapper.writeValueAsString((Object)objectNode));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public List<String> getGroups() {
        ArrayNode arrayNode;
        JsonNode jsonNode;
        if (this.result == null) {
            this.read();
        }
        ArrayList<String> groups = new ArrayList<String>();
        if (this.result.has("groups") && (jsonNode = this.result.get("groups")).isArray() && (arrayNode = (ArrayNode)jsonNode).size() > 0) {
            Iterator iterator = arrayNode.iterator();
            while (iterator.hasNext()) {
                groups.add(((JsonNode)iterator.next()).asText());
            }
        }
        return groups;
    }
}

