package org.gcube.gcat.social;

import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.ws.rs.InternalServerErrorException;

import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.gcat.utils.HTTPUtility;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;

public class PortalUser {
	
	protected static final String RESPONSE_SUCCESS_KEY = "success";
	protected static final String RESPONSE_MESSAGE_KEY = "message";
	protected static final String RESPONSE_RESULT_KEY = "result";
	
	// https://wiki.gcube-system.org/gcube/Social_Networking_Service
	// private static final String SOCIAL_SERVICE_GET_GCUBE_USER_PROFILE_PATH = "2/users/get-profile";
	
	protected static final String SOCIAL_SERVICE_GET_OAUTH_USER_PROFILE_PATH = "2/users/get-oauth-profile";
	
	// This key contains the fullname
	protected static final String OAUTH_USER_PROFILE_NAME_KEY = "name";
	protected static final String OAUTH_USER_PROFILE_EMAIL_KEY = "email";
	protected static final String OAUTH_USER_PROFILE_JOB_TITLE_KEY = "job_title";
	protected static final String OAUTH_USER_PROFILE_ROLES_KEY = "roles";
	
	protected final ObjectMapper objectMapper;
	
	// private JsonNode gCubeUserProfile;
	protected JsonNode oAuthUserProfile;
	
	protected String fullName;
	protected String eMail;
	protected String jobTitle;
	
	protected List<String> roles;
	
	public PortalUser() {
		this.objectMapper = new ObjectMapper();
	}
	
	/*
	private JsonNode validateGCubeUserProfileResponse(JsonNode jsonNode) {
		if(jsonNode.get(RESPONSE_SUCCESS_KEY).asBoolean()) {
			return jsonNode.get(RESPONSE_RESULT_KEY);
		} else {
			String message = jsonNode.get(RESPONSE_MESSAGE_KEY).asText();
			throw new InternalServerErrorException(message);
		}
	}
	
	private JsonNode getGCubeUserProfile() throws Exception {
		if(gCubeUserProfile == null) {
			String socialServiceBasePath = SocialServiceDiscovery.getCurrentScopeSocialServiceBasePath();
			GXHTTPStringRequest gxhttpStringRequest = HTTPUtility.createGXHTTPStringRequest(socialServiceBasePath,
					SOCIAL_SERVICE_GET_GCUBE_USER_PROFILE_PATH, false);
			HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
			String ret = HTTPUtility.getResultAsString(httpURLConnection);
			JsonNode jsonNode = objectMapper.readTree(ret);
			gCubeUserProfile = validateGCubeUserProfileResponse(jsonNode); 
		}
		return gCubeUserProfile;
	}
	*/
	
	public JsonNode getOAuthUserProfile() {
		if(oAuthUserProfile == null) {
			try {
				String socialServiceBasePath = SocialService.getSocialService().getServiceBasePath();
				
				GXHTTPStringRequest gxhttpStringRequest = HTTPUtility.createGXHTTPStringRequest(socialServiceBasePath,
						SOCIAL_SERVICE_GET_OAUTH_USER_PROFILE_PATH, false);
				HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
				
				String ret = HTTPUtility.getResultAsString(httpURLConnection);
				
				oAuthUserProfile = objectMapper.readTree(ret);
			} catch(Exception e) {
				throw new InternalServerErrorException(e);
			}
		}
		return oAuthUserProfile;
	}
	
	public String getFullName() {
		if(fullName == null) {
			fullName = getOAuthUserProfile().get(OAUTH_USER_PROFILE_NAME_KEY).asText();
		}
		return fullName;
	}
	
	public String getEMail() {
		if(eMail == null) {
			eMail = getOAuthUserProfile().get(OAUTH_USER_PROFILE_EMAIL_KEY).asText();
		}
		return eMail;
	}
	
	public List<String> getRoles() {
		if(roles == null) {
			JsonNode jsonNode = getOAuthUserProfile().get(OAUTH_USER_PROFILE_ROLES_KEY);
			roles = new ArrayList<String>();
			if(jsonNode.isArray()) {
				ArrayNode arrayNode = (ArrayNode) jsonNode;
				if(arrayNode.size() > 0) {
					Iterator<JsonNode> iterator = arrayNode.iterator();
					while(iterator.hasNext()) {
						roles.add(iterator.next().asText());
					}
				}
			}
		}
		return roles;
	}
	
	public String getJobTitle() {
		if(jobTitle == null) {
			jobTitle = getOAuthUserProfile().get(OAUTH_USER_PROFILE_JOB_TITLE_KEY).asText();
		}
		return jobTitle;
	}
	
}
