/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.gcat.utils.ContextUtility;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CKANInstance {
    private static final Logger logger = LoggerFactory.getLogger(CKANInstance.class);
    private static final String RUNTIME_CATALOGUE_RESOURCE_NAME = "CKanDataCatalogue";
    private static final String PLATFORM_CATALOGUE_NAME = "Tomcat";
    private static final String IS_MASTER_ROOT_KEY_PROPERTY = "IS_ROOT_MASTER";
    private static final String API_KEY_PROPERTY = "API_KEY";
    private static final String SOCIAL_POST = "SOCIAL_POST";
    private static final String ALERT_USERS_ON_POST_CREATION = "ALERT_USERS_ON_POST_CREATION";
    private static final String URL_RESOLVER = "URL_RESOLVER";
    private static final Map<String, CKANInstance> ckanInstancePerScope = new HashMap();
    protected String ckanURL;
    protected String sysAdminToken;
    protected boolean socialPostEnabled;
    protected boolean notificationToUsersEnabled;
    protected String uriResolverURL;

    public static CKANInstance getInstance() {
        CKANInstance ckanInstance = (CKANInstance)ckanInstancePerScope.get(ContextUtility.getCurrentContext());
        if (ckanInstance == null) {
            ckanInstance = new CKANInstance();
            ckanInstance.getConfigurationFromIS();
            ckanInstancePerScope.put(ContextUtility.getCurrentContext(), ckanInstance);
        }
        return ckanInstance;
    }

    private static List<ServiceEndpoint> getServiceEndpoints() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'CKanDataCatalogue'");
        query.addCondition("$resource/Profile/Platform/Name/text() eq 'Tomcat'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        if (serviceEndpoints.size() == 0) {
            logger.error("There is no {} having name {} and Platform {} in this context.", new Object[]{ServiceEndpoint.class.getSimpleName(), "CKanDataCatalogue", "Tomcat"});
            throw new InternalServerErrorException("No CKAN configuration on IS");
        }
        return serviceEndpoints;
    }

    private void getConfigurationFromIS() {
        try {
            List serviceEndpoints = CKANInstance.getServiceEndpoints();
            ServiceEndpoint serviceEndpoint = null;
            if (serviceEndpoints.size() > 1) {
                logger.info("Too many {} having name {} in this context. Looking for the one that has the property {}", new Object[]{ServiceEndpoint.class.getSimpleName(), "CKanDataCatalogue", "IS_ROOT_MASTER"});
                block3: for (ServiceEndpoint se : serviceEndpoints) {
                    for (ServiceEndpoint.AccessPoint accessPoint : se.profile().accessPoints()) {
                        ServiceEndpoint.Property entry = (ServiceEndpoint.Property)accessPoint.propertyMap().get("IS_ROOT_MASTER");
                        String isMaster = entry != null ? entry.value() : null;
                        if (isMaster == null || !isMaster.equals("true")) continue;
                        serviceEndpoint = se;
                        continue block3;
                    }
                }
                if (serviceEndpoint == null) {
                    throw new InternalServerErrorException("Too many CKAN configuration on IS and no one with MASTER property");
                }
            } else {
                serviceEndpoint = (ServiceEndpoint)serviceEndpoints.get(0);
            }
            for (ServiceEndpoint.AccessPoint accessPoint : serviceEndpoint.profile().accessPoints()) {
                this.ckanURL = accessPoint.address();
                this.sysAdminToken = ((ServiceEndpoint.Property)accessPoint.propertyMap().get("API_KEY")).value();
                this.sysAdminToken = StringEncrypter.getEncrypter().decrypt(this.sysAdminToken);
                this.socialPostEnabled = true;
                if (accessPoint.propertyMap().containsKey("SOCIAL_POST") && ((ServiceEndpoint.Property)accessPoint.propertyMap().get("SOCIAL_POST")).value().trim().equalsIgnoreCase("false")) {
                    this.socialPostEnabled = false;
                }
                this.notificationToUsersEnabled = false;
                if (accessPoint.propertyMap().containsKey("ALERT_USERS_ON_POST_CREATION") && ((ServiceEndpoint.Property)accessPoint.propertyMap().get("ALERT_USERS_ON_POST_CREATION")).value().trim().equalsIgnoreCase("true")) {
                    this.notificationToUsersEnabled = true;
                }
                if (!accessPoint.propertyMap().containsKey("URL_RESOLVER")) continue;
                this.uriResolverURL = ((ServiceEndpoint.Property)accessPoint.propertyMap().get("URL_RESOLVER")).value();
            }
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Error while getting configuration on IS", (Throwable)e);
        }
    }

    public String getUriResolverURL() throws Exception {
        return this.uriResolverURL;
    }

    public String getCKANURL() {
        return this.ckanURL;
    }

    public boolean isSocialPostEnabled() throws Exception {
        return this.socialPostEnabled;
    }

    public boolean isNotificationToUsersEnabled() throws Exception {
        return this.notificationToUsersEnabled;
    }

    public String getSysAdminToken() throws Exception {
        return this.sysAdminToken;
    }
}

