/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.gcat.persistence.ckan.CKANInstance;
import org.gcube.gcat.utils.ContextUtility;

public class URIResolver {
    private static final String CATALOGUE_CONTEXT = "gcube_scope";
    private static final String ENTITY_TYPE = "entity_context";
    private static final String ENTITY_NAME = "entity_name";
    private static final String DATASET = "dataset";
    protected ObjectMapper mapper = new ObjectMapper();

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    public String getCatalogueItemURL(String name) {
        try {
            String uriResolverURL = CKANInstance.getInstance().getUriResolverURL();
            ObjectNode requestContent = this.mapper.createObjectNode();
            requestContent.put(CATALOGUE_CONTEXT, ContextUtility.getCurrentContext());
            requestContent.put(ENTITY_TYPE, DATASET);
            requestContent.put(ENTITY_NAME, name);
            GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)uriResolverURL);
            gxhttpStringRequest.from("gCat");
            gxhttpStringRequest.header("Content-Type", "application/json");
            gxhttpStringRequest.isExternalCall(true);
            String body = this.mapper.writeValueAsString((Object)requestContent);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.post(body);
            if (httpURLConnection.getResponseCode() != 200) {
                throw new InternalServerErrorException("Unable to get Item URL via URI Resolver");
            }
            String url = this.getStringBuilder(httpURLConnection.getInputStream()).toString();
            return url;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

