/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.social;

import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.gcat.social.SocialService;
import org.gcube.gcat.utils.HTTPUtility;

public class PortalUser {
    protected static final String RESPONSE_SUCCESS_KEY = "success";
    protected static final String RESPONSE_MESSAGE_KEY = "message";
    protected static final String RESPONSE_RESULT_KEY = "result";
    protected static final String SOCIAL_SERVICE_GET_OAUTH_USER_PROFILE_PATH = "2/users/get-oauth-profile";
    protected static final String OAUTH_USER_PROFILE_NAME_KEY = "name";
    protected static final String OAUTH_USER_PROFILE_EMAIL_KEY = "email";
    protected static final String OAUTH_USER_PROFILE_JOB_TITLE_KEY = "job_title";
    protected static final String OAUTH_USER_PROFILE_ROLES_KEY = "roles";
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected JsonNode oAuthUserProfile;
    protected String fullName;
    protected String eMail;
    protected String jobTitle;
    protected List<String> roles;

    public JsonNode getOAuthUserProfile() {
        if (this.oAuthUserProfile == null) {
            try {
                String socialServiceBasePath = SocialService.getSocialService().getServiceBasePath();
                GXHTTPStringRequest gxhttpStringRequest = HTTPUtility.createGXHTTPStringRequest((String)socialServiceBasePath, (String)SOCIAL_SERVICE_GET_OAUTH_USER_PROFILE_PATH, (boolean)false);
                HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
                String ret = HTTPUtility.getResultAsString((HttpURLConnection)httpURLConnection);
                this.oAuthUserProfile = this.objectMapper.readTree(ret);
            }
            catch (Exception e) {
                throw new InternalServerErrorException("Unable to retrive Infrastructure User Information from Social Service", (Throwable)e);
            }
        }
        return this.oAuthUserProfile;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.getOAuthUserProfile().get(OAUTH_USER_PROFILE_NAME_KEY).asText();
        }
        return this.fullName;
    }

    public String getEMail() {
        if (this.eMail == null) {
            this.eMail = this.getOAuthUserProfile().get(OAUTH_USER_PROFILE_EMAIL_KEY).asText();
        }
        return this.eMail;
    }

    public List<String> getRoles() {
        if (this.roles == null) {
            ArrayNode arrayNode;
            JsonNode jsonNode = this.getOAuthUserProfile().get(OAUTH_USER_PROFILE_ROLES_KEY);
            this.roles = new ArrayList();
            if (jsonNode.isArray() && (arrayNode = (ArrayNode)jsonNode).size() > 0) {
                Iterator iterator = arrayNode.iterator();
                while (iterator.hasNext()) {
                    this.roles.add(((JsonNode)iterator.next()).asText());
                }
            }
        }
        return this.roles;
    }

    public String getJobTitle() {
        if (this.jobTitle == null) {
            this.jobTitle = this.getOAuthUserProfile().get(OAUTH_USER_PROFILE_JOB_TITLE_KEY).asText();
        }
        return this.jobTitle;
    }
}

