package org.gcube.gcat.persistence.ckan;

import javax.ws.rs.InternalServerErrorException;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class CKANUtility {
	
	public static String getSysAdminAPI() {
		try {
			return CKANInstance.getInstance().getSysAdminToken();
		} catch(Exception e) {
			throw new InternalServerErrorException(e);
		}
	}
	
	public static String getApiKey() {
		try {
			CKANUser ckanUser = CKANUserCache.getCurrrentCKANUser();
			return ckanUser.getApiKey();
		} catch(Exception e) {
			throw new InternalServerErrorException(e);
		}
	}
	
}
